/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentFolderBaseImpl
extends RootModelComponentBase
implements ContentFolder,
Comparable<ContentFolderBaseImpl> {
    @NonNls
    public static final String URL_ATTRIBUTE = "url";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.SimpleContentFolderBaseImpl");
    private final VirtualFilePointer myFilePointer;
    protected final ContentEntryImpl myContentEntry;

    ContentFolderBaseImpl(@NotNull VirtualFile file2, @NotNull ContentEntryImpl contentEntry) {
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(file2, (Disposable)this, this.getRootModel().getRootsChangedListener());
    }

    ContentFolderBaseImpl(@NotNull String url, @NotNull ContentEntryImpl contentEntry) {
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, this.getRootModel().getRootsChangedListener());
    }

    protected ContentFolderBaseImpl(@NotNull ContentFolderBaseImpl that, @NotNull ContentEntryImpl contentEntry) {
        this(that.myFilePointer, contentEntry);
    }

    ContentFolderBaseImpl(@NotNull Element element, @NotNull ContentEntryImpl contentEntry) throws InvalidDataException {
        this(ContentFolderBaseImpl.getUrlFrom(element), contentEntry);
    }

    protected ContentFolderBaseImpl(@NotNull VirtualFilePointer filePointer, @NotNull ContentEntryImpl contentEntry) {
        super(contentEntry.getRootModel());
        this.myContentEntry = contentEntry;
        this.myFilePointer = VirtualFilePointerManager.getInstance().duplicate(filePointer, (Disposable)this, this.getRootModel().getRootsChangedListener());
    }

    @NotNull
    private static String getUrlFrom(@NotNull Element element) throws InvalidDataException {
        String url = element.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    public VirtualFile getFile() {
        if (!this.myFilePointer.isValid()) {
            return null;
        }
        return this.myFilePointer.getFile();
    }

    @NotNull
    public ContentEntry getContentEntry() {
        return this.myContentEntry;
    }

    protected void writeFolder(@NotNull Element element, @NotNull String elementName) {
        LOG.assertTrue(element.getName().equals(elementName));
        element.setAttribute(URL_ATTRIBUTE, this.myFilePointer.getUrl());
    }

    @NotNull
    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        return this.getUrl().compareTo(folder.getUrl());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContentFolderBaseImpl)) {
            return false;
        }
        return this.compareTo((ContentFolderBaseImpl)obj) == 0;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Nullable
    public String toString() {
        return this.myFilePointer == null ? null : this.getUrl();
    }
}

