/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfoWithExcludePatterns
extends DirectoryInfoImpl {
    private static final Logger LOG = Logger.getInstance(DirectoryInfoWithExcludePatterns.class);
    @Nullable
    private final FileTypeAssocTable<Boolean> myContentExcludePatterns;
    @Nullable
    private final Condition<? super VirtualFile> myLibraryExcludeCondition;

    public DirectoryInfoWithExcludePatterns(@NotNull VirtualFile root, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, @Nullable SourceFolder sourceFolder, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, @Nullable FileTypeAssocTable<Boolean> contentExcludePatterns, @Nullable Condition<? super VirtualFile> libraryExcludeCondition, @Nullable String unloadedModuleName) {
        super(root, module, contentRoot, sourceRoot, sourceFolder, libraryClassRoot, inModuleSource, inLibrarySource, isExcluded, unloadedModuleName);
        this.myContentExcludePatterns = contentExcludePatterns;
        this.myLibraryExcludeCondition = libraryExcludeCondition;
        LOG.assertTrue(this.myContentExcludePatterns != null || this.myLibraryExcludeCondition != null, (Object)("Directory info of '" + root + "' with exclude patterns have no any exclude patterns: " + this.toString()));
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        return this.myInLibrarySource && !this.isExcludedByCondition(file2, this.myLibraryExcludeCondition);
    }

    private boolean isExcludedByCondition(@NotNull VirtualFile file2, @Nullable Condition<? super VirtualFile> condition) {
        VirtualFile current;
        if (condition == null) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file2); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            if (!condition.value((Object)current)) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file2 + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    private boolean isExcludedByPatterns(@NotNull VirtualFile file2, @Nullable FileTypeAssocTable<Boolean> patterns) {
        return patterns != null && this.isExcludedByCondition(file2, (Condition<? super VirtualFile>)((Condition)f -> patterns.findAssociatedFileType(f.getNameSequence()) != null));
    }

    private static VirtualFile getPhysicalFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        VirtualFile current;
        boolean inContent;
        if (this.myExcluded) {
            return true;
        }
        if (this.myLibraryExcludeCondition == null && this.myContentExcludePatterns == null) {
            LOG.error("Directory info of '" + this.getRoot() + "' with exclude patterns have no any exclude patterns: " + this.toString());
            return false;
        }
        boolean bl = inContent = this.getContentRoot() != null;
        if (!inContent && !this.myInLibrarySource) {
            return false;
        }
        for (current = DirectoryInfoWithExcludePatterns.getPhysicalFile(file2); current != null && !this.myRoot.equals(current); current = current.getParent()) {
            boolean excludedFromLibrary;
            CharSequence name = current.getNameSequence();
            boolean excludedFromModule = this.myContentExcludePatterns != null && this.myContentExcludePatterns.findAssociatedFileType(name) != null;
            boolean bl2 = excludedFromLibrary = this.myLibraryExcludeCondition != null && this.myLibraryExcludeCondition.value((Object)current);
            if (inContent && !excludedFromModule || this.myInLibrarySource && !excludedFromLibrary) continue;
            return true;
        }
        if (current == null) {
            LOG.error("File " + file2 + " is not under this directory (" + this.myRoot + ")");
        }
        return false;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file2) {
        return this.myInModuleSource && !this.isExcludedByPatterns(file2, this.myContentExcludePatterns);
    }
}

