/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    private final VirtualFileFilter myContentFilter = file2 -> {
        assert (file2 != null);
        return (Boolean)ReadAction.compute(() -> !this.isScopeDisposed() && this.isInContent(file2));
    };

    FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContent(@NotNull ContentIterator processor2) {
        return this.iterateContent(processor2, null);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2, @Nullable VirtualFileFilter customFilter) {
        VirtualFileFilter filter = customFilter != null ? file2 -> this.myContentFilter.accept(file2) && customFilter.accept(file2) : this.myContentFilter;
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor2, filter);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        return this.iterateContentUnderDirectory(dir, processor2, null);
    }

    protected boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType = this.myDirectoryIndex.getSourceRootType(info);
        return rootType != null && rootType.isForTests();
    }

    private static boolean iterateContentUnderDirectoryWithFilter(@NotNull VirtualFile dir, @NotNull ContentIterator iterator, @NotNull VirtualFileFilter filter) {
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)filter, (ContentIterator)iterator);
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        return this.myDirectoryIndex.getInfoForFile(file2);
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    @NotNull
    protected static VirtualFile[][] getModuleContentAndSourceRoots(@NotNull Module module) {
        return new VirtualFile[][]{ModuleRootManager.getInstance((Module)module).getContentRoots(), ModuleRootManager.getInstance((Module)module).getSourceRoots()};
    }
}

