/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="NewModuleRootManager", storages={@Storage(value="$MODULE_FILE$"), @Storage(storageClass=ClasspathStorage.class)}, useLoadedStateAsExisting=false)
public class ModuleRootManagerComponent
extends ModuleRootManagerImpl
implements PersistentStateComponentWithModificationTracker<ModuleRootManagerImpl.ModuleRootManagerState>,
StateStorageChooserEx {
    public ModuleRootManagerComponent(Module module, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        super(module, projectRootManager, filePointerManager);
    }

    @NotNull
    public StateStorageChooserEx.Resolution getResolution(@NotNull Storage storage2, @NotNull StateStorageOperation operation) {
        boolean isEffectiveStorage;
        boolean isClasspathStorage = storage2.storageClass() == ClasspathStorage.class;
        boolean bl = isEffectiveStorage = ClassPathStorageUtil.isClasspathStorage(this.getModule()) == isClasspathStorage;
        if (operation == StateStorageOperation.READ) {
            return isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : StateStorageChooserEx.Resolution.SKIP;
        }
        return isEffectiveStorage ? StateStorageChooserEx.Resolution.DO : (isClasspathStorage ? StateStorageChooserEx.Resolution.SKIP : StateStorageChooserEx.Resolution.CLEAR);
    }

    public long getStateModificationCount() {
        Module module = this.getModule();
        if (!module.isLoaded() || !(module instanceof ModuleEx)) {
            return this.myModificationTracker.getModificationCount();
        }
        long[] result2 = new long[]{this.myModificationTracker.getModificationCount()};
        result2[0] = result2[0] + ((ModuleEx)module).getOptionsModificationCount();
        SmartList handledLibraryTables = new SmartList();
        this.getRootModel().orderEntries().forEachLibrary(arg_0 -> this.lambda$getStateModificationCount$0((List)handledLibraryTables, result2, arg_0));
        return result2[0] + this.myRootModel.getStateModificationCount();
    }

    private /* synthetic */ boolean lambda$getStateModificationCount$0(List handledLibraryTables, long[] result2, Library library) {
        LibraryTable table = library.getTable();
        if (table instanceof LibraryTableBase && !handledLibraryTables.contains(table.getTableLevel())) {
            handledLibraryTables.add(table.getTableLevel());
            long count = ((LibraryTableBase)table).getStateModificationCount();
            if (count > 0L && Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
                LOG.error("modification count changed due to library  " + library.getName() + " change (" + count + "), module " + this.getModule().getName());
            }
            result2[0] = result2[0] + count;
        }
        return true;
    }
}

