/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderEnumeratorBase");
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    boolean myRecursively;
    boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<? super OrderEntry> myCondition;
    RootModelProvider myModulesProvider;
    private final OrderRootsCache myCache;

    OrderEnumeratorBase(@Nullable OrderRootsCache cache) {
        this.myCache = cache;
    }

    @NotNull
    static List<OrderEnumerationHandler> getCustomHandlers(@NotNull Module module) {
        SmartList customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        return customHandlers == null ? Collections.emptyList() : customHandlers;
    }

    @NotNull
    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        return this;
    }

    @NotNull
    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        return this;
    }

    @NotNull
    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        return this;
    }

    @NotNull
    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        return this;
    }

    @NotNull
    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        return this;
    }

    @NotNull
    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        return this;
    }

    @NotNull
    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        return this;
    }

    @NotNull
    public OrderEnumerator recursively() {
        this.myRecursively = true;
        return this;
    }

    @NotNull
    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        return this;
    }

    @NotNull
    public OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> condition) {
        this.myCondition = condition;
        return this;
    }

    @NotNull
    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        this.myModulesProvider = provider;
        return this;
    }

    @NotNull
    public OrderRootsEnumerator classes() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
    }

    @NotNull
    public OrderRootsEnumerator sources() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        return new OrderRootsEnumeratorImpl(this, rootType);
    }

    @NotNull
    public OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        return new OrderRootsEnumeratorImpl(this, rootTypeProvider);
    }

    ModuleRootModel getRootModel(@NotNull Module module) {
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance((Module)module);
    }

    @NotNull
    OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, (Object)"Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, (Object)"Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, (Object)"Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        return this.myCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    public boolean shouldRecurse(@NotNull ModuleOrderEntry entry, @NotNull List<? extends OrderEnumerationHandler> handlers) {
        ProcessEntryAction action = this.shouldAddOrRecurse((OrderEntry)entry, true, handlers);
        return action.type == ProcessEntryActionType.RECURSE;
    }

    @NotNull
    private ProcessEntryAction shouldAddOrRecurse(@NotNull OrderEntry entry, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        ModuleOrderEntry moduleOrderEntry;
        Module depModule;
        boolean exported;
        OrderEnumerationHandler handler2;
        if (this.myCondition != null && !this.myCondition.value((Object)entry)) {
            return ProcessEntryAction.SKIP;
        }
        if (entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel)) {
            return ProcessEntryAction.SKIP;
        }
        if (this.myWithoutLibraries && entry instanceof LibraryOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        if (this.myWithoutDepModules) {
            if (!this.myRecursively && entry instanceof ModuleOrderEntry) {
                return ProcessEntryAction.SKIP;
            }
            if (entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) {
                return ProcessEntryAction.SKIP;
            }
        }
        if (this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        Iterator<? extends OrderEnumerationHandler> iterator = customHandlers.iterator();
        while (iterator.hasNext() && (shouldAdd = (handler2 = iterator.next()).shouldAddDependency(entry, (OrderEnumeratorSettings)this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
        }
        if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) {
            return ProcessEntryAction.SKIP;
        }
        boolean bl = exported = !(entry instanceof JdkOrderEntry);
        if (entry instanceof ExportableOrderEntry) {
            ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                boolean forTestCompile;
                DependencyScope scope = exportableEntry.getScope();
                boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && OrderEnumeratorBase.shouldAddRuntimeDependenciesToTestCompilationClasspath(customHandlers);
                if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile) {
                    return ProcessEntryAction.SKIP;
                }
                if (this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime()) {
                    return ProcessEntryAction.SKIP;
                }
                if (this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) {
                    return ProcessEntryAction.SKIP;
                }
            }
            exported = exportableEntry.isExported();
        }
        if (!exported) {
            if (this.myExportedOnly) {
                return ProcessEntryAction.SKIP;
            }
            if (this.myRecursivelyExportedOnly && !firstLevel) {
                return ProcessEntryAction.SKIP;
            }
        }
        if (this.myRecursively && entry instanceof ModuleOrderEntry && (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) != null && OrderEnumeratorBase.shouldProcessRecursively(customHandlers)) {
            return ProcessEntryAction.RECURSE(depModule);
        }
        if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry) {
            return ProcessEntryAction.SKIP;
        }
        return ProcessEntryAction.PROCESS;
    }

    protected void processEntries(@NotNull ModuleRootModel rootModel, @NotNull PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>> processor2, @Nullable Set<? super Module> processed2, boolean firstLevel, @NotNull List<OrderEnumerationHandler> customHandlers) {
        if (processed2 != null && !processed2.add((Module)rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ProcessEntryAction action = this.shouldAddOrRecurse(entry, firstLevel, customHandlers);
            if (action.type == ProcessEntryActionType.SKIP) continue;
            if (action.type == ProcessEntryActionType.RECURSE) {
                this.processEntries(this.getRootModel(action.recurseOnModule), processor2, processed2, false, customHandlers);
                continue;
            }
            assert (action.type == ProcessEntryActionType.PROCESS);
            if (processor2.process((Object)entry, customHandlers)) continue;
            return;
        }
    }

    private static boolean shouldAddRuntimeDependenciesToTestCompilationClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (!orderEnumerationHandler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessRecursively(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    public void forEach(@NotNull Processor<? super OrderEntry> processor2) {
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(entry, handlers) -> processor2.process(entry)));
    }

    protected abstract void forEach(@NotNull PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>> var1);

    public void forEachLibrary(@NotNull Processor<? super Library> processor2) {
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(entry, handlers) -> {
            Library library;
            if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null) {
                return processor2.process((Object)library);
            }
            return true;
        }));
    }

    public void forEachModule(@NotNull Processor<? super Module> processor2) {
        this.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            Module module;
            if (this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                return processor2.process((Object)module2);
            }
            if (!(!(orderEntry instanceof ModuleOrderEntry) || this.myRecursively && OrderEnumeratorBase.shouldProcessRecursively(customHandlers) || (module = ((ModuleOrderEntry)orderEntry).getModule()) == null)) {
                return processor2.process((Object)module);
            }
            return true;
        }));
    }

    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        OrderEntryProcessor processor2 = new OrderEntryProcessor(policy, initialValue);
        this.forEach(processor2);
        return (R)processor2.myValue;
    }

    static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    static boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super VirtualFile> result2, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, (Object)VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootUrlsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<? super String> result2, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type, urls);
            result2.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootsForModule(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList urls = new ArrayList();
            boolean added = orderEnumerationHandler.addCustomModuleRoots(type, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result2, (Object)VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<? super Module> var1);

    private static class OrderEntryProcessor<R>
    implements PairProcessor<OrderEntry, List<OrderEnumerationHandler>> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(@NotNull RootPolicy<R> policy, R initialValue) {
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        public boolean process(OrderEntry orderEntry, List<OrderEnumerationHandler> customHandlers) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }
    }

    protected static class ProcessEntryAction {
        @NotNull
        public ProcessEntryActionType type;
        @Nullable
        Module recurseOnModule;
        public static final ProcessEntryAction SKIP = new ProcessEntryAction(ProcessEntryActionType.SKIP);
        public static final ProcessEntryAction PROCESS = new ProcessEntryAction(ProcessEntryActionType.PROCESS);

        private ProcessEntryAction(@NotNull ProcessEntryActionType type) {
            this.type = type;
        }

        @NotNull
        static ProcessEntryAction RECURSE(@NotNull Module module) {
            ProcessEntryAction result2 = new ProcessEntryAction(ProcessEntryActionType.RECURSE);
            result2.recurseOnModule = module;
            return result2;
        }
    }

    protected static enum ProcessEntryActionType {
        SKIP,
        RECURSE,
        PROCESS;

    }
}

