/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class OrderRootsCache {
    private final AtomicReference<Map<CacheKey, VirtualFilePointerContainer>> myRoots = new AtomicReference();
    private final Disposable myParentDisposable;
    private Disposable myRootsDisposable;
    private static final VirtualFilePointerContainer EMPTY = (VirtualFilePointerContainer)ObjectUtils.sentinel((String)"Empty roots container", VirtualFilePointerContainer.class);

    OrderRootsCache(@NotNull Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
        this.disposePointers();
    }

    private void disposePointers() {
        if (this.myRootsDisposable != null) {
            Disposer.dispose((Disposable)this.myRootsDisposable);
        }
        if (!Disposer.isDisposing((Disposable)this.myParentDisposable)) {
            this.myRootsDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myRootsDisposable);
        }
    }

    @NotNull
    private VirtualFilePointerContainer setCachedRoots(@NotNull CacheKey key, @NotNull Collection<String> urls) {
        VirtualFilePointerContainer container;
        if (urls.isEmpty()) {
            container = EMPTY;
        } else {
            container = VirtualFilePointerManager.getInstance().createContainer(this.myRootsDisposable);
            ((VirtualFilePointerContainerImpl)container).addAll(urls);
        }
        Map map2 = this.myRoots.get();
        if (map2 == null) {
            map2 = (Map)ConcurrencyUtil.cacheOrGet(this.myRoots, (Object)ContainerUtil.newConcurrentMap());
        }
        map2.put((CacheKey)key, (VirtualFilePointerContainer)container);
        return container;
    }

    private VirtualFilePointerContainer getOrComputeContainer(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer cached;
        Map<CacheKey, VirtualFilePointerContainer> map2 = this.myRoots.get();
        CacheKey key = new CacheKey(rootType, flags);
        VirtualFilePointerContainer virtualFilePointerContainer = cached = map2 == null ? null : map2.get(key);
        if (cached == null) {
            Collection<String> roots = computer.get();
            cached = this.setCachedRoots(key, roots);
        }
        return cached == EMPTY ? null : cached;
    }

    @NotNull
    VirtualFile[] getOrComputeRoots(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container = this.getOrComputeContainer(rootType, flags, computer);
        return container == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
    }

    @NotNull
    String[] getOrComputeUrls(@NotNull OrderRootType rootType, int flags, @NotNull Supplier<? extends Collection<String>> computer) {
        VirtualFilePointerContainer container = this.getOrComputeContainer(rootType, flags, computer);
        return container == null ? ArrayUtil.EMPTY_STRING_ARRAY : container.getUrls();
    }

    void clearCache() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.disposePointers();
        this.myRoots.set(null);
    }

    private static final class CacheKey {
        private final OrderRootType myRootType;
        private final int myFlags;

        private CacheKey(@NotNull OrderRootType rootType, int flags) {
            this.myRootType = rootType;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.myFlags == cacheKey.myFlags && this.myRootType.equals((Object)cacheKey.myRootType);
        }

        public int hashCode() {
            return 31 * this.myRootType.hashCode() + this.myFlags;
        }
    }
}

