/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl");
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<? super OrderEntry, ? extends OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<OrderEntry, VirtualFile[]> myCustomRootProvider;
    private boolean myWithoutSelfModuleOutput;

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = null;
        this.myRootTypeProvider = rootTypeProvider;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            return cache.getOrComputeRoots(this.myRootType, flags, this::computeRootsUrls);
        }
        return VfsUtilCore.toVirtualFileArray(this.computeRoots());
    }

    @NotNull
    public String[] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            return cache.getOrComputeUrls(this.myRootType, flags, this::computeRootsUrls);
        }
        return ArrayUtil.toStringArray(this.computeRootsUrls());
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomRootProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, (Object)"Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    @NotNull
    private Collection<VirtualFile> computeRoots() {
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRoots(type, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), (Collection<? super VirtualFile>)result2, true, !this.myOrderEnumerator.isProductionOnly(), (List<? extends OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRoots(type, rootModel, (Collection<? super VirtualFile>)result2, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
                }
            } else {
                if (this.myCustomRootProvider != null) {
                    Collections.addAll(result2, (Object[])this.myCustomRootProvider.fun(orderEntry));
                    return true;
                }
                if (OrderEnumeratorBase.addCustomRootsForLibrary(orderEntry, type, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getFiles(type));
            }
            return true;
        }));
        return result2;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((PairProcessor<? super OrderEntry, ? super List<OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRootsUrls(type, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result2, true, !this.myOrderEnumerator.isProductionOnly());
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type, rootModel, result2, !productionOnTests, includeTests);
                }
            } else {
                if (OrderEnumeratorBase.addCustomRootUrlsForLibrary(orderEntry, type, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getUrls(type));
            }
            return true;
        }));
        return result2;
    }

    @NotNull
    public PathsList getPathsList() {
        PathsList list2 = new PathsList();
        this.collectPaths(list2);
        return list2;
    }

    public void collectPaths(@NotNull PathsList list2) {
        list2.addVirtualFiles(this.getRoots());
    }

    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        return this;
    }

    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        return this;
    }

    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<OrderEntry, VirtualFile[]> provider) {
        this.myCustomRootProvider = provider;
        return this;
    }

    private void collectModuleRoots(@NotNull OrderRootType type, ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension;
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRoots(includeTests));
            } else {
                result2.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputPathForTests());
            }
        }
        OrderEnumeratorBase.addCustomRootsForModule(type, rootModel, result2, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(OrderRootType type, ModuleRootModel rootModel, Collection<? super String> result2, boolean includeProduction, boolean includeTests) {
        CompilerModuleExtension extension;
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result2.add(folder.getUrl());
                    }
                }
            }
        } else if (type.equals((Object)OrderRootType.CLASSES) && (extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRootUrls(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRootUrls(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, (Object)extension.getCompilerOutputUrlForTests());
            }
        }
    }

    @NotNull
    private OrderRootType getRootType(@NotNull OrderEntry e) {
        return this.myRootType != null ? this.myRootType : (OrderRootType)this.myRootTypeProvider.fun((Object)e);
    }
}

