/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        super(directoryIndex, fileTypeManager);
        this.myProject = project;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2, @Nullable VirtualFileFilter filter) {
        Module[] modules;
        for (Module module : modules = (Module[])ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor2, filter)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<VirtualFile> getRootsToIterate(@NotNull Module module) {
        return (Set)ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = ProjectFileIndexImpl.getModuleContentAndSourceRoots(module);
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[i]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || !module.equals(info.getModule()) || (parent = root.getParent()) != null && ProjectFileIndexImpl.isFileInContent(parent, parentInfo = this.getInfoForFileOrDirectory(parent))) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
    }

    public boolean isExcluded(@NotNull VirtualFile file2) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(file2);
        return info.isIgnored() || info.isExcluded(file2);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        return this.getModuleForFile(file2, true);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)file2).getOriginFile();
        }
        if ((info = this.getInfoForFileOrDirectory(file2)).isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getModule();
        }
        return null;
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        return this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file2));
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        return ProjectFileIndexImpl.getClassRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getClassRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        return info.isInProject(file2) ? info.getLibraryClassRoot() : null;
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        return ProjectFileIndexImpl.getSourceRootForFile(file2, this.getInfoForFileOrDirectory(file2));
    }

    @Nullable
    public static VirtualFile getSourceRootForFile(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        return info.isInProject(file2) ? info.getSourceRoot() : null;
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        return this.getContentRootForFile(file2, true);
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        return ProjectFileIndexImpl.getContentRootForFile(this.getInfoForFileOrDirectory(file2), file2, honorExclusion);
    }

    @Nullable
    public static VirtualFile getContentRootForFile(@NotNull DirectoryInfo info, @NotNull VirtualFile file2, boolean honorExclusion) {
        if (info.isInProject(file2) || !honorExclusion && info.isExcluded(file2)) {
            return info.getContentRoot();
        }
        return null;
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject(file2) && parentInfo.hasLibraryClassRoot();
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) || info.isInLibrarySource(fileOrDir);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject(fileOrDir) && info.hasLibraryClassRoot();
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject(fileOrDir) && info.isInLibrarySource(fileOrDir);
    }

    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject(fileOrDir) && (info.hasLibraryClassRoot() || info.isInLibrarySource(fileOrDir));
    }

    public boolean isIgnored(@NotNull VirtualFile file2) {
        return this.isExcluded(file2);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        return ProjectFileIndexImpl.isFileInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public static boolean isFileInContent(@NotNull VirtualFile fileOrDir, @NotNull DirectoryInfo info) {
        return info.isInProject(fileOrDir) && info.getModule() != null;
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) && this.isTestSourcesRoot(info);
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    public SourceFolder getSourceFolder(@NotNull VirtualFile fileOrDir) {
        return this.myDirectoryIndex.getSourceRootFolder(this.getInfoForFileOrDirectory(fileOrDir));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }
}

