/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootManagerImpl");
    private static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    private static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    private static final String ATTRIBUTE_VERSION = "version";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
    private String myProjectSdkName;
    private String myProjectSdkType;
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed;
    private final RootProviderChangeListener myRootProviderChangeListener = new RootProviderChangeListener();
    protected final BatchSession myRootsChanged = new BatchSession(false);
    protected final BatchSession myFileTypesChanged = new BatchSession(true);
    private final VirtualFilePointerListener myRootsValidityChangedListener = new VirtualFilePointerListener(){};
    private boolean myMergedCallStarted;
    private boolean myMergedCallHasRootChange;
    private int myRootsChangesDepth;
    protected boolean isFiringEvent;
    private final Object myLibraryTableListenersLock = new Object();
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners = new HashMap<LibraryTable, LibraryTableMultiListener>();
    private final JdkTableMultiListener myJdkTableMultiListener;
    private final Map<RootProvider, Set<OrderEntry>> myRegisteredRootProviders = ContainerUtil.newIdentityTroveMap();

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance((Project)project);
    }

    public ProjectRootManagerImpl(Project project) {
        this.myProject = project;
        this.myRootsCache = new OrderRootsCache((Disposable)project);
        this.myJdkTableMultiListener = new JdkTableMultiListener(project);
    }

    @NotNull
    public ProjectFileIndex getFileIndex() {
        return ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
    }

    @NotNull
    public List<String> getContentRootUrls() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Module module : this.getModuleManager().getModules()) {
            Object[] urls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            ContainerUtil.addAll(result2, (Object[])urls);
        }
        return result2;
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        Module[] modules;
        ArrayList result2 = new ArrayList();
        for (Module module : modules = this.getModuleManager().getModules()) {
            Object[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (modules.length == 1) {
                return contentRoots;
            }
            ContainerUtil.addAll(result2, (Object[])contentRoots);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public VirtualFile[] getContentSourceRoots() {
        ArrayList result2 = new ArrayList();
        for (Module module : this.getModuleManager().getModules()) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            ContainerUtil.addAll(result2, (Object[])sourceRoots);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : this.getModuleManager().getModules()) {
            roots.addAll(ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes));
        }
        return roots;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
    }

    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        return new ModulesOrderEnumerator(modules);
    }

    @NotNull
    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules;
        ArrayList result2 = new ArrayList();
        for (Module module : modules = this.getModuleManager().getSortedModules()) {
            Object[] files2 = ModuleRootManager.getInstance((Module)module).getContentRoots();
            ContainerUtil.addAll(result2, (Object[])files2);
        }
        ContainerUtil.addIfNotNull(result2, (Object)this.myProject.getBaseDir());
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public Sdk getProjectSdk() {
        return this.myProjectSdkName == null ? null : (this.myProjectSdkType == null ? ProjectJdkTable.getInstance().findJdk(this.myProjectSdkName) : ProjectJdkTable.getInstance().findJdk(this.myProjectSdkName, this.myProjectSdkType));
    }

    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    public void setProjectSdk(Sdk sdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk.getName();
            this.myProjectSdkType = sdk.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    private void projectJdkChanged() {
        this.incModificationCount();
        this.mergeRootsChangesDuring(() -> ((ProjectRootManagerEx.ProjectJdkListener)this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged());
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : (ProjectExtension[])ProjectExtension.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension.projectSdkChanged(sdk);
        }
    }

    public void setProjectSdkName(@NotNull String name) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name;
        this.projectJdkChanged();
    }

    public void addProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        this.myProjectJdkEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        this.myProjectJdkEventDispatcher.removeListener((EventListener)listener2);
    }

    public void loadState(@NotNull Element element) {
        for (ProjectExtension extension : (ProjectExtension[])ProjectExtension.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectSdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : (ProjectExtension[])ProjectExtension.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectSdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
        if (element.getAttributes().size() == 1) {
            element.removeAttribute(ATTRIBUTE_VERSION);
        }
        return element;
    }

    public void mergeRootsChangesDuring(@NotNull Runnable runnable2) {
        block6: {
            block5: {
                block4: {
                    if (this.getBatchSession(false).myBatchLevel != 0 || this.myMergedCallStarted) break block5;
                    if (this.myRootsChangesDepth != 0) {
                        int depth = this.myRootsChangesDepth;
                        this.myRootsChangesDepth = 0;
                        LOG.error("Merged rootsChanged not allowed inside rootsChanged, rootsChanged level == " + depth);
                    }
                    this.myMergedCallStarted = true;
                    this.myMergedCallHasRootChange = false;
                    try {
                        runnable2.run();
                        if (!this.myMergedCallHasRootChange) break block4;
                        LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                    }
                    catch (Throwable throwable) {
                        if (this.myMergedCallHasRootChange) {
                            LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                            this.getBatchSession(false).rootsChanged();
                        }
                        this.myMergedCallStarted = false;
                        this.myMergedCallHasRootChange = false;
                        throw throwable;
                    }
                    this.getBatchSession(false).rootsChanged();
                }
                this.myMergedCallStarted = false;
                this.myMergedCallHasRootChange = false;
                break block6;
            }
            runnable2.run();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    public void clearScopesCachesForModules() {
        Module[] modules;
        this.myRootsCache.clearCache();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRootsChange(@NotNull Runnable runnable2, boolean fileTypes, boolean fireEvents) {
        if (this.myProject.isDisposed() || Disposer.isDisposing((Disposable)this.myProject)) {
            return;
        }
        BatchSession session2 = this.getBatchSession(fileTypes);
        try {
            if (fireEvents) {
                session2.beforeRootsChanged();
            }
            runnable2.run();
        }
        finally {
            if (fireEvents) {
                session2.rootsChanged();
            }
        }
    }

    @NotNull
    protected BatchSession getBatchSession(boolean fileTypes) {
        return fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
    }

    private boolean fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        if (this.myRootsChangesDepth++ == 0) {
            if (this.myMergedCallStarted) {
                this.myMergedCallHasRootChange = true;
                ++this.myRootsChangesDepth;
            }
            this.fireBeforeRootsChangeEvent(fileTypes);
            return true;
        }
        return false;
    }

    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes) {
        if (this.myProject.isDisposed() || Disposer.isDisposing((Disposable)this.myProject)) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        --this.myRootsChangesDepth;
        if (this.myRootsChangesDepth > 0) {
            return false;
        }
        if (this.myRootsChangesDepth < 0) {
            LOG.info("Restoring from roots change start/finish mismatch: ", new Throwable());
            this.myRootsChangesDepth = 0;
        }
        this.clearScopesCaches();
        this.incModificationCount();
        this.fireRootsChangedEvent(fileTypes);
        this.doSynchronizeRoots();
        this.addRootsToWatch();
        return true;
    }

    protected void fireRootsChangedEvent(boolean fileTypes) {
    }

    protected void addRootsToWatch() {
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    protected void doSynchronizeRoots() {
    }

    @NotNull
    public static String extractLocalPath(@NotNull String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        int separatorIndex = path.indexOf("!/");
        return separatorIndex > 0 ? path.substring(0, separatorIndex) : path;
    }

    @NotNull
    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance((Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribeToRootProvider(@NotNull OrderEntry owner, @NotNull RootProvider provider) {
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
            if (owners == null) {
                owners = new HashSet<OrderEntry>();
                this.myRegisteredRootProviders.put(provider, owners);
                provider.addRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
            }
            owners.add(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribeFromRootProvider(@NotNull OrderEntry owner, @NotNull RootProvider provider) {
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
            if (owners != null) {
                owners.remove(owner);
                if (owners.isEmpty()) {
                    provider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
                    this.myRegisteredRootProviders.remove(provider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener();
                libraryTable.addListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.addListener(libraryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            boolean last;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.removeListener(libraryListener))) {
                libraryTable.removeListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
        }
    }

    void addJdkTableListener(@NotNull ProjectJdkTable.Listener jdkTableListener, @NotNull Disposable parent) {
        this.myJdkTableMultiListener.addListener(jdkTableListener);
        Disposer.register((Disposable)parent, () -> this.myJdkTableMultiListener.removeListener(jdkTableListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertListenersAreDisposed() {
        Map<RootProvider, Set<OrderEntry>> map2 = this.myRegisteredRootProviders;
        synchronized (map2) {
            if (!this.myRegisteredRootProviders.isEmpty()) {
                StringBuilder details = new StringBuilder();
                for (Map.Entry<RootProvider, Set<OrderEntry>> entry : this.myRegisteredRootProviders.entrySet()) {
                    details.append(" ").append(entry.getKey()).append(" referenced by ").append(entry.getValue().size()).append(" order entries:\n");
                    for (OrderEntry orderEntry : entry.getValue()) {
                        details.append("   ").append(orderEntry).append("\n");
                    }
                }
                LOG.error("Listeners for " + this.myRegisteredRootProviders.size() + " root providers aren't disposed:" + details);
                for (RootProvider provider : this.myRegisteredRootProviders.keySet()) {
                    provider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
                }
            }
        }
    }

    public void markRootsForRefresh() {
    }

    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        return this.myRootsValidityChangedListener;
    }

    private class RootProviderChangeListener
    implements RootProvider.RootSetChangedListener {
        private boolean myInsideRootsChange;

        private RootProviderChangeListener() {
        }

        public void rootSetChanged(@NotNull RootProvider wrapper2) {
            if (this.myInsideRootsChange) {
                return;
            }
            this.myInsideRootsChange = true;
            try {
                ProjectRootManagerImpl.this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            finally {
                this.myInsideRootsChange = false;
            }
        }
    }

    private class JdkTableMultiListener
    extends ListenerContainer<ProjectJdkTable.Listener>
    implements ProjectJdkTable.Listener {
        private final MessageBusConnection listenerConnection;

        private JdkTableMultiListener(Project project) {
            super(new ProjectJdkTable.Listener[0]);
            this.listenerConnection = project.getMessageBus().connect();
            this.listenerConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this);
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkAdded(jdk);
                }
            });
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkRemoved(jdk);
                }
            });
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (ProjectJdkTable.Listener listener2 : (ProjectJdkTable.Listener[])this.getListeners()) {
                    listener2.jdkNameChanged(jdk, previousName);
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectSdkName();
            if (previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
            }
        }
    }

    private class LibraryTableMultiListener
    extends ListenerContainer<LibraryTable.Listener>
    implements LibraryTable.Listener {
        private LibraryTableMultiListener() {
            super(new LibraryTable.Listener[0]);
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryAdded(newLibrary);
                }
            });
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryRenamed(library);
                }
            });
        }

        public void beforeLibraryRemoved(@NotNull Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.beforeLibraryRemoved(library);
                }
            });
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                for (LibraryTable.Listener listener2 : (LibraryTable.Listener[])this.getListeners()) {
                    listener2.afterLibraryRemoved(library);
                }
            });
        }
    }

    private static class ListenerContainer<T> {
        private final Set<T> myListeners = new LinkedHashSet<T>();
        @NotNull
        private final T[] myEmptyArray;
        private T[] myListenersArray;

        private ListenerContainer(@NotNull T[] emptyArray) {
            this.myEmptyArray = emptyArray;
        }

        synchronized void addListener(@NotNull T listener2) {
            this.myListeners.add(listener2);
            this.myListenersArray = null;
        }

        synchronized boolean removeListener(@NotNull T listener2) {
            this.myListeners.remove(listener2);
            this.myListenersArray = null;
            return this.myListeners.isEmpty();
        }

        @NotNull
        synchronized T[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(this.myEmptyArray);
            }
            return this.myListenersArray;
        }
    }

    protected class BatchSession {
        private final boolean myFileTypes;
        private int myBatchLevel;
        private boolean myChanged;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        protected void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
            }
            ++this.myBatchLevel;
        }

        protected void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    WriteAction.run(() -> ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes));
                }
                finally {
                    this.myChanged = false;
                }
            }
        }

        protected void beforeRootsChanged() {
            if ((this.myBatchLevel == 0 || !this.myChanged) && ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes)) {
                this.myChanged = true;
            }
        }

        protected void rootsChanged() {
            if (this.myBatchLevel == 0 && ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes)) {
                this.myChanged = false;
            }
        }
    }
}

