/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class RootModelBase
implements ModuleRootModel {
    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @NotNull
    public String[] getContentRootUrls() {
        if (this.getContent().isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getContent().size());
        for (ContentEntry contentEntry : this.getContent()) {
            result2.add(contentEntry.getUrl());
        }
        return ArrayUtil.toStringArray(result2);
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            result2.addAll(contentEntry.getExcludeFolderUrls());
        }
        return ArrayUtil.toStringArray((Collection)result2);
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result2, contentEntry.getExcludeFolderFiles());
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    @NotNull
    public String[] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result2.add(sourceFolder.getUrl());
            }
        }
        return ArrayUtil.toStringArray((Collection)result2);
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null || !includingTests && sourceFolder.isTestSource()) continue;
                result2.add(file2);
            }
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.getSourceRoots(Collections.singleton(rootType));
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        SmartList result2 = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            List sourceFolders = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null) continue;
                result2.add(file2);
            }
        }
        return result2;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        Collection<ContentEntry> content = this.getContent();
        return content.toArray(new ContentEntry[0]);
    }

    protected abstract Collection<ContentEntry> getContent();

    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this, null);
    }

    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        Object result2 = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result2 = orderEntry.accept(policy, result2);
        }
        return result2;
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        List result2 = (List)this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process((RootPolicy)new CollectDependentModules(), new ArrayList());
        return ArrayUtil.toStringArray((Collection)result2);
    }

    @NotNull
    public Module[] getModuleDependencies() {
        return this.getModuleDependencies(true);
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries2 = this.getOrderEntries();
        List result2 = null;
        for (OrderEntry entry : entries2) {
            Module module;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(module);
        }
        return result2 == null ? Module.EMPTY_ARRAY : result2.toArray(Module.EMPTY_ARRAY);
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            arrayList.add(moduleOrderEntry.getModuleName());
            return arrayList;
        }
    }
}

