/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootModelImpl
extends RootModelBase
implements ModifiableRootModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootModelImpl");
    private final Set<ContentEntry> myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
    private final List<OrderEntry> myOrderEntries = new Order();
    @Nullable
    private OrderEntry[] myCachedOrderEntries;
    @NotNull
    private final ModuleLibraryTable myModuleLibraryTable;
    final ModuleRootManagerImpl myModuleRootManager;
    private boolean myWritable;
    private final VirtualFilePointerManager myFilePointerManager;
    private boolean myDisposed;
    private final Set<ModuleExtension> myExtensions = new TreeSet<ModuleExtension>((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getClass().getName()), (Comparable)((Object)o2.getClass().getName())));
    @Nullable
    private final Map<ModuleExtension, byte[]> myExtensionToStateDigest;
    private final RootConfigurationAccessor myConfigurationAccessor;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final CompositeDisposable myDisposable = new CompositeDisposable();

    RootModelImpl(@NotNull ModuleRootManagerImpl moduleRootManager, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myWritable = false;
        this.addSourceOrderEntries();
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (ModuleExtension extension : (ModuleExtension[])ModuleExtension.EP_NAME.getExtensions((AreaInstance)moduleRootManager.getModule())) {
            ModuleExtension model = extension.getModifiableModel(false);
            this.registerOnDispose((Disposable)model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
        this.myExtensionToStateDigest = null;
    }

    private void addSourceOrderEntries() {
        this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
    }

    RootModelImpl(@NotNull Element element, @NotNull ModuleRootManagerImpl moduleRootManager, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager, boolean writable) throws InvalidDataException {
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (Object child2 : element.getChildren("content")) {
            this.myContent.add(new ContentEntryImpl((Element)child2, this));
        }
        boolean moduleSourceAdded = false;
        for (Element child3 : element.getChildren("orderEntry")) {
            OrderEntry orderEntry = OrderEntryFactory.createOrderEntryByElement(child3, this, this.myProjectRootManager);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                if (moduleSourceAdded) continue;
                moduleSourceAdded = true;
            }
            this.myOrderEntries.add(orderEntry);
        }
        if (!moduleSourceAdded) {
            this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
        }
        this.myWritable = writable;
        RootModelImpl originalRootModel = moduleRootManager.getRootModel();
        for (ModuleExtension extension : originalRootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(false);
            if (model instanceof PersistentStateComponent) {
                XmlSerializer.deserializeAndLoadState((PersistentStateComponent)((PersistentStateComponent)model), (Element)element);
            } else {
                model.readExternal(element);
            }
            this.registerOnDispose((Disposable)model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
        this.myExtensionToStateDigest = null;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    @NotNull
    RootConfigurationAccessor getConfigurationAccessor() {
        return this.myConfigurationAccessor;
    }

    RootModelImpl(@NotNull RootModelImpl rootModel, @NotNull ModuleRootManagerImpl moduleRootManager, boolean writable, @NotNull RootConfigurationAccessor rootConfigurationAccessor, @NotNull VirtualFilePointerManager filePointerManager, @NotNull ProjectRootManagerImpl projectRootManager) {
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        this.myWritable = writable;
        this.myConfigurationAccessor = rootConfigurationAccessor;
        for (ContentEntry contentEntry : rootModel.myContent) {
            if (!(contentEntry instanceof ClonableContentEntry)) continue;
            ContentEntry cloned = ((ClonableContentEntry)contentEntry).cloneEntry(this);
            this.myContent.add(cloned);
        }
        this.setOrderEntriesFrom(rootModel);
        this.myExtensionToStateDigest = writable ? new THashMap() : null;
        for (ModuleExtension extension : rootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(writable);
            this.registerOnDispose((Disposable)model);
            this.myExtensions.add(model);
            if (this.myExtensionToStateDigest == null || extension instanceof PersistentStateComponentWithModificationTracker) continue;
            Element state = new Element("state");
            try {
                extension.writeExternal(state);
                this.myExtensionToStateDigest.put(extension, Scheme_implKt.digest(state));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private void setOrderEntriesFrom(@NotNull RootModelImpl rootModel) {
        this.removeAllOrderEntries();
        for (OrderEntry orderEntry : rootModel.myOrderEntries) {
            if (!(orderEntry instanceof ClonableOrderEntry)) continue;
            this.myOrderEntries.add(((ClonableOrderEntry)orderEntry).cloneEntry(this, this.myProjectRootManager, this.myFilePointerManager));
        }
    }

    private void removeAllOrderEntries() {
        for (OrderEntry entry : this.myOrderEntries) {
            Disposer.dispose((Disposable)((Disposable)entry));
        }
        this.myOrderEntries.clear();
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] cachedOrderEntries = this.myCachedOrderEntries;
        if (cachedOrderEntries == null) {
            this.myCachedOrderEntries = cachedOrderEntries = this.myOrderEntries.toArray(OrderEntry.EMPTY_ARRAY);
        }
        return cachedOrderEntries;
    }

    @NotNull
    Iterator<OrderEntry> getOrderIterator() {
        return Collections.unmodifiableList(this.myOrderEntries).iterator();
    }

    public void removeContentEntry(@NotNull ContentEntry entry) {
        this.assertWritable();
        LOG.assertTrue(this.myContent.contains(entry));
        this.myContent.remove(entry);
        if (entry instanceof RootModelComponentBase) {
            Disposer.dispose((Disposable)((Disposable)entry));
            RootModelImpl entryModel = ((RootModelComponentBase)entry).getRootModel();
            LOG.assertTrue(entryModel == this, (Object)("Removing from " + this + " content entry obtained from " + entryModel));
        }
    }

    public void addOrderEntry(@NotNull OrderEntry entry) {
        this.assertWritable();
        LOG.assertTrue(!this.myOrderEntries.contains(entry));
        this.myOrderEntries.add(entry);
    }

    @NotNull
    public LibraryOrderEntry addLibraryEntry(@NotNull Library library) {
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(library, this, this.myProjectRootManager);
        if (!libraryOrderEntry.isValid()) {
            LibraryEx libraryEx = (LibraryEx)ObjectUtils.tryCast((Object)library, LibraryEx.class);
            boolean libraryDisposed = libraryEx != null ? libraryEx.isDisposed() : Disposer.isDisposed((Disposable)library);
            throw new AssertionError((Object)("Invalid libraryOrderEntry, library: " + library + " of type " + library.getClass() + ", disposed: " + libraryDisposed + ", kind: " + (libraryEx != null ? libraryEx.getKind() : "<undefined>")));
        }
        this.myOrderEntries.add(libraryOrderEntry);
        return libraryOrderEntry;
    }

    @NotNull
    public LibraryOrderEntry addInvalidLibrary(@NotNull String name, @NotNull String level) {
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(name, level, this, this.myProjectRootManager);
        this.myOrderEntries.add(libraryOrderEntry);
        return libraryOrderEntry;
    }

    @NotNull
    public ModuleOrderEntry addModuleOrderEntry(@NotNull Module module) {
        this.assertWritable();
        LOG.assertTrue(!module.equals(this.getModule()));
        LOG.assertTrue(Comparing.equal((Object)this.myModuleRootManager.getModule().getProject(), (Object)module.getProject()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(module, this);
        this.myOrderEntries.add(moduleOrderEntry);
        return moduleOrderEntry;
    }

    @NotNull
    public ModuleOrderEntry addInvalidModuleEntry(@NotNull String name) {
        this.assertWritable();
        LOG.assertTrue(!name.equals(this.getModule().getName()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(name, this);
        this.myOrderEntries.add(moduleOrderEntry);
        return moduleOrderEntry;
    }

    @Nullable
    public ModuleOrderEntry findModuleOrderEntry(@NotNull Module module) {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public LibraryOrderEntry findLibraryOrderEntry(@NotNull Library library) {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    public void removeOrderEntry(@NotNull OrderEntry entry) {
        this.assertWritable();
        this.removeOrderEntryInternal(entry);
    }

    private void removeOrderEntryInternal(@NotNull OrderEntry entry) {
        LOG.assertTrue(this.myOrderEntries.contains(entry));
        Disposer.dispose((Disposable)((Disposable)entry));
        this.myOrderEntries.remove(entry);
    }

    public void rearrangeOrderEntries(@NotNull OrderEntry[] newEntries) {
        this.assertWritable();
        this.assertValidRearrangement(newEntries);
        this.myOrderEntries.clear();
        ContainerUtil.addAll(this.myOrderEntries, (Object[])newEntries);
    }

    private void assertValidRearrangement(@NotNull OrderEntry[] newEntries) {
        String error = this.checkValidRearrangement(newEntries);
        LOG.assertTrue(error == null, (Object)error);
    }

    @Nullable
    private String checkValidRearrangement(@NotNull OrderEntry[] newEntries) {
        if (newEntries.length != this.myOrderEntries.size()) {
            return "Size mismatch: old size=" + this.myOrderEntries.size() + "; new size=" + newEntries.length;
        }
        HashSet<OrderEntry> set2 = new HashSet<OrderEntry>(newEntries.length);
        for (OrderEntry newEntry : newEntries) {
            if (set2.add(newEntry)) continue;
            return "Trying to add duplicate order entry " + newEntry;
        }
        set2.removeAll(this.myOrderEntries);
        if (!set2.isEmpty()) {
            return "Trying to add non-existing order entry " + set2.iterator().next();
        }
        return null;
    }

    public void clear() {
        Sdk jdk = this.getSdk();
        this.removeAllContentEntries();
        this.removeAllOrderEntries();
        this.setSdk(jdk);
        this.addSourceOrderEntries();
    }

    private void removeAllContentEntries() {
        for (ContentEntry entry : this.myContent) {
            if (!(entry instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)entry));
        }
        this.myContent.clear();
    }

    public void commit() {
        this.myModuleRootManager.commitModel(this);
        this.myWritable = false;
    }

    void docommit() {
        assert (this.isWritable());
        if (this.areOrderEntriesChanged()) {
            this.getSourceModel().setOrderEntriesFrom(this);
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (!extension.isChanged()) continue;
            extension.commit();
        }
        if (this.areContentEntriesChanged()) {
            this.getSourceModel().removeAllContentEntries();
            for (ContentEntry contentEntry : this.myContent) {
                ContentEntry cloned = ((ClonableContentEntry)contentEntry).cloneEntry(this.getSourceModel());
                this.getSourceModel().myContent.add(cloned);
            }
        }
    }

    @NotNull
    public LibraryTable getModuleLibraryTable() {
        return this.myModuleLibraryTable;
    }

    @NotNull
    public Project getProject() {
        return this.myProjectRootManager.getProject();
    }

    @NotNull
    public ContentEntry addContentEntry(@NotNull VirtualFile file2) {
        return this.addContentEntry(new ContentEntryImpl(file2, this));
    }

    @NotNull
    public ContentEntry addContentEntry(@NotNull String url) {
        return this.addContentEntry(new ContentEntryImpl(url, this));
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private ContentEntry addContentEntry(@NotNull ContentEntry e) {
        if (this.myContent.contains(e)) {
            for (ContentEntry contentEntry : this.getContentEntries()) {
                if (ContentComparator.INSTANCE.compare(contentEntry, e) != 0) continue;
                return contentEntry;
            }
        }
        this.myContent.add(e);
        return e;
    }

    long getStateModificationCount() {
        long result2 = 0L;
        for (ModuleExtension extension : this.myExtensions) {
            if (!(extension instanceof PersistentStateComponentWithModificationTracker)) continue;
            result2 += ((PersistentStateComponentWithModificationTracker)extension).getStateModificationCount();
        }
        return result2;
    }

    public void writeExternal(@NotNull Element element) {
        for (ModuleExtension extension : this.myExtensions) {
            if (extension instanceof PersistentStateComponent) {
                XmlSerializer.serializeStateInto((PersistentStateComponent)((PersistentStateComponent)extension), (Element)element);
                continue;
            }
            extension.writeExternal(element);
        }
        for (ContentEntry contentEntry : this.getContent()) {
            if (!(contentEntry instanceof ContentEntryImpl)) continue;
            Element subElement = new Element("content");
            ((ContentEntryImpl)contentEntry).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (Iterator<Object> iterator : this.getOrderEntries()) {
            if (!(iterator instanceof WritableOrderEntry)) continue;
            ((WritableOrderEntry)((Object)iterator)).writeExternal(element);
        }
    }

    public void setSdk(@Nullable Sdk jdk) {
        this.assertWritable();
        ModuleJdkOrderEntryImpl jdkLibraryEntry = jdk == null ? null : new ModuleJdkOrderEntryImpl(jdk, this, this.myProjectRootManager);
        this.replaceEntryOfType(JdkOrderEntry.class, jdkLibraryEntry);
    }

    public void setInvalidSdk(@NotNull String jdkName, String jdkType) {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new ModuleJdkOrderEntryImpl(jdkName, jdkType, this, this.myProjectRootManager));
    }

    public void inheritSdk() {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new InheritedJdkOrderEntryImpl(this, this.myProjectRootManager));
    }

    public <T extends OrderEntry> void replaceEntryOfType(@NotNull Class<T> entryClass, @Nullable T entry) {
        this.assertWritable();
        for (int i = 0; i < this.myOrderEntries.size(); ++i) {
            OrderEntry orderEntry = this.myOrderEntries.get(i);
            if (!entryClass.isInstance(orderEntry)) continue;
            this.myOrderEntries.remove(i);
            if (entry != null) {
                this.myOrderEntries.add(i, entry);
            }
            return;
        }
        if (entry != null) {
            this.myOrderEntries.add(0, entry);
        }
    }

    public String getSdkName() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdkName();
        }
        return null;
    }

    void assertWritable() {
        LOG.assertTrue(this.myWritable);
    }

    boolean isOrderEntryDisposed() {
        for (OrderEntry entry : this.myOrderEntries) {
            if (!(entry instanceof RootModelComponentBase) || !((RootModelComponentBase)entry).isDisposed()) continue;
            return true;
        }
        return false;
    }

    protected Set<ContentEntry> getContent() {
        return this.myContent;
    }

    @NotNull
    public Module getModule() {
        return this.myModuleRootManager.getModule();
    }

    public boolean isChanged() {
        if (!this.myWritable) {
            return false;
        }
        for (ModuleExtension moduleExtension : this.myExtensions) {
            if (!moduleExtension.isChanged()) continue;
            return true;
        }
        return this.areOrderEntriesChanged() || this.areContentEntriesChanged();
    }

    private boolean areContentEntriesChanged() {
        return ArrayUtil.lexicographicCompare((Object[])this.getContentEntries(), (Object[])this.getSourceModel().getContentEntries()) != 0;
    }

    private boolean areOrderEntriesChanged() {
        OrderEntry[] sourceOrderEntries;
        OrderEntry[] orderEntries = this.getOrderEntries();
        if (orderEntries.length != (sourceOrderEntries = this.getSourceModel().getOrderEntries()).length) {
            return true;
        }
        for (int i = 0; i < orderEntries.length; ++i) {
            OrderEntry orderEntry = orderEntries[i];
            OrderEntry sourceOrderEntry = sourceOrderEntries[i];
            if (RootModelImpl.orderEntriesEquals(orderEntry, sourceOrderEntry)) continue;
            return true;
        }
        return false;
    }

    private static boolean orderEntriesEquals(@NotNull OrderEntry orderEntry1, @NotNull OrderEntry orderEntry2) {
        OrderRootType[] allTypes;
        if (!((OrderEntryBaseImpl)orderEntry1).sameType(orderEntry2)) {
            return false;
        }
        if (orderEntry1 instanceof JdkOrderEntry) {
            String name2;
            String name1;
            if (!(orderEntry2 instanceof JdkOrderEntry)) {
                return false;
            }
            if (orderEntry1 instanceof InheritedJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry2 instanceof InheritedJdkOrderEntry && orderEntry1 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry1 instanceof ModuleJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry && !Comparing.strEqual((String)(name1 = ((JdkOrderEntry)orderEntry1).getJdkName()), (String)(name2 = ((JdkOrderEntry)orderEntry2).getJdkName()))) {
                return false;
            }
        }
        if (orderEntry1 instanceof ExportableOrderEntry) {
            if (((ExportableOrderEntry)orderEntry1).isExported() != ((ExportableOrderEntry)orderEntry2).isExported()) {
                return false;
            }
            if (((ExportableOrderEntry)orderEntry1).getScope() != ((ExportableOrderEntry)orderEntry2).getScope()) {
                return false;
            }
        }
        if (orderEntry1 instanceof ModuleOrderEntry) {
            LOG.assertTrue(orderEntry2 instanceof ModuleOrderEntry);
            ModuleOrderEntryImpl entry1 = (ModuleOrderEntryImpl)orderEntry1;
            ModuleOrderEntryImpl entry2 = (ModuleOrderEntryImpl)orderEntry2;
            return entry1.isProductionOnTestDependency() == entry2.isProductionOnTestDependency() && Comparing.equal((String)entry1.getModuleName(), (String)entry2.getModuleName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry) {
            boolean equal;
            LOG.assertTrue(orderEntry2 instanceof LibraryOrderEntry);
            LibraryOrderEntry libraryOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            boolean bl = equal = Comparing.equal((String)libraryOrderEntry1.getLibraryName(), (String)libraryOrderEntry2.getLibraryName()) && Comparing.equal((String)libraryOrderEntry1.getLibraryLevel(), (String)libraryOrderEntry2.getLibraryLevel());
            if (!equal) {
                return false;
            }
            Library library1 = libraryOrderEntry1.getLibrary();
            Library library2 = libraryOrderEntry2.getLibrary();
            if (library1 != null && library2 != null && !Arrays.equals(((LibraryEx)library1).getExcludedRootUrls(), ((LibraryEx)library2).getExcludedRootUrls())) {
                return false;
            }
        }
        for (OrderRootType type : allTypes = OrderRootType.getAllTypes()) {
            Object[] orderedRootUrls2;
            Object[] orderedRootUrls1 = orderEntry1.getUrls(type);
            if (Arrays.equals(orderedRootUrls1, orderedRootUrls2 = orderEntry2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    void makeExternalChange(@NotNull Runnable runnable2) {
        if (this.myWritable || this.myDisposed) {
            return;
        }
        this.myModuleRootManager.makeRootsChange(runnable2);
    }

    public void dispose() {
        assert (!this.myDisposed);
        Disposer.dispose((Disposable)this.myDisposable);
        this.myExtensions.clear();
        if (this.myExtensionToStateDigest != null) {
            this.myExtensionToStateDigest.clear();
        }
        this.myWritable = false;
        this.myDisposed = true;
    }

    private RootModelImpl getSourceModel() {
        this.assertWritable();
        return this.myModuleRootManager.getRootModel();
    }

    public String toString() {
        return "RootModelImpl{module=" + this.getModule().getName() + ", writable=" + this.myWritable + ", disposed=" + this.myDisposed + '}';
    }

    @Nullable
    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        for (ModuleExtension extension : this.myExtensions) {
            if (!klass.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    void registerOnDispose(@NotNull Disposable disposable) {
        this.myDisposable.add(disposable);
    }

    void unregisterOnDispose(@NotNull Disposable disposable) {
        this.myDisposable.remove(disposable);
    }

    void checkModuleExtensionModification() {
        if (this.myExtensionToStateDigest == null || this.myExtensionToStateDigest.isEmpty()) {
            return;
        }
        for (Map.Entry<ModuleExtension, byte[]> entry : this.myExtensionToStateDigest.entrySet()) {
            Element state = new Element("state");
            try {
                ModuleExtension extension = entry.getKey();
                extension.writeExternal(state);
                byte[] newDigest = Scheme_implKt.digest(state);
                if (Arrays.equals(newDigest, entry.getValue())) continue;
                this.myModuleRootManager.stateChanged();
                return;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    public VirtualFilePointerListener getRootsChangedListener() {
        return this.myProjectRootManager.getRootsValidityChangedListener();
    }

    static /* synthetic */ OrderEntry[] access$102(RootModelImpl x0, OrderEntry[] x1) {
        x0.myCachedOrderEntries = x1;
        return x1;
    }

    private class Order
    extends ArrayList<OrderEntry> {
        private Order() {
        }

        @Override
        public void clear() {
            super.clear();
            this.clearCachedEntries();
        }

        @Override
        @NotNull
        public OrderEntry set(int i, @NotNull OrderEntry orderEntry) {
            super.set(i, orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(i);
            this.clearCachedEntries();
            return orderEntry;
        }

        @Override
        public boolean add(@NotNull OrderEntry orderEntry) {
            super.add(orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(this.size() - 1);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public void add(int i, OrderEntry orderEntry) {
            super.add(i, orderEntry);
            this.clearCachedEntries();
            this.setIndices(i);
        }

        @Override
        public OrderEntry remove(int i) {
            OrderEntry entry = (OrderEntry)super.remove(i);
            this.setIndices(i);
            this.clearCachedEntries();
            return entry;
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends OrderEntry> collection) {
            int startSize = this.size();
            boolean result2 = super.addAll(collection);
            this.setIndices(startSize);
            this.clearCachedEntries();
            return result2;
        }

        @Override
        public boolean addAll(int i, Collection<? extends OrderEntry> collection) {
            boolean result2 = super.addAll(i, collection);
            this.setIndices(i);
            this.clearCachedEntries();
            return result2;
        }

        @Override
        public void removeRange(int i, int i1) {
            super.removeRange(i, i1);
            this.clearCachedEntries();
            this.setIndices(i);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result2 = super.removeAll(collection);
            this.setIndices(0);
            this.clearCachedEntries();
            return result2;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean result2 = super.retainAll(collection);
            this.setIndices(0);
            this.clearCachedEntries();
            return result2;
        }

        private void clearCachedEntries() {
            RootModelImpl.access$102(RootModelImpl.this, null);
        }

        private void setIndices(int startIndex) {
            for (int j = startIndex; j < this.size(); ++j) {
                ((OrderEntryBaseImpl)this.get(j)).setIndex(j);
            }
        }
    }

    private static class ContentComparator
    implements Comparator<ContentEntry> {
        public static final ContentComparator INSTANCE = new ContentComparator();

        private ContentComparator() {
        }

        @Override
        public int compare(@NotNull ContentEntry o1, @NotNull ContentEntry o2) {
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

