/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootFilter;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DescendentBasedRootFilter
extends RootFilter {
    private final Predicate<? super VirtualFile> myCondition;

    public DescendentBasedRootFilter(OrderRootType rootType, boolean jarDirectory, String presentableRootTypeName, Predicate<? super VirtualFile> condition) {
        super(rootType, jarDirectory, presentableRootTypeName);
        this.myCondition = condition;
    }

    public static DescendentBasedRootFilter createFileTypeBasedFilter(OrderRootType rootType, boolean jarDirectory, @NotNull FileType fileType, String presentableRootTypeName) {
        return new DescendentBasedRootFilter(rootType, jarDirectory, presentableRootTypeName, file2 -> fileType.equals(file2.getFileType()));
    }

    @Override
    public boolean isAccepted(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (this.isJarDirectory()) {
            if (!rootCandidate.isDirectory() || !rootCandidate.isInLocalFileSystem()) {
                return false;
            }
            for (VirtualFile child2 : rootCandidate.getChildren()) {
                VirtualFile jarRoot;
                if (child2.isDirectory() || !child2.getFileType().equals(ArchiveFileType.INSTANCE) || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child2)) == null || !this.containsFileOfType(jarRoot, progressIndicator)) continue;
                return true;
            }
            return false;
        }
        return this.containsFileOfType(rootCandidate, progressIndicator);
    }

    private boolean containsFileOfType(VirtualFile rootCandidate, ProgressIndicator progressIndicator) {
        return !VfsUtilCore.processFilesRecursively((VirtualFile)rootCandidate, virtualFile -> {
            progressIndicator.checkCanceled();
            if (virtualFile.isDirectory()) {
                progressIndicator.setText2(virtualFile.getPath());
                return true;
            }
            return !this.myCondition.test((VirtualFile)virtualFile);
        });
    }
}

