/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ModuleDeleteProvider
implements DeleteProvider,
TitledHandler {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        List unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext);
        return modules != null && !ModuleDeleteProvider.containsPrimaryModule(modules) || unloadedModules != null && !unloadedModules.isEmpty();
    }

    private static boolean containsPrimaryModule(Module[] modules) {
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return !PlatformUtils.isIntelliJ();
        }
        for (Module module : modules) {
            String moduleFile = module.getModuleFilePath();
            Project project = module.getProject();
            if (!ProjectKt.isDirectoryBased(project)) continue;
            String ideaDir = ProjectKt.getStateStore(project).getDirectoryStorePath();
            if (!PathUtilRt.getParentPath((String)moduleFile).equals(ideaDir)) continue;
            return true;
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        String names;
        int ret;
        List unloadedModules;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        ArrayList moduleDescriptions = new ArrayList();
        Object[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null) {
            moduleDescriptions.addAll(ContainerUtil.map((Object[])modules, LoadedModuleDescriptionImpl::new));
        }
        if ((unloadedModules = (List)ProjectView.UNLOADED_MODULES_CONTEXT_KEY.getData(dataContext)) != null) {
            moduleDescriptions.addAll(unloadedModules);
        }
        if ((ret = Messages.showOkCancelDialog((String)ModuleDeleteProvider.getConfirmationText(names = StringUtil.join(moduleDescriptions, description -> "'" + description.getName() + "'", (String)", "), moduleDescriptions.size()), (String)this.getActionTitle(), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ModuleDeleteProvider.lambda$deleteElement$2(project, moduleDescriptions, (Module[])modules, unloadedModules), ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    private static String getConfirmationText(String names, int numberOfModules) {
        if (ProjectAttachProcessor.canAttachToProject()) {
            return ProjectBundle.message((String)"project.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
        }
        return ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, numberOfModules});
    }

    public String getActionTitle() {
        return ProjectAttachProcessor.canAttachToProject() ? "Remove from Project View" : "Remove Module";
    }

    public static void removeModule(@NotNull Module moduleToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        ModuleDeleteProvider.removeDependenciesOnModules(Collections.singleton(moduleToRemove.getName()), otherModuleRootModels);
        moduleModel.disposeModule(moduleToRemove);
    }

    private static void removeDependenciesOnModules(@NotNull Set<String> moduleNamesToRemove, @NotNull Collection<? extends ModifiableRootModel> otherModuleRootModels) {
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = modifiableRootModel.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !moduleNamesToRemove.contains(((ModuleOrderEntry)orderEntry).getModuleName())) continue;
                modifiableRootModel.removeOrderEntry(orderEntry);
            }
        }
    }

    private static /* synthetic */ void lambda$deleteElement$2(Project project, List moduleDescriptions, Module[] modules, List unloadedModules) {
        Runnable action = () -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Module[] currentModules = moduleManager.getModules();
            ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
            HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
            Set<String> moduleNamesToDelete = moduleDescriptions.stream().map(ModuleDescription::getName).collect(Collectors.toSet());
            for (Module otherModule : currentModules) {
                if (moduleNamesToDelete.contains(otherModule.getName())) continue;
                otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance((Module)otherModule).getModifiableModel());
            }
            ModuleDeleteProvider.removeDependenciesOnModules(moduleNamesToDelete, otherModuleRootModels.values());
            if (modules != null) {
                for (Module module : modules) {
                    modifiableModuleModel.disposeModule(module);
                }
            }
            ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[0]);
            ModifiableModelCommitter.multiCommit(modifiableRootModels, modifiableModuleModel);
            if (unloadedModules != null) {
                moduleManager.removeUnloadedModules((Collection)unloadedModules);
            }
        };
        ApplicationManager.getApplication().runWriteAction(action);
    }
}

