/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PathMacro {
    private final Map<String, File> myMap = new HashMap<String, File>();

    public PathMacro setScriptDir(File dir) {
        this.myMap.put("\\{script\\.dir\\}", dir);
        return this;
    }

    public PathMacro setBaseDir(File dir) {
        this.myMap.put("\\{base\\.dir\\}", dir);
        return this;
    }

    public File resolveFile(String path, File defaultDir) {
        Set<String> macros = this.myMap.keySet();
        String actualtPath = path;
        for (String each : macros) {
            actualtPath = actualtPath.replaceAll(each, this.myMap.get(each).getAbsolutePath());
        }
        File file2 = new File(actualtPath);
        if (!file2.isAbsolute()) {
            file2 = new File(defaultDir, actualtPath);
        }
        return file2;
    }
}

