/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final String myDescription;
    private final List<PluginId> myDepends;
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    private final boolean myForceHttps;
    private String myPluginVersion;
    private IdeaPluginDescriptor myDescriptor;
    private File myFile;
    private File myOldFile;

    private PluginDownloader(IdeaPluginDescriptor descriptor, String url, BuildNumber buildNumber, boolean forceHttps) {
        this.myPluginId = descriptor.getPluginId().getIdString();
        this.myPluginName = descriptor.getName();
        this.myProductCode = descriptor.getProductCode();
        this.myReleaseDate = descriptor.getReleaseDate();
        this.myReleaseVersion = descriptor.getReleaseVersion();
        this.myDescription = descriptor.getDescription();
        this.myDepends = descriptor instanceof PluginNode ? ((PluginNode)descriptor).getDepends() : Arrays.asList(descriptor.getDependentPluginIds());
        this.myPluginUrl = url;
        this.myBuildNumber = buildNumber;
        this.myForceHttps = forceHttps;
        this.myPluginVersion = descriptor.getVersion();
        this.myDescriptor = descriptor;
    }

    @NotNull
    public String getPluginId() {
        return this.myPluginId;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NotNull
    public String getPluginName() {
        return this.myPluginName != null ? this.myPluginName : this.myPluginId;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        if (this.myFile != null) {
            return true;
        }
        IdeaPluginDescriptor descriptor = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManager.isPluginInstalled(PluginId.getId((String)this.myPluginId))) {
            descriptor = PluginManager.getPlugin(PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(descriptor != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = descriptor.isBundled() ? null : descriptor.getPath();
        }
        String errorMessage = null;
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                if (errorMessage == null) {
                    errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                }
                String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                app.invokeLater(() -> Messages.showErrorDialog((String)text, (String)title), ModalityState.any());
            }
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDownloader.loadDescriptionFromJar(this.myFile);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                return false;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myDescriptor = actualDescriptor;
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return false;
            }
        }
        return true;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(@NotNull IdeaPluginDescriptor existingPlugin, String newPluginVersion) {
        int state = PluginDownloader.comparePluginVersions(newPluginVersion, existingPlugin.getVersion());
        if (state < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state = 1;
        }
        return state;
    }

    public static int comparePluginVersions(String newPluginVersion, String oldPluginVersion) {
        return VersionComparatorUtil.compare((String)newPluginVersion, (String)oldPluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptionFromJar(File file2) throws IOException {
        IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file2, "plugin.xml");
        if (descriptor == null && file2.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)file2, (File)outputDir, null);
                File[] files2 = outputDir.listFiles();
                if (files2 != null && files2.length == 1) {
                    descriptor = PluginManagerCore.loadDescriptor(files2[0], "plugin.xml");
                }
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        return descriptor;
    }

    public void install() throws IOException {
        if (this.myFile == null) {
            throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
        }
        PluginInstaller.install(this.myFile, true, this.myOldFile, this.myDescriptor);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor);
        }
    }

    @NotNull
    private File downloadPlugin(@NotNull ProgressIndicator indicator) throws IOException {
        File pluginsTemp = new File(PathManager.getPluginTempPath());
        if (!pluginsTemp.exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        return (File)HttpRequests.request((String)this.myPluginUrl).gzip(false).forceHttps(this.myForceHttps).productNameAsUserAgent().connect(request -> {
            request.saveToFile(file2, indicator);
            String fileName2 = this.guessFileName(request.getConnection(), file2);
            File newFile = new File(file2.getParentFile(), fileName2);
            FileUtil.rename((File)file2, (File)newFile);
            return newFile;
        });
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file2) throws IOException {
        String fileName2 = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName2 = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName2, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName2, (char)'\"')) {
                fileName2 = fileName2.substring(1, fileName2.length() - 1);
            }
        }
        if (fileName2 == null) {
            String usedURL = connection.getURL().toString();
            LOG.debug("url: " + usedURL);
            fileName2 = usedURL.substring(usedURL.lastIndexOf(47) + 1);
            if (fileName2.length() == 0 || fileName2.contains("?")) {
                fileName2 = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf(47) + 1);
            }
        }
        if (!PathUtil.isValidFileName(fileName2)) {
            LOG.debug("fileName: " + fileName2);
            FileUtil.delete((File)file2);
            throw new IOException("Invalid filename returned by a server");
        }
        return fileName2;
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor) throws IOException {
        return PluginDownloader.createDownloader(descriptor, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        boolean forceHttps = host == null && (ApplicationManager.getApplication() == null || UpdateSettings.getInstance().canUseSecureConnection());
        return PluginDownloader.createDownloader(descriptor, host, buildNumber, forceHttps);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber, boolean forceHttps) throws IOException {
        String url;
        try {
            if (host != null && descriptor instanceof PluginNode) {
                url = ((PluginNode)descriptor).getDownloadUrl();
                if (!new URI(url).isAbsolute()) {
                    url = new URL(new URL(host), url).toExternalForm();
                }
            } else {
                Application app = ApplicationManager.getApplication();
                ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
                String buildNumberAsString = buildNumber != null ? buildNumber.asString() : (app != null ? ApplicationInfo.getInstance().getApiVersion() : appInfo.getBuild().asString());
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("action", "download");
                parameters.put("id", descriptor.getPluginId().getIdString());
                parameters.put("build", buildNumberAsString);
                parameters.put("uuid", PermanentInstallationID.get());
                url = Urls.newFromEncoded(appInfo.getPluginsDownloadUrl()).addParameters(parameters).toExternalForm();
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return new PluginDownloader(descriptor, url, buildNumber, forceHttps);
    }

    @NotNull
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor = downloader.getDescriptor();
        if (descriptor instanceof PluginNode) {
            return (PluginNode)descriptor;
        }
        PluginNode node = new PluginNode(PluginId.getId((String)downloader.getPluginId()));
        node.setName(downloader.getPluginName());
        node.setProductCode(downloader.getProductCode());
        node.setReleaseDate(downloader.getReleaseDate());
        node.setReleaseVersion(downloader.getReleaseVersion());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDepends(downloader.myDepends, null);
        node.setDescription(downloader.myDescription);
        return node;
    }
}

