/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.IdeUpdateUsageTriggerCollector;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.analytics.StudioUpdateAnalyticsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0007JF\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020$022\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u0001052\b\u00107\u001a\u0004\u0018\u000108H\u0007J(\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0010\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020AH\u0007J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020>H\u0002J<\u0010E\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010:2\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u0001082\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u0001052\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0014\u0010H\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020602H\u0002J>\u0010I\u001a\u00020*2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>2\b\u00107\u001a\u0004\u0018\u0001082\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\n\u0010O\u001a\u0004\u0018\u00010PH\u0002J\b\u0010Q\u001a\u00020\u0004H\u0002J\u0010\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020TH\u0007J\u0012\u0010U\u001a\u0004\u0018\u00010\u00042\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010V\u001a\u00020\u00042\u0006\u0010S\u001a\u00020TH\u0007J\u0010\u0010W\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010:H\u0007J\u0012\u0010X\u001a\u0004\u0018\u00010Y2\u0006\u0010D\u001a\u00020>H\u0007J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020[H\u0002J\b\u0010]\u001a\u00020*H\u0007J\u0018\u0010^\u001a\u00020*2\u0006\u0010_\u001a\u00020\u001d2\u0006\u0010`\u001a\u00020\u0004H\u0002J0\u0010a\u001a\u00020*2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010`\u001a\u00020\u00042\f\u0010b\u001a\b\u0012\u0004\u0012\u00020*0c2\u0006\u0010d\u001a\u00020 H\u0002Jb\u0010e\u001a\u00020*2\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010f\u001a\u00020C2\u0006\u0010=\u001a\u00020>2\u000e\u0010g\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010:2\u000e\u00104\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010:2\u000e\u0010h\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:2\u0006\u0010i\u001a\u00020\u001d2\u0006\u0010j\u001a\u00020\u001dH\u0002J\u0010\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020\u000bH\u0003J \u0010n\u001a\u00020*2\u0006\u0010o\u001a\u00020\u00042\b\u0010p\u001a\u0004\u0018\u00010\u00042\u0006\u0010q\u001a\u00020\u001dJ\b\u0010r\u001a\u00020NH\u0007J\u001c\u0010r\u001a\u00020*2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010s\u001a\u0004\u0018\u00010>H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0013j\b\u0012\u0004\u0012\u00020\u0004`\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$0#j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006u"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "INSTALLATION_UID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "UTF8_BOM", "", "UTF8_BOM$annotations", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "()Ljava/util/Set;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "excludedFromUpdateCheckPlugins$annotations", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourAdditionalRequestOptions", "Lgnu/trove/THashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "Lcom/intellij/notification/Notification;", "ourUpdatedPlugins", "Ljava/util/HashMap;", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "Lkotlin/collections/HashMap;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "addUpdateRequestParameter", "", "name", "value", "checkAndPrepareToInstall", "downloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "incompatiblePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkExternalUpdates", "", "Lcom/intellij/openapi/updateSettings/impl/ExternalUpdate;", "manualCheck", "updateSettings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "checkPluginsUpdate", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "fromSettings", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "findAndroidHome", "Ljava/io/File;", "generateUUID", "getInstallationUID", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "getInstallationUIDOnWindows", "getIntelliJInstallationUID", "getPluginUpdates", "getUpdatesInfo", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "prepareUpdateCheckArgs", "Lcom/intellij/util/Url;", "url", "saveDisabledToUpdatePlugins", "showErrorMessage", "showDialog", "message", "showNotification", "action", "Lkotlin/Function0;", "notificationType", "showUpdateResult", "checkForUpdateResult", "updatedPlugins", "externalUpdates", "enableLink", "alwaysShowResults", "skipUtf8BOM", "", "bytes", "testPlatformUpdate", "updateInfoText", "patchFilePath", "forceUpdate", "updateAndShowResult", "customSettings", "NotificationUniqueType", "intellij.platform.ide.impl"})
public final class UpdateChecker {
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final THashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<String, PluginDownloader> ourUpdatedPlugins;
    private static final MultiMap<NotificationUniqueType, Notification> ourShownNotifications;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static final String INSTALLATION_UID = "installation.uid";
    private static final byte[] UTF8_BOM;
    private static boolean ourHasFailedPlugins;
    public static final UpdateChecker INSTANCE;

    public static /* synthetic */ void excludedFromUpdateCheckPlugins$annotations() {
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            string = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getCheckingUrl();
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback2 = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback2){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, null, true, false, UpdateSettings.getInstance(), null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback2;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project, project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, this.getProject(), this.$fromSettings, true, this.$settings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final Collection<PluginDownloader> getPluginUpdates() {
        return INSTANCE.checkPluginsUpdate(UpdateSettings.getInstance(), (ProgressIndicator)new EmptyProgressIndicator(), null, ApplicationInfo.getInstance().getBuild());
    }

    private final void doUpdateAndShowResult(Project project, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (result2.getState() == UpdateStrategy.State.CONNECTION_ERROR) {
            Exception e = result2.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            Object[] objectArray = new Object[1];
            Object object = e;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            objectArray[0] = object;
            this.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.error.connection.failed", (Object[])objectArray));
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        BuildInfo buildInfo = result2.getNewBuild();
        BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
        Collection incompatiblePlugins = buildNumber != null ? (Collection)new HashSet() : null;
        Collection<PluginDownloader> updatedPlugins = null;
        Collection<ExternalUpdate> externalUpdates = null;
        try {
            updatedPlugins = this.checkPluginsUpdate(updateSettings, indicator, incompatiblePlugins, buildNumber);
            externalUpdates = this.checkExternalUpdates(manualCheck, updateSettings, indicator);
        }
        catch (IOException e) {
            this.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()}));
            ActionCallback actionCallback = callback2;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        UpdateSettings.getInstance().saveLastCheckedInfo();
        ApplicationManager.getApplication().invokeLater(new Runnable(project, result2, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, fromSettings, manualCheck, callback2){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ UpdateSettings $updateSettings;
            final /* synthetic */ Collection $updatedPlugins;
            final /* synthetic */ Collection $incompatiblePlugins;
            final /* synthetic */ Collection $externalUpdates;
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ boolean $manualCheck;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                block0: {
                    UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$updateSettings, this.$updatedPlugins, this.$incompatiblePlugins, this.$externalUpdates, !this.$fromSettings, this.$manualCheck);
                    ActionCallback actionCallback = this.$callback;
                    if (actionCallback == null) break block0;
                    actionCallback.setDone();
                }
            }
            {
                this.$project = project;
                this.$result = checkForUpdateResult;
                this.$updateSettings = updateSettings;
                this.$updatedPlugins = collection;
                this.$incompatiblePlugins = collection2;
                this.$externalUpdates = collection3;
                this.$fromSettings = bl;
                this.$manualCheck = bl2;
                this.$callback = actionCallback;
            }
        });
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        UpdatesInfo updateInfo = null;
        try {
            Url updateUrl = Urls.newFromEncoded(this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)updateUrl.getScheme(), (Object)"file") ^ true) {
                updateUrl = this.prepareUpdateCheckArgs(updateUrl);
            }
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateInfo = (UpdatesInfo)HttpRequests.request((Url)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<UpdatesInfo>(settings){
                final /* synthetic */ UpdateSettings $settings;

                @Nullable
                public final UpdatesInfo process(@NotNull HttpRequests.Request it) {
                    UpdatesInfo updatesInfo;
                    try {
                        updatesInfo = this.$settings.isPlatformUpdateEnabled() ? new UpdatesInfo(JDOMUtil.load((Reader)it.getReader())) : null;
                    }
                    catch (JDOMException e) {
                        UpdateChecker.access$getLOG$p(UpdateChecker.INSTANCE).info((Throwable)e);
                        updatesInfo = null;
                    }
                    return updatesInfo;
                }
                {
                    this.$settings = updateSettings;
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        catch (Throwable e) {
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, new RuntimeException(e));
        }
        if (updateInfo == null) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        UpdateStrategy strategy = new UpdateStrategy(ApplicationInfo.getInstance().getBuild(), updateInfo, settings);
        return strategy.checkForUpdates();
    }

    @JvmStatic
    @Nullable
    public static final UpdatesInfo getUpdatesInfo(@NotNull UpdateSettings settings) throws IOException, JDOMException {
        Url updateUrl = Urls.newFromEncoded(INSTANCE.getUpdateUrl());
        return (UpdatesInfo)HttpRequests.request((Url)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)getUpdatesInfo.1.INSTANCE);
    }

    private final Collection<PluginDownloader> checkPluginsUpdate(UpdateSettings updateSettings, ProgressIndicator indicator, Collection<IdeaPluginDescriptor> incompatiblePlugins, BuildNumber buildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = this.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block2: for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadPlugins(host, buildNumber, forceHttps, indicator);
                for (IdeaPluginDescriptor descriptor : list2) {
                    PluginId id = descriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber, forceHttps);
                    UpdateChecker.checkAndPrepareToInstall(downloader, state, (Map)toUpdate, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block2;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                StringBuilder stringBuilder = new StringBuilder().append("failed to load plugin descriptions from ");
                String string = host;
                if (string == null) {
                    string = "default repository";
                }
                LOG.info(stringBuilder.append(string).append(": ").append(e.getMessage()).toString());
            }
        }
        return toUpdate.isEmpty() ? null : toUpdate.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        Object element$iv;
        PluginId pluginId;
        Object object;
        Iterable $receiver$iv$iv;
        void $receiver$iv$iv2;
        THashMap updateable = ContainerUtil.newTroveMap();
        Map map2 = (Map)updateable;
        Object $receiver$iv = PluginManagerCore.getPlugins();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (IdeaPluginDescriptor element$iv$iv2 : $receiver$iv$iv2) {
            void it = element$iv$iv2;
            boolean bl = false;
            if (!(!it.isBundled() || it.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            IdeaPluginDescriptor element$iv$iv2;
            element$iv$iv2 = (IdeaPluginDescriptor)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            pluginId = it.getPluginId();
            object.put(pluginId, element$iv$iv);
        }
        $receiver$iv = destination$iv$iv2;
        map2.putAll($receiver$iv);
        File onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                Iterator $receiver$iv$iv3;
                $receiver$iv = FileUtil.loadLines((File)onceInstalled);
                Object capacity$iv2 = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                destination$iv$iv2 = $receiver$iv$iv3.iterator();
                while (destination$iv$iv2.hasNext()) {
                    void line;
                    Object item$iv$iv = destination$iv$iv2.next();
                    String element$iv$iv = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    void $receiver$iv2 = line;
                    CharSequence $receiver$iv$iv4 = (CharSequence)$receiver$iv2;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv4.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv4.charAt(index$iv$iv);
                        boolean bl2 = false;
                        boolean bl3 = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    pluginId = PluginId.getId((String)((Object)$receiver$iv$iv4.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    object.add(pluginId);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv3 = $receiver$iv;
                destination$iv$iv = new ArrayList();
                destination$iv$iv2 = $receiver$iv$iv3.iterator();
                while (destination$iv$iv2.hasNext()) {
                    Object element$iv$iv = destination$iv$iv2.next();
                    PluginId it2 = (PluginId)element$iv$iv;
                    boolean bl4 = false;
                    if (!(!updateable.contains((Object)it2))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv3 = $receiver$iv.iterator();
                while ($receiver$iv$iv3.hasNext()) {
                    element$iv = $receiver$iv$iv3.next();
                    PluginId it = (PluginId)element$iv;
                    boolean bl = false;
                    Map it2 = (Map)updateable;
                    Object bl4 = null;
                    it2.put(it, bl4);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        if (!excludedFromUpdateCheckPlugins.isEmpty()) {
            Iterable $receiver$iv3;
            Project[] $receiver$iv$iv5 = ProjectManager.getInstance().getOpenProjects();
            element$iv = $receiver$iv3;
            destination$iv$iv2 = new ArrayList();
            Iterator bl = $receiver$iv$iv;
            int it2 = ((void)bl).length;
            for (int bl4 = 0; bl4 < it2; ++bl4) {
                void element$iv$iv;
                void it = element$iv$iv = bl[bl4];
                boolean bl5 = false;
                Iterable list$iv$iv = ExternalDependenciesManager.getInstance((Project)it).getDependencies(DependencyOnPlugin.class);
                CollectionsKt.addAll(destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv2;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                DependencyOnPlugin bl4 = (DependencyOnPlugin)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl6 = false;
                pluginId = PluginId.getId((String)it.getPluginId());
                object.add(pluginId);
            }
            Set required = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            $receiver$iv3 = excludedFromUpdateCheckPlugins;
            for (Object element$iv2 : $receiver$iv3) {
                IdeaPluginDescriptor plugin;
                String it = (String)element$iv2;
                boolean bl7 = false;
                PluginId excluded = PluginId.getId((String)it);
                if (required.contains(excluded) || (plugin = (IdeaPluginDescriptor)updateable.get((Object)excluded)) == null || !plugin.isBundled()) continue;
                updateable.remove((Object)excluded);
            }
        }
        return (Map)updateable;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ExternalUpdate> checkExternalUpdates(boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator) {
        ArrayList result2 = new ArrayList();
        ExternalComponentManager manager = ExternalComponentManager.getInstance();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.external.progress", (Object[])new Object[0]));
        }
        for (ExternalComponentSource source : manager.getComponentSources()) {
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            if (!updateSettings.getEnabledExternalUpdateSources().contains(source.getName())) continue;
            try {
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = source.getAvailableVersions(indicator, updateSettings);
                ExternalUpdate externalUpdate = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    UpdatableExternalComponent it = (UpdatableExternalComponent)element$iv$iv;
                    boolean bl = false;
                    if (!it.isUpdateFor(manager.findExistingComponentMatching(it, source))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List siteResult = (List)destination$iv$iv;
                if (siteResult.isEmpty()) continue;
                iterable = result2;
                externalUpdate = new ExternalUpdate(siteResult, source);
                iterable.add(externalUpdate);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                Object[] objectArray = new Object[2];
                objectArray[0] = source.getName();
                String string = e.getMessage();
                if (string == null) {
                    string = "internal error";
                }
                objectArray[1] = string;
                this.showErrorMessage(manualCheck, IdeBundle.message((String)"updates.external.error.message", (Object[])objectArray));
            }
        }
        return result2;
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        PluginDownloader downloader2 = downloader;
        String pluginId = downloader2.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(installedPlugin, pluginVersion) > 0) {
            Object object;
            Map map2;
            IdeaPluginDescriptor descriptor = null;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader2.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator)) {
                        descriptor = downloader2.getDescriptor();
                    }
                    map2 = ourUpdatedPlugins;
                    object = downloader2;
                    map2.put(pluginId, object);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (PluginManagerCore.isCompatible(descriptor, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                map2 = toUpdate;
                object = PluginId.getId((String)pluginId);
                PluginDownloader pluginDownloader = downloader2;
                map2.put(object, pluginDownloader);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && !PluginManagerCore.isCompatible(installedPlugin, downloader2.getBuildNumber())) {
            Collection<IdeaPluginDescriptor> collection = incompatiblePlugins;
            collection.add(installedPlugin);
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    private final void showUpdateResult(Project project, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection<? extends PluginDownloader> updatedPlugins, Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, Collection<? extends ExternalUpdate> externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        if (updatedChannel != null && newBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(checkForUpdateResult, updateSettings, updatedChannel, newBuild, enableLink, updatedPlugins, incompatiblePlugins){
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ UpdateSettings $updateSettings;
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $newBuild;
                final /* synthetic */ boolean $enableLink;
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ Collection $incompatiblePlugins;

                public final void invoke() {
                    UpdateChain patches2 = this.$checkForUpdateResult.getPatches();
                    boolean forceHttps = this.$updateSettings.canUseSecureConnection();
                    new UpdateInfoDialog(this.$updatedChannel, this.$newBuild, patches2, this.$enableLink, forceHttps, this.$updatedPlugins, this.$incompatiblePlugins).show();
                }
                {
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$updateSettings = updateSettings;
                    this.$updatedChannel = updateChannel;
                    this.$newBuild = buildInfo;
                    this.$enableLink = bl;
                    this.$updatedPlugins = collection;
                    this.$incompatiblePlugins = collection2;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLATFORM);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                StudioUpdateAnalyticsUtil.logUpdateDialogOpenManually((String)newBuild.getNumber().asStringWithoutProductCode());
                runnable2.invoke();
            } else {
                StudioUpdateAnalyticsUtil.logNotificationShown((String)newBuild.getNumber().asStringWithoutProductCode());
                IdeUpdateUsageTriggerCollector.trigger("notification.shown");
                String string = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                this.showNotification(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(newBuild, runnable2){
                    final /* synthetic */ BuildInfo $newBuild;
                    final /* synthetic */ Function0 $runnable;

                    public final void invoke() {
                        StudioUpdateAnalyticsUtil.logClickNotification((String)this.$newBuild.getNumber().asStringWithoutProductCode());
                        StudioUpdateAnalyticsUtil.logUpdateDialogOpenFromNotification((String)this.$newBuild.getNumber().asStringWithoutProductCode());
                        IdeUpdateUsageTriggerCollector.trigger("notification.clicked");
                        this.$runnable.invoke();
                    }
                    {
                        this.$newBuild = buildInfo;
                        this.$runnable = function0;
                        super(0);
                    }
                }), NotificationUniqueType.PLATFORM);
            }
            return;
        }
        boolean updateFound = false;
        if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            updateFound = true;
            Function0 function0 = (Function0)new Function0<Unit>(updatedPlugins, enableLink){
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ boolean $enableLink;

                public final void invoke() {
                    new PluginUpdateInfoDialog(this.$updatedPlugins, this.$enableLink).show();
                }
                {
                    this.$updatedPlugins = collection;
                    this.$enableLink = bl;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
            if (collection != null) {
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                function0.invoke();
            } else {
                String plugins2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.plugins.1.INSTANCE, (int)31, null);
                String message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins2});
                this.showNotification(project, message, (Function0<Unit>)function0, NotificationUniqueType.PLUGINS);
            }
        }
        if (externalUpdates != null && !externalUpdates.isEmpty()) {
            updateFound = true;
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.EXTERNAL);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    it.expire();
                }
            }
            for (ExternalUpdate externalUpdate : externalUpdates) {
                Function0 runnable4 = (Function0)new Function0<Unit>(externalUpdate){
                    final /* synthetic */ ExternalUpdate $update;

                    public final void invoke() {
                        this.$update.getSource().installUpdates(this.$update.getComponents());
                    }
                    {
                        this.$update = externalUpdate;
                        super(0);
                    }
                };
                if (alwaysShowResults) {
                    runnable4.invoke();
                    continue;
                }
                String updates = CollectionsKt.joinToString$default((Iterable)externalUpdate.getComponents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String message = IdeBundle.message((String)"updates.external.ready.message", (Object[])new Object[]{externalUpdate.getComponents().size(), updates});
                this.showNotification(project, message, (Function0<Unit>)runnable4, NotificationUniqueType.EXTERNAL);
            }
        }
        if (!updateFound && alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private final void showNotification(Project project, String message, Function0<Unit> action, NotificationUniqueType notificationType) {
        NotificationListener listener2 = new NotificationListener(action){
            final /* synthetic */ Function0 $action;

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent $noName_1) {
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        Notification notification = NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), NotificationType.INFORMATION, listener2);
        notification.whenExpired(new Runnable(notificationType, notification){
            final /* synthetic */ NotificationUniqueType $notificationType;
            final /* synthetic */ Notification $notification;

            public final void run() {
                UpdateChecker.access$getOurShownNotifications$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType), (Object)this.$notification);
            }
            {
                this.$notificationType = notificationUniqueType;
                this.$notification = notification;
            }
        });
        notification.notify(project);
        ourShownNotifications.putValue((Object)notificationType, (Object)notification);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        Map map2 = (Map)ourAdditionalRequestOptions;
        String string = value;
        map2.put(name, string);
    }

    private final Url prepareUpdateCheckArgs(Url url) {
        UpdateChecker.addUpdateRequestParameter("build", ApplicationInfo.getInstance().getBuild().asString());
        UpdateChecker.addUpdateRequestParameter("uid", PermanentInstallationID.get());
        if (SystemInfo.isChromeOS) {
            UpdateChecker.addUpdateRequestParameter("os", "chromium " + FilesKt.readText$default((File)new File("/dev/.cros_milestone"), null, (int)1, null));
        } else {
            UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        }
        if (ExternalUpdateManager.ACTUAL != null) {
            UpdateChecker.addUpdateRequestParameter("manager", ExternalUpdateManager.ACTUAL.toolName);
        }
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        return url.addParameters((Map)ourAdditionalRequestOptions);
    }

    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent propertiesComponent) {
        File home = INSTANCE.findAndroidHome();
        if (home == null) {
            return UpdateChecker.getIntelliJInstallationUID(propertiesComponent);
        }
        if (!home.exists() && !home.mkdirs()) {
            return UpdateChecker.getIntelliJInstallationUID(propertiesComponent);
        }
        File uidFile = new File(home, "uid.txt");
        if (uidFile.exists()) {
            try {
                String $receiver$iv = FileUtil.loadFile((File)uidFile);
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                return ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            catch (IOException e) {
                return UpdateChecker.getIntelliJInstallationUID(propertiesComponent);
            }
        }
        String uuid = UpdateChecker.getIntelliJInstallationUID(propertiesComponent);
        try {
            FileUtil.writeToFile((File)uidFile, (String)uuid);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return uuid;
    }

    private final File findAndroidHome() {
        String[] envVars;
        String[] $receiver$iv;
        String[] stringArray = $receiver$iv = (envVars = new String[]{"%UserProfile%", "HOME", "user.home"});
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String envVar = element$iv = stringArray[i];
            boolean bl = false;
            String v = System.getenv(envVar);
            if (v == null || !new File(v).exists()) continue;
            return new File(v, ".android");
        }
        return null;
    }

    @JvmStatic
    private static /* synthetic */ void UTF8_BOM$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String getIntelliJInstallationUID(@NotNull PropertiesComponent propertiesComponent) {
        String uid;
        if (SystemInfo.isWindows && (uid = INSTANCE.getInstallationUIDOnWindows(propertiesComponent)) != null) {
            return uid;
        }
        uid = propertiesComponent.getValue(INSTALLATION_UID);
        if (uid == null) {
            uid = INSTANCE.generateUUID();
            propertiesComponent.setValue(INSTALLATION_UID, uid);
        }
        return uid;
    }

    private final String getInstallationUIDOnWindows(PropertiesComponent propertiesComponent) {
        File jetBrainsDir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((jetBrainsDir = new File(appdata, "JetBrains")).exists() || jetBrainsDir.mkdirs())) {
            File permanentIdFile = new File(jetBrainsDir, "PermanentUserId");
            try {
                if (permanentIdFile.exists()) {
                    byte[] bytes = FileUtil.loadFileBytes((File)permanentIdFile);
                    int offset = UpdateChecker.skipUtf8BOM(bytes);
                    int n = bytes.length - offset;
                    Charset charset = Charset.forName("utf-8");
                    return new String(bytes, offset, n, charset);
                }
                String uuid = propertiesComponent.getValue(INSTALLATION_UID);
                if (uuid == null) {
                    uuid = this.generateUUID();
                }
                FileUtil.writeToFile((File)permanentIdFile, (String)uuid);
                return uuid;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final int skipUtf8BOM(byte[] bytes) {
        if (bytes.length < UTF8_BOM.length) {
            return 0;
        }
        int n = 0;
        int n2 = UTF8_BOM.length;
        while (n < n2) {
            void idx;
            if (bytes[idx] != UTF8_BOM[idx]) {
                return 0;
            }
            ++idx;
        }
        return UTF8_BOM.length;
    }

    private final String generateUUID() {
        String string;
        try {
            string = UUID.randomUUID().toString();
        }
        catch (Exception ignored) {
            string = "";
        }
        catch (InternalError ignored) {
            string = "";
        }
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file2.isFile()) {
                        Iterator iterator;
                        void $receiver$iv$iv;
                        CharSequence charSequence = FileUtil.loadFile((File)file2);
                        Object object = "[\\s]";
                        object = new Regex((String)object);
                        int n = 0;
                        Iterable $receiver$iv = object.split(charSequence, n);
                        object = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void it;
                            void var8_12;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v0 = var8_12 = it;
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                            collection.add(string2);
                        }
                        $receiver$iv = (List)((Object)iterator);
                        Set<String> set2 = ourDisabledToUpdatePlugins;
                        if (set2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Collection destination$iv = set2;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            CharSequence charSequence2 = it;
                            if (!(charSequence2.length() > 0)) continue;
                            destination$iv.add(element$iv);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Set<String> set3 = ourDisabledToUpdatePlugins;
        if (set3 == null) {
            Intrinsics.throwNpe();
        }
        return set3;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList((Collection<String>)UpdateChecker.getDisabledToUpdatePlugins(), false, plugins2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        IdeaPluginDescriptor pluginDescriptor;
        Application app;
        if (!(ourHasFailedPlugins || (app = ApplicationManager.getApplication()) == null || app.isDisposed() || app.isDisposeInProgress() || !UpdateSettings.getInstance().isCheckNeeded() || (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(event.getThrowable()))) == null || pluginDescriptor.isBundled())) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    public final void testPlatformUpdate(@NotNull String updateInfoText, @Nullable String patchFilePath, boolean forceUpdate) {
        if (!ApplicationManager.getApplication().isInternal()) {
            throw (Throwable)new IllegalStateException();
        }
        UpdateChannel channel = null;
        BuildInfo newBuild = null;
        UpdateChain patches2 = null;
        if (forceUpdate) {
            UpdateChain updateChain;
            Element element = JDOMUtil.load((CharSequence)updateInfoText).getChild("product");
            if (element == null || (element = element.getChild("channel")) == null) {
                throw (Throwable)new IllegalArgumentException("//channel missing");
            }
            Element node = element;
            channel = new UpdateChannel(node);
            BuildInfo buildInfo = (BuildInfo)CollectionsKt.firstOrNull(channel.getBuilds());
            if (buildInfo == null) {
                throw (Throwable)new IllegalArgumentException("//build missing");
            }
            newBuild = buildInfo;
            PatchInfo patchInfo = (PatchInfo)CollectionsKt.firstOrNull(newBuild.getPatches());
            if (patchInfo != null) {
                PatchInfo patchInfo2;
                PatchInfo it = patchInfo2 = patchInfo;
                boolean bl = false;
                updateChain = new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{it.getFromBuild(), newBuild.getNumber()}), it.getSize());
            } else {
                updateChain = null;
            }
            patches2 = updateChain;
        } else {
            UpdatesInfo updateInfo = new UpdatesInfo(JDOMUtil.load((CharSequence)updateInfoText));
            UpdateStrategy strategy = new UpdateStrategy(ApplicationInfo.getInstance().getBuild(), updateInfo);
            CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
            channel = checkForUpdateResult.getUpdatedChannel();
            newBuild = checkForUpdateResult.getNewBuild();
            patches2 = checkForUpdateResult.getPatches();
        }
        if (channel != null && newBuild != null) {
            File patchFile = patchFilePath != null ? new File(FileUtil.toSystemDependentName((String)patchFilePath)) : null;
            new UpdateInfoDialog(channel, newBuild, patches2, patchFile).show();
        } else {
            new NoUpdatesDialog(true).show();
        }
    }

    private UpdateChecker() {
    }

    static {
        UpdateChecker updateChecker;
        INSTANCE = updateChecker = new UpdateChecker();
        LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
        NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
        ourAdditionalRequestOptions = new THashMap();
        ourUpdatedPlugins = new HashMap();
        ourShownNotifications = new MultiMap();
        excludedFromUpdateCheckPlugins = new HashSet();
        INSTALLATION_UID = INSTALLATION_UID;
        UTF8_BOM = new byte[]{(byte)239, (byte)187, (byte)191};
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, Project project, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback2) {
        $this.doUpdateAndShowResult(project, fromSettings, manualCheck, updateSettings, indicator, callback2);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, Project project, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection updatedPlugins, Collection incompatiblePlugins, Collection externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        $this.showUpdateResult(project, checkForUpdateResult, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, enableLink, alwaysShowResults);
    }

    public static final /* synthetic */ Logger access$getLOG$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return LOG;
    }

    public static final /* synthetic */ MultiMap access$getOurShownNotifications$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotifications;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "PLATFORM", "PLUGINS", "EXTERNAL", "intellij.platform.ide.impl"})
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType PLATFORM;
        public static final /* enum */ NotificationUniqueType PLUGINS;
        public static final /* enum */ NotificationUniqueType EXTERNAL;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = PLATFORM = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = PLUGINS = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = EXTERNAL = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }
}

