/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Restarter;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.lang.JavaVersion;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J,\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\u001e\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010!J)\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "()V", "PATCH_FILE_NAME", "", "UPDATER_ENTRY", "UPDATER_MAIN_CLASS", "patchesUrl", "Ljava/net/URL;", "getPatchesUrl", "()Ljava/net/URL;", "cleanupPatch", "", "downloadPatchChain", "", "Ljava/io/File;", "chain", "Lcom/intellij/openapi/util/BuildNumber;", "forceHttps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findLib", "libName", "getJdkSuffix", "getTempDir", "installPluginUpdates", "downloaders", "", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "preparePatchCommand", "", "patchFile", "(Ljava/io/File;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "patchFiles", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class UpdateInstaller {
    @NotNull
    public static final String UPDATER_MAIN_CLASS = "com.intellij.updater.Runner";
    private static final String PATCH_FILE_NAME = "patch-file.zip";
    private static final String UPDATER_ENTRY = "com/intellij/updater/Runner.class";
    public static final UpdateInstaller INSTANCE;

    private final URL getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            string = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getPatchesUrl();
        }
        return new URL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<File> downloadPatchChain(@NotNull List<? extends BuildNumber> chain, boolean forceHttps, @NotNull ProgressIndicator indicator) throws IOException {
        indicator.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        List files2 = new ArrayList();
        String product = ApplicationInfo.getInstance().getBuild().getProductCode();
        String jdk = INSTANCE.getJdkSuffix();
        double share = 1.0 / (double)(chain.size() - 1);
        int n = 1;
        int n2 = chain.size();
        while (n < n2) {
            void i;
            String from = chain.get((int)(i - true)).withoutProductCode().asString();
            String to = chain.get((int)i).withoutProductCode().asString();
            String patchName = product + '-' + from + '-' + to + "-patch" + jdk + '-' + PatchInfo.Companion.getOS_SUFFIX() + ".jar";
            System.out.println("  patchName: " + patchName);
            File patchFile = new File(INSTANCE.getTempDir(), patchName);
            String url = new URL(INSTANCE.getPatchesUrl(), patchName).toString();
            DelegatingProgressIndicator partIndicator2 = new DelegatingProgressIndicator((int)i, share, indicator, indicator){
                final /* synthetic */ int $i;
                final /* synthetic */ double $share;
                final /* synthetic */ ProgressIndicator $indicator;

                public void setFraction(double fraction) {
                    super.setFraction((double)(this.$i - 1) * this.$share + fraction / this.$share);
                }
                {
                    this.$i = $captured_local_variable$0;
                    this.$share = $captured_local_variable$1;
                    this.$indicator = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            };
            HttpRequests.request((String)url).gzip(false).forceHttps(forceHttps).saveToFile(patchFile, (ProgressIndicator)partIndicator2);
            Object object = new ZipFile(patchFile);
            Throwable throwable = null;
            try {
                ZipFile it = (ZipFile)object;
                boolean bl = false;
                if (it.getEntry(PATCH_FILE_NAME) == null || it.getEntry(UPDATER_ENTRY) == null) {
                    throw (Throwable)new IOException("Corrupted patch file: " + patchFile.getName());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = files2;
            object.add(patchFile);
            ++i;
        }
        return files2;
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<? extends PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        indicator.setText(IdeBundle.message((String)"update.downloading.plugins.progress", (Object[])new Object[0]));
        UpdateChecker.saveDisabledToUpdatePlugins();
        Set<String> disabledToUpdate = UpdateChecker.getDisabledToUpdatePlugins();
        List readyToInstall = new ArrayList();
        for (PluginDownloader pluginDownloader : downloaders) {
            try {
                if (!disabledToUpdate.contains(pluginDownloader.getPluginId()) && pluginDownloader.prepareToInstall(indicator)) {
                    Collection collection = readyToInstall;
                    collection.add(pluginDownloader);
                }
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(readyToInstall, booleanRef){
            final /* synthetic */ List $readyToInstall;
            final /* synthetic */ Ref.BooleanRef $installed;

            public final void run() {
                for (PluginDownloader downloader : this.$readyToInstall) {
                    try {
                        downloader.install();
                        this.$installed.element = true;
                    }
                    catch (Exception e) {
                        Logger.getInstance(UpdateChecker.class).info((Throwable)e);
                    }
                }
            }
            {
                this.$readyToInstall = list2;
                this.$installed = booleanRef;
            }
        });
        return booleanRef.element;
    }

    @JvmStatic
    public static final void cleanupPatch() {
        File tempDir = INSTANCE.getTempDir();
        if (tempDir.exists()) {
            FileUtil.delete((File)tempDir);
        }
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull File patchFile, @NotNull ProgressIndicator indicator) throws IOException {
        return UpdateInstaller.preparePatchCommand(CollectionsKt.listOf((Object)patchFile), indicator);
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull List<? extends File> patchFiles, @NotNull ProgressIndicator indicator) throws IOException {
        indicator.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
        File log4j = INSTANCE.findLib("log4j.jar");
        File jna = INSTANCE.findLib("jna.jar");
        File jnaUtils = INSTANCE.findLib("jna-platform.jar");
        File tempDir = INSTANCE.getTempDir();
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)tempDir.getPath(), (boolean)true)) {
            throw (Throwable)new IOException("Temp directory inside installation: " + tempDir);
        }
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new IOException("Cannot create temp directory: " + tempDir);
        }
        File log4jCopy = FilesKt.copyTo$default((File)log4j, (File)new File(tempDir, log4j.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaCopy = FilesKt.copyTo$default((File)jna, (File)new File(tempDir, jna.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaUtilsCopy = FilesKt.copyTo$default((File)jnaUtils, (File)new File(tempDir, jnaUtils.getName()), (boolean)true, (int)0, (int)4, null);
        String java = System.getProperty("java.home");
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)java, (boolean)true)) {
            File javaCopy = new File(tempDir, "jre");
            FileUtil.copyDir((File)new File(java), (File)javaCopy);
            java = javaCopy.getPath();
        }
        ArrayList args = new ArrayList();
        if (SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]))) {
            File launcher = PathManager.findBinFile((String)"launcher.exe");
            File elevator = PathManager.findBinFile((String)"elevator.exe");
            if (launcher != null && elevator != null && launcher.canExecute() && elevator.canExecute()) {
                Collection collection = args;
                String string = Restarter.createTempExecutable(launcher).getPath();
                collection.add(string);
                Restarter.createTempExecutable(elevator);
            }
        }
        Collection collection = args;
        String string = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        collection.add(string);
        collection = args;
        string = StringsKt.startsWith$default((String)INSTANCE.getJdkSuffix(), (String)"-jbr1", (boolean)false, (int)2, null) ? "-Xmx2000m" : "-Xmx900m";
        collection.add(string);
        collection = args;
        string = "-cp";
        collection.add(string);
        collection = args;
        string = ArraysKt.joinToString$default((Object[])new String[]{((File)CollectionsKt.last(patchFiles)).getPath(), log4jCopy.getPath(), jnaCopy.getPath(), jnaUtilsCopy.getPath()}, (CharSequence)File.pathSeparator, null, null, (int)0, null, null, (int)62, null);
        collection.add(string);
        collection = args;
        string = "-Djna.nosys=true";
        collection.add(string);
        collection = args;
        string = "-Djna.boot.library.path=";
        collection.add(string);
        collection = args;
        string = "-Djna.debug_load=true";
        collection.add(string);
        collection = args;
        string = "-Djna.debug_load.jna=true";
        collection.add(string);
        collection = args;
        string = "-Djava.io.tmpdir=" + tempDir.getPath();
        collection.add(string);
        collection = args;
        string = "-Didea.updater.log=" + PathManager.getLogPath();
        collection.add(string);
        collection = args;
        string = "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName();
        collection.add(string);
        collection = args;
        string = UPDATER_MAIN_CLASS;
        collection.add(string);
        collection = args;
        string = patchFiles.size() == 1 ? "install" : "batch-install";
        collection.add(string);
        collection = args;
        string = PathManager.getHomePath();
        collection.add(string);
        if (patchFiles.size() > 1) {
            collection = args;
            string = CollectionsKt.joinToString$default((Iterable)patchFiles, (CharSequence)File.pathSeparator, null, null, (int)0, null, null, (int)62, null);
            collection.add(string);
        }
        return ArrayUtil.toStringArray((Collection)args);
    }

    private final File findLib(String libName) {
        File libFile = new File(PathManager.getLibPath(), libName);
        if (!libFile.exists()) {
            throw (Throwable)new IOException("Missing: " + libFile);
        }
        return libFile;
    }

    private final File getTempDir() {
        return new File(PathManager.getTempPath(), "patch-update");
    }

    private final String getJdkSuffix() {
        int n;
        File jreHome = new File(PathManager.getHomePath(), SystemInfo.isMac ? "jre/jdk" : "jre");
        if (!jreHome.exists()) {
            return "-no-jbr";
        }
        File releaseFile = new File(jreHome, SystemInfo.isMac ? "Contents/Home/release" : "release");
        try {
            Object element$iv2;
            block4: {
                Iterable $receiver$iv = FilesKt.readLines$default((File)releaseFile, null, (int)1, null);
                for (Object element$iv2 : $receiver$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"JAVA_VERSION=", (boolean)false, (int)2, null)) continue;
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            String it = (String)t;
            boolean bl = false;
            n = JavaVersion.parse((String)it).feature;
        }
        catch (Exception e) {
            n = 0;
        }
        int version2 = n;
        return version2 == 11 ? "-jbr11" : "";
    }

    private UpdateInstaller() {
    }

    static {
        UpdateInstaller updateInstaller;
        INSTANCE = updateInstaller = new UpdateInstaller();
    }
}

