/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsProviderHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UpdatesConfigurable", storages={@Storage(value="updates.xml", roamingType=RoamingType.DISABLED, exportable=true)})
public class UpdateSettings
implements PersistentStateComponent<UpdateOptions> {
    private UpdateOptions myState = new UpdateOptions();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    public boolean isPlatformUpdateEnabled() {
        return ExternalUpdateManager.ACTUAL == null;
    }

    @NotNull
    public UpdateOptions getState() {
        return this.myState;
    }

    public void loadState(@NotNull UpdateOptions state) {
        this.myState = state;
    }

    @Nullable
    public String getLastBuildChecked() {
        return this.myState.getLastBuildChecked();
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        return this.myState.getPluginHosts();
    }

    public boolean isCheckNeeded() {
        return this.myState.isCheckNeeded();
    }

    public void setCheckNeeded(boolean value) {
        this.myState.setCheckNeeded(value);
    }

    public List<String> getEnabledExternalUpdateSources() {
        return this.myState.getEnabledExternalComponentSources();
    }

    public List<String> getKnownExternalUpdateSources() {
        return this.myState.getKnownExternalComponentSources();
    }

    public Map<String, String> getExternalUpdateChannels() {
        return this.myState.getExternalUpdateChannels();
    }

    public boolean isSecureConnection() {
        return this.myState.isUseSecureConnection();
    }

    public void setSecureConnection(boolean value) {
        this.myState.setUseSecureConnection(value);
    }

    public long getLastTimeChecked() {
        return this.myState.getLastTimeChecked();
    }

    @NotNull
    public List<String> getIgnoredBuildNumbers() {
        return this.myState.getIgnoredBuildNumbers();
    }

    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        return ChannelStatus.fromCode(this.myState.getUpdateChannelType());
    }

    public void setSelectedChannelStatus(@NotNull ChannelStatus channel) {
        this.myState.setUpdateChannelType(channel.getCode());
    }

    @NotNull
    public List<ChannelStatus> getActiveChannels() {
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        return Stream.of(ChannelStatus.values()).filter(ch -> ch == ChannelStatus.EAP || ch == ChannelStatus.RELEASE || tweaker.isChannelActive((ChannelStatus)((Object)ch))).collect(Collectors.toList());
    }

    @NotNull
    public ChannelStatus getSelectedActiveChannel() {
        ChannelStatus current;
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        return tweaker.isChannelActive(current = this.getSelectedChannelStatus()) ? current : this.getActiveChannels().stream().filter(ch -> ch.compareTo(current) > 0).findFirst().orElse(ChannelStatus.RELEASE);
    }

    @NotNull
    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(this.myState.getPluginHosts());
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        UpdateSettingsProviderHelper.addPluginRepositories(hosts);
        return hosts;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.setLastTimeChecked(0L);
    }

    public void saveLastCheckedInfo() {
        this.myState.setLastTimeChecked(System.currentTimeMillis());
        this.myState.setLastBuildChecked(ApplicationInfo.getInstance().getBuild().asString());
    }

    public boolean canUseSecureConnection() {
        return this.myState.isUseSecureConnection() && NetUtils.isSniEnabled();
    }

    public boolean isThirdPartyPluginsAllowed() {
        return this.myState.isThirdPartyPluginsAllowed();
    }

    public void setThirdPartyPluginsAllowed(boolean value) {
        this.myState.setThirdPartyPluginsAllowed(value);
    }
}

