/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UpdateSettingsConfigurable
implements SearchableConfigurable {
    private final UpdateSettings mySettings = UpdateSettings.getInstance();
    private final boolean myCheckNowEnabled;
    private UpdatesSettingsPanel myPanel;

    public UpdateSettingsConfigurable() {
        this(true);
    }

    public UpdateSettingsConfigurable(boolean checkNowEnabled) {
        this.myCheckNowEnabled = checkNowEnabled;
    }

    public JComponent createComponent() {
        this.myPanel = new UpdatesSettingsPanel(this.myCheckNowEnabled);
        return this.myPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.updates";
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    public void apply() throws ConfigurationException {
        UpdateCheckerComponent checker;
        if (this.myPanel.myUseSecureConnection.isSelected() && !NetUtils.isSniEnabled()) {
            throw new ConfigurationException(IdeBundle.message((String)"update.sni.disabled.error", (Object[])new Object[0]));
        }
        boolean wasEnabled = this.mySettings.isCheckNeeded();
        this.mySettings.setCheckNeeded(this.myPanel.myCheckForUpdates.isSelected());
        if (wasEnabled != this.mySettings.isCheckNeeded() && (checker = (UpdateCheckerComponent)ApplicationManager.getApplication().getComponent(UpdateCheckerComponent.class)) != null) {
            if (wasEnabled) {
                checker.cancelChecks();
            } else {
                checker.queueNextCheck();
            }
        }
        this.mySettings.setSelectedChannelStatus(this.myPanel.getSelectedChannelType());
        this.mySettings.setSecureConnection(this.myPanel.myUseSecureConnection.isSelected());
    }

    public void reset() {
        this.myPanel.myCheckForUpdates.setSelected(this.mySettings.isCheckNeeded());
        this.myPanel.myUseSecureConnection.setSelected(this.mySettings.isSecureConnection());
        this.myPanel.updateLastCheckedLabel();
        this.myPanel.setSelectedChannelType(this.mySettings.getSelectedActiveChannel());
    }

    public boolean isModified() {
        if (this.myPanel == null) {
            return false;
        }
        if (this.mySettings.isCheckNeeded() != this.myPanel.myCheckForUpdates.isSelected() || this.mySettings.isSecureConnection() != this.myPanel.myUseSecureConnection.isSelected()) {
            return true;
        }
        Object channel = this.myPanel.myUpdateChannels.getSelectedItem();
        return channel != null && !channel.equals((Object)this.mySettings.getSelectedActiveChannel());
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static class UpdatesSettingsPanel {
        private final UpdateSettings mySettings;
        private JPanel myPanel;
        private JCheckBox myCheckForUpdates;
        private JComboBox<ChannelStatus> myUpdateChannels;
        private JButton myCheckNow;
        private JBLabel myChannelWarning;
        private JCheckBox myUseSecureConnection;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private JPanel myStatusPanel;
        private ActionLink myIgnoredBuildsLink;

        UpdatesSettingsPanel(boolean checkNowEnabled) {
            this.$$$setupUI$$$();
            this.mySettings = UpdateSettings.getInstance();
            ChannelStatus current = this.mySettings.getSelectedActiveChannel();
            this.myUpdateChannels.setModel((ComboBoxModel<ChannelStatus>)new CollectionComboBoxModel(this.mySettings.getActiveChannels(), (Object)current));
            ExternalUpdateManager manager = ExternalUpdateManager.ACTUAL;
            if (manager != null) {
                this.myCheckForUpdates.setText(IdeBundle.message((String)"updates.settings.checkbox.external", (Object[])new Object[0]));
                this.myUpdateChannels.setVisible(false);
                this.myChannelWarning.setText(IdeBundle.message((String)"updates.settings.external", (Object[])new Object[]{manager.toolName}));
                this.myChannelWarning.setForeground((Color)JBColor.GRAY);
                this.myChannelWarning.setVisible(true);
                this.myChannelWarning.setBorder((Border)new JBEmptyBorder(0, 0, 10, 0));
            } else if (ApplicationInfoEx.getInstanceEx().isMajorEAP() && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
                this.myUpdateChannels.setEnabled(false);
                this.myUpdateChannels.setToolTipText(IdeBundle.message((String)"updates.settings.channel.locked", (Object[])new Object[0]));
            } else {
                this.myUpdateChannels.addActionListener(e -> {
                    boolean lessStable = current.compareTo(this.getSelectedChannelType()) > 0;
                    this.myChannelWarning.setVisible(lessStable);
                });
                this.myChannelWarning.setForeground((Color)JBColor.RED);
            }
            if (checkNowEnabled) {
                this.myCheckNow.addActionListener(e -> {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myCheckNow));
                    UpdateSettings settings = new UpdateSettings();
                    settings.loadState(this.mySettings.getState());
                    settings.setSelectedChannelStatus(this.getSelectedChannelType());
                    settings.setSecureConnection(this.myUseSecureConnection.isSelected());
                    UpdateChecker.updateAndShowResult(project, settings);
                    this.updateLastCheckedLabel();
                });
            } else {
                this.myCheckNow.setVisible(false);
            }
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            this.myVersionNumber.setText(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + appInfo.getFullVersion());
            this.myBuildNumber.setText(appInfo.getBuild().asString());
        }

        private void createUIComponents() {
            this.myIgnoredBuildsLink = new ActionLink(IdeBundle.message((String)"updates.settings.ignored", (Object[])new Object[0]), new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    List<String> buildNumbers = mySettings.getIgnoredBuildNumbers();
                    String text = StringUtil.join(buildNumbers, (String)"\n");
                    String result2 = Messages.showMultilineInputDialog(null, null, (String)IdeBundle.message((String)"updates.settings.ignored.title", (Object[])new Object[0]), (String)text, null, null);
                    if (result2 != null) {
                        buildNumbers.clear();
                        buildNumbers.addAll(StringUtil.split((String)result2, (String)"\n"));
                    }
                }
            });
            ArrayList extraStatuses = Lists.newArrayList();
            for (ExternalComponentSource source : ExternalComponentManager.getInstance().getComponentSources()) {
                extraStatuses.addAll(source.getStatuses());
            }
            int row2 = 0;
            this.myStatusPanel = new JPanel((LayoutManager)new GridLayoutManager(extraStatuses.size() + 3, 2));
            GridConstraints statusLabelConstraints = new GridConstraints(row2, 0, 1, 1, 8, 0, 0, 0, null, null, null);
            GridConstraints statusValueConstraints = new GridConstraints(row2, 1, 1, 1, 8, 0, 0, 0, null, null, null);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.last.check", (Object[])new Object[0])), statusLabelConstraints);
            this.myLastCheckedDate = new JLabel();
            this.myStatusPanel.add((Component)this.myLastCheckedDate, statusValueConstraints);
            statusLabelConstraints.setRow(++row2);
            statusValueConstraints.setRow(row2);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.current.version", (Object[])new Object[0])), statusLabelConstraints);
            this.myVersionNumber = new JLabel();
            this.myStatusPanel.add((Component)this.myVersionNumber, statusValueConstraints);
            statusLabelConstraints.setRow(++row2);
            statusValueConstraints.setRow(row2);
            this.myStatusPanel.add((Component)new JLabel(IdeBundle.message((String)"updates.settings.build.number", (Object[])new Object[0])), statusLabelConstraints);
            this.myBuildNumber = new JLabel();
            this.myStatusPanel.add((Component)this.myBuildNumber, statusValueConstraints);
            for (Pair extra : extraStatuses) {
                statusLabelConstraints.setRow(++row2);
                statusValueConstraints.setRow(row2);
                this.myStatusPanel.add((Component)new JLabel((String)extra.first), statusLabelConstraints);
                this.myStatusPanel.add((Component)new JLabel((String)extra.second), statusValueConstraints);
            }
        }

        private void updateLastCheckedLabel() {
            long time = this.mySettings.getLastTimeChecked();
            if (time <= 0L) {
                this.myLastCheckedDate.setText(IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]));
            } else {
                this.myLastCheckedDate.setText(DateFormatUtil.formatPrettyDateTime((long)time));
                this.myLastCheckedDate.setToolTipText(DateFormatUtil.formatDate((long)time) + ' ' + DateFormatUtil.formatTimeWithSeconds((long)time));
            }
        }

        public ChannelStatus getSelectedChannelType() {
            return (ChannelStatus)((Object)this.myUpdateChannels.getSelectedItem());
        }

        public void setSelectedChannelType(ChannelStatus channelType) {
            this.myUpdateChannels.setSelectedItem((Object)(channelType != null ? channelType : ChannelStatus.RELEASE));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JBLabel jBLabel;
            JButton jButton;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.createUIComponents();
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myCheckForUpdates = jCheckBox2 = new JCheckBox();
            jCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.checkbox"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox = new JComboBox();
            this.myUpdateChannels = jComboBox;
            jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myCheckNow = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.check.now.button"));
            jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myChannelWarning = jBLabel = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.unstable"));
            jBLabel.setVisible(false);
            jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            this.myUseSecureConnection = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.secure"));
            jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText(" ");
            jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(" ");
            jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            ActionLink actionLink = this.myIgnoredBuildsLink;
            this.$$$loadLabelText$$$((JLabel)actionLink, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.ignored"));
            jPanel.add((Component)actionLink, new GridConstraints(6, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 3, 5, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(7, 0, 1, 4, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = this.myStatusPanel;
            jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

