/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

class ExperimentalFeatureRegistryValueWrapper
extends RegistryValue {
    private final ExperimentalFeature myFeature;

    ExperimentalFeatureRegistryValueWrapper(@NotNull ExperimentalFeature feature) {
        super(Registry.getInstance(), feature.id, null);
        this.myFeature = feature;
    }

    @NotNull
    public String getKey() {
        return this.myFeature.id;
    }

    protected String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        return this.asString();
    }

    @NotNull
    public String asString() {
        return Boolean.toString(this.asBoolean());
    }

    public boolean asBoolean() {
        return Experiments.isFeatureEnabled((String)this.myFeature.id);
    }

    boolean isRestartRequired() {
        return false;
    }

    public boolean isChangedFromDefault() {
        return Experiments.isChanged((String)this.myFeature.id);
    }

    public boolean isBoolean() {
        return true;
    }

    public void setValue(String value) {
        boolean enable = Boolean.parseBoolean(value);
        Experiments.setFeatureEnabled((String)this.myFeature.id, (boolean)enable);
    }

    @NotNull
    public String getDescription() {
        return this.myFeature.description;
    }
}

