/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.ExperimentalFeatureRegistryValueWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryUi
implements Disposable {
    private static final String RECENT_PROPERTIES_KEY = "RegistryRecentKeys";
    private static final String REQUIRES_IDE_RESTART = "Requires IDE Restart";
    private final JBTable myTable;
    private final JTextArea myDescriptionLabel;
    private final JPanel myContent = new JPanel();
    private static final Icon RESTART_ICON = PlatformIcons.CHECK_ICON;
    private final RestoreDefaultsAction myRestoreDefaultsAction;
    private final MyTableModel myModel;
    private static final Map<Color, Icon> icons_cache = new HashMap<Color, Icon>();

    public RegistryUi() {
        this.myContent.setLayout(new BorderLayout(10, 4));
        this.myModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myModel);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setEnableAntialiasing(true);
        MyRenderer r = new MyRenderer();
        TableColumn c0 = this.myTable.getColumnModel().getColumn(0);
        c0.setCellRenderer(r);
        c0.setMaxWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setMinWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setHeaderValue(null);
        TableColumn c1 = this.myTable.getColumnModel().getColumn(1);
        c1.setCellRenderer(r);
        c1.setHeaderValue("Key");
        TableColumn c2 = this.myTable.getColumnModel().getColumn(2);
        c2.setCellRenderer(r);
        c2.setHeaderValue("Value");
        c2.setCellEditor(new MyEditor());
        this.myTable.setStriped(true);
        this.myDescriptionLabel = new JTextArea(3, 50);
        this.myDescriptionLabel.setMargin((Insets)JBUI.insets((int)2));
        this.myDescriptionLabel.setWrapStyleWord(true);
        this.myDescriptionLabel.setLineWrap(true);
        this.myDescriptionLabel.setEditable(false);
        JScrollPane label2 = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionLabel);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)label2, "Center");
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Description", (boolean)false));
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable), "Center");
        this.myContent.add((Component)descriptionPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selected = RegistryUi.this.myTable.getSelectedRow();
                if (selected != -1) {
                    RegistryValue value = RegistryUi.this.myModel.getRegistryValue(selected);
                    String desc = value.getDescription();
                    if (value.isRestartRequired()) {
                        String required = " Requires IDE Restart.";
                        desc = desc.endsWith(".") ? desc + required : desc + "." + required;
                    }
                    RegistryUi.this.myDescriptionLabel.setText(desc);
                } else {
                    RegistryUi.this.myDescriptionLabel.setText(null);
                }
            }
        });
        this.myRestoreDefaultsAction = new RestoreDefaultsAction();
        DefaultActionGroup tbGroup = new DefaultActionGroup();
        tbGroup.add((AnAction)new EditAction());
        tbGroup.add((AnAction)new RevertAction());
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("Registry", (ActionGroup)tbGroup, true);
        tb.setTargetComponent((JComponent)this.myTable);
        this.myContent.add((Component)tb.getComponent(), "North");
        final TableSpeedSearch search2 = new TableSpeedSearch((JTable)this.myTable);
        search2.setComparator(new SpeedSearchComparator(false));
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                RegistryValue rv;
                int row2;
                if (e.getKeyCode() == 32 && (row2 = RegistryUi.this.myTable.getSelectedRow()) != -1 && (rv = RegistryUi.this.myModel.getRegistryValue(row2)).isBoolean()) {
                    rv.setValue(!rv.asBoolean());
                    RegistryUi.keyChanged(rv.getKey());
                    for (int i : new int[]{0, 1, 2}) {
                        RegistryUi.this.myModel.fireTableCellUpdated(row2, i);
                    }
                    RegistryUi.this.invalidateActions();
                    if (search2.isPopupActive()) {
                        search2.hidePopup();
                    }
                }
            }
        });
    }

    private void startEditingAtSelection() {
        this.myTable.editCellAt(this.myTable.getSelectedRow(), 2);
        if (this.myTable.isEditing()) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTable.getEditorComponent(), true));
        }
    }

    private static List<String> getRecent() {
        String value = PropertiesComponent.getInstance().getValue(RECENT_PROPERTIES_KEY);
        return StringUtil.isEmpty((String)value) ? new ArrayList(0) : StringUtil.split((String)value, (String)"=");
    }

    private static void keyChanged(String key) {
        List<String> recent = RegistryUi.getRecent();
        recent.remove(key);
        recent.add(0, key);
        PropertiesComponent.getInstance().setValue(RECENT_PROPERTIES_KEY, StringUtil.join(recent, (String)"="), "");
    }

    public boolean show() {
        DialogWrapper dialog2 = new DialogWrapper(true){
            private AbstractAction myCloseAction;
            {
                this.setTitle("Registry");
                this.setModal(true);
                this.init();
                RegistryUi.this.invalidateActions();
            }

            @Nullable
            protected JComponent createNorthPanel() {
                if (!ApplicationManager.getApplication().isInternal()) {
                    JLabel warningLabel = new JLabel(XmlStringUtil.wrapInHtml((CharSequence)("<b>Changing these values may cause unwanted behavior of " + ApplicationNamesInfo.getInstance().getFullProductName() + ". Please do not change these unless you have been asked.</b>")));
                    warningLabel.setIcon(UIUtil.getWarningIcon());
                    warningLabel.setForeground((Color)JBColor.RED);
                    return warningLabel;
                }
                return null;
            }

            protected JComponent createCenterPanel() {
                return RegistryUi.this.myContent;
            }

            protected void dispose() {
                super.dispose();
                Disposer.dispose((Disposable)RegistryUi.this);
            }

            protected String getDimensionServiceKey() {
                return "Registry";
            }

            public JComponent getPreferredFocusedComponent() {
                return RegistryUi.this.myTable;
            }

            @NotNull
            protected Action[] createActions() {
                return new Action[]{RegistryUi.this.myRestoreDefaultsAction, this.myCloseAction};
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myCloseAction = new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        RegistryUi.this.processClose();
                        this.doOKAction();
                    }
                };
                this.myCloseAction.putValue("DefaultAction", true);
            }

            public void doCancelAction() {
                TableCellEditor cellEditor = RegistryUi.this.myTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                RegistryUi.this.processClose();
                super.doCancelAction();
            }
        };
        return dialog2.showAndGet();
    }

    private void processClose() {
        if (Registry.getInstance().isRestartNeeded()) {
            String action;
            ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
            String message = "You need to restart " + ApplicationNamesInfo.getInstance().getFullProductName() + " for the changes to take effect";
            int r = Messages.showOkCancelDialog((Component)this.myContent, (String)message, (String)"Restart Required", (String)((action = app.isRestartCapable() ? "Restart" : "Shutdown") + " Now"), (String)(action + " Later"), (Icon)Messages.getQuestionIcon());
            if (r == 0) {
                ApplicationManager.getApplication().invokeLater(() -> app.restart(true), ModalityState.NON_MODAL);
            }
        }
    }

    private void restoreDefaults() {
        String message = "Are you sure you want to revert registry settings to default values?";
        int r = Messages.showYesNoDialog((Component)this.myContent, (String)message, (String)"Revert To Defaults", (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            Registry.getInstance().restoreDefaults();
            this.myModel.fireChanged();
            this.invalidateActions();
        }
    }

    private void invalidateActions() {
        this.myRestoreDefaultsAction.setEnabled(!Registry.getInstance().isInDefaultState());
    }

    public void dispose() {
    }

    private static Icon createColoredIcon(Color color) {
        Icon icon = icons_cache.get(color);
        if (icon != null) {
            return icon;
        }
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        g.dispose();
        icon = new ImageIcon(image);
        icons_cache.put(color, icon);
        return icon;
    }

    private class RestoreDefaultsAction
    extends AbstractAction {
        RestoreDefaultsAction() {
            super("Restore Defaults");
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            RegistryUi.this.restoreDefaults();
        }
    }

    private class MyEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JTextField myField = new JTextField();
        private final JCheckBox myCheckBox = new JCheckBox();
        private RegistryValue myValue;

        private MyEditor() {
        }

        @Override
        @Nullable
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
            this.myValue = ((MyTableModel)table.getModel()).getRegistryValue(row2);
            if (this.myValue.asColor(null) != null) {
                Color color = ColorChooser.chooseColor((Component)table, (String)"Choose Color", (Color)this.myValue.asColor(Color.WHITE));
                if (color != null) {
                    this.myValue.setValue(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                    RegistryUi.keyChanged(this.myValue.getKey());
                }
                return null;
            }
            if (this.myValue.isBoolean()) {
                this.myCheckBox.setSelected(this.myValue.asBoolean());
                this.myCheckBox.setBackground(table.getBackground());
                return this.myCheckBox;
            }
            this.myField.setText(this.myValue.asString());
            this.myField.setBorder(null);
            this.myField.selectAll();
            return this.myField;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.myValue != null) {
                if (this.myValue.isBoolean()) {
                    this.myValue.setValue(this.myCheckBox.isSelected());
                } else {
                    this.myValue.setValue(this.myField.getText().trim());
                }
                RegistryUi.keyChanged(this.myValue.getKey());
            }
            RegistryUi.this.invalidateActions();
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final SimpleColoredComponent myComponent = new SimpleColoredComponent();

        private MyRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            Color bg;
            RegistryValue v = ((MyTableModel)table.getModel()).getRegistryValue(row2);
            Color color = bg = isSelected ? table.getSelectionBackground() : table.getBackground();
            if (v != null) {
                switch (column) {
                    case 0: {
                        this.myLabel.setText(null);
                        if (v.isRestartRequired()) {
                            this.myLabel.setIcon(RESTART_ICON);
                            this.myLabel.setToolTipText(RegistryUi.REQUIRES_IDE_RESTART);
                        } else {
                            this.myLabel.setIcon(null);
                            this.myLabel.setToolTipText(null);
                        }
                        this.myLabel.setHorizontalAlignment(0);
                        break;
                    }
                    case 1: {
                        this.myComponent.clear();
                        this.myComponent.append(v.getKey(), MyRenderer.getAttributes(v, isSelected));
                        this.myComponent.setBackground(bg);
                        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this.myComponent, (boolean)true, (boolean)hasFocus);
                        return this.myComponent;
                    }
                    case 2: {
                        if (v.asColor(null) != null) {
                            this.myLabel.setText(null);
                            this.myLabel.setToolTipText(v.asString());
                            this.myLabel.setIcon(RegistryUi.createColoredIcon(v.asColor(null)));
                            this.myLabel.setHorizontalAlignment(2);
                            break;
                        }
                        if (v.isBoolean()) {
                            JCheckBox box = new JCheckBox();
                            box.setSelected(v.asBoolean());
                            box.setBackground(bg);
                            return box;
                        }
                        this.myComponent.clear();
                        this.myComponent.setBackground(bg);
                        this.myComponent.append(v.asString(), MyRenderer.getAttributes(v, isSelected));
                        if (v.isChangedFromDefault()) {
                            this.myComponent.append(" [" + Registry.getInstance().getBundleValue(v.getKey(), false) + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                        return this.myComponent;
                    }
                }
                this.myLabel.setOpaque(true);
                this.myLabel.setBackground(bg);
            }
            return this.myLabel;
        }

        @NotNull
        private static SimpleTextAttributes getAttributes(RegistryValue value, boolean isSelected) {
            boolean changedFromDefault = value.isChangedFromDefault();
            if (isSelected) {
                return new SimpleTextAttributes(changedFromDefault ? 1 : 0, UIUtil.getListSelectionForeground((boolean)true));
            }
            if (changedFromDefault) {
                return new SimpleTextAttributes(1, (Color)JBColor.blue);
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private final List<RegistryValue> myAll = Registry.getAll();

        private MyTableModel() {
            this.myAll.addAll(ContainerUtil.map((Collection)Experiments.EP_NAME.getExtensionList(), ExperimentalFeatureRegistryValueWrapper::new));
            List recent = RegistryUi.getRecent();
            Collections.sort(this.myAll, (o1, o2) -> {
                boolean c2;
                String key1 = o1.getKey();
                boolean changed1 = o1.isChangedFromDefault();
                boolean changed2 = o2.isChangedFromDefault();
                if (changed1 && !changed2) {
                    return -1;
                }
                if (!changed1 && changed2) {
                    return 1;
                }
                String key2 = o2.getKey();
                int i1 = recent.indexOf(key1);
                int i2 = recent.indexOf(key2);
                boolean c1 = i1 != -1;
                boolean bl = c2 = i2 != -1;
                if (c1 && !c2) {
                    return -1;
                }
                if (!c1 && c2) {
                    return 1;
                }
                if (c1 && c2) {
                    return i1 - i2;
                }
                return key1.compareToIgnoreCase(key2);
            });
        }

        public void fireChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myAll.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RegistryValue value = this.getRegistryValue(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return value.getKey();
                }
                case 2: {
                    return value.asString();
                }
            }
            return value;
        }

        private RegistryValue getRegistryValue(int rowIndex) {
            return this.myAll.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }

    private class EditAction
    extends AnAction {
        private EditAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditSource"), (JComponent)RegistryUi.this.myTable, (Disposable)RegistryUi.this);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText("Edit");
            e.getPresentation().setIcon(AllIcons.Actions.EditSource);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RegistryUi.this.startEditingAtSelection();
        }
    }

    private class RevertAction
    extends AnAction {
        private RevertAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditorDelete"), (JComponent)RegistryUi.this.myTable, (Disposable)RegistryUi.this);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText("Revert to Default");
            e.getPresentation().setIcon(AllIcons.General.Reset);
            if (e.getPresentation().isEnabled()) {
                RegistryValue rv = RegistryUi.this.myModel.getRegistryValue(RegistryUi.this.myTable.getSelectedRow());
                e.getPresentation().setEnabled(rv.isChangedFromDefault());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RegistryValue rv = RegistryUi.this.myModel.getRegistryValue(RegistryUi.this.myTable.getSelectedRow());
            rv.resetToDefault();
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 0);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 1);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 2);
            RegistryUi.this.invalidateActions();
        }
    }
}

