/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class FilePathImpl
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public FilePathImpl(@NotNull String path, boolean isDirectory) {
        this.myPath = FileUtil.toCanonicalPath((String)path);
        this.myIsDirectory = isDirectory;
    }

    @Deprecated
    public FilePathImpl(@NotNull VirtualFile file2) {
        this(file2.getPath(), file2.isDirectory());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePathImpl path = (FilePathImpl)o;
        if (this.myIsDirectory != path.myIsDirectory) {
            return false;
        }
        return FileUtil.PATH_HASHING_STRATEGY.equals((Object)this.myPath, (Object)path.myPath);
    }

    public int hashCode() {
        int result2 = FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }

    public void refresh() {
    }

    public void hardRefresh() {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new FilePathImpl(parent, true);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myPath);
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @NotNull
    public String getName() {
        return PathUtil.getFileName((String)this.myPath);
    }

    @NotNull
    public String getPresentableUrl() {
        return FileUtil.toSystemDependentName((String)this.myPath);
    }

    @Nullable
    public Document getDocument() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || file2.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    @NotNull
    public Charset getCharset() {
        return this.getCharset(null);
    }

    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file2 = this.getVirtualFile();
        String path = this.myPath;
        while (!(file2 != null && file2.isValid() || path.isEmpty())) {
            path = PathUtil.getParentPath((String)path);
            file2 = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (file2 != null) {
            return file2.getCharset();
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        return e.getDefaultCharset();
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile file2 = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        return file2 != null ? manager.getFileTypeByFile(file2) : manager.getFileTypeByFileName(this.getName());
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    public boolean isNonLocal() {
        return false;
    }
}

