/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,H\u0002J\b\u0010-\u001a\u00020*H\u0002J\b\u0010.\u001a\u00020*H\u0016J\u0016\u0010/\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110,H&J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00110,2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110,H&J\u000f\u00101\u001a\u0004\u0018\u00010*H\u0002\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020(H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020(H\u0002J\b\u00107\u001a\u000205H\u0002J\b\u00108\u001a\u000205H\u0002J\b\u00109\u001a\u00020\nH&J\b\u0010:\u001a\u000205H\u0002J\b\u0010;\u001a\u00020\nH&J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110&H\u0016J\b\u0010=\u001a\u00020*H\u0002J\b\u0010>\u001a\u00020*H&J\u0016\u0010?\u001a\u00020*2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110,H\u0002J\b\u0010A\u001a\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0012\u0010\u0014\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0012\u0010\u0016\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u0016\u0010#\u001a\n \u001e*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "NOTIFICATION_LOCK", "Ljava/lang/Object;", "askedBeforeProperty", "", "getAskedBeforeProperty", "()Ljava/lang/String;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "forAllProjectsActionText", "getForAllProjectsActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "notification", "Lcom/intellij/notification/Notification;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectProperties", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "getProjectProperties", "()Lcom/intellij/ide/util/PropertiesComponent;", "showActionText", "getShowActionText", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "acquireValidFiles", "", "addForCurrentProjectAction", "Lcom/intellij/notification/NotificationAction;", "addNewFiles", "", "filesToAdd", "", "clearFiles", "dispose", "doActionOnChosenFiles", "doFilterFiles", "expireNotification", "()Lkotlin/Unit;", "forAllProjectsAction", "isFilesEmpty", "", "muteAction", "needDoForCurrentProject", "notAskedBefore", "notificationMessage", "notificationNotPresent", "notificationTitle", "processFiles", "proposeToProcessFiles", "rememberForAllProjects", "removeFiles", "filesToRemove", "showAction", "intellij.platform.vcs.impl"})
public abstract class FilesProcessorWithNotificationImpl
implements FilesProcessor {
    private final VcsNotifier vcsNotifier;
    private final PropertiesComponent projectProperties;
    private final Set<VirtualFile> files;
    private final Object NOTIFICATION_LOCK;
    private Notification notification;
    @NotNull
    private final Project project;

    protected final PropertiesComponent getProjectProperties() {
        return this.projectProperties;
    }

    @NotNull
    public abstract String getAskedBeforeProperty();

    @NotNull
    public abstract String getDoForCurrentProjectProperty();

    @NotNull
    public abstract String getShowActionText();

    @NotNull
    public abstract String getForCurrentProjectActionText();

    @Nullable
    public abstract String getForAllProjectsActionText();

    @NotNull
    public abstract String getMuteActionText();

    @NotNull
    public abstract String notificationTitle();

    @NotNull
    public abstract String notificationMessage();

    public abstract void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> var1);

    @NotNull
    public abstract Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> var1);

    public abstract void rememberForAllProjects();

    @NotNull
    public List<VirtualFile> processFiles(@NotNull List<? extends VirtualFile> files2) {
        Collection<VirtualFile> filteredFiles = this.doFilterFiles((Collection<? extends VirtualFile>)files2);
        if (filteredFiles.isEmpty()) {
            return files2;
        }
        this.addNewFiles(filteredFiles);
        if (this.needDoForCurrentProject()) {
            this.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.acquireValidFiles());
            this.clearFiles();
        } else {
            this.proposeToProcessFiles();
        }
        return CollectionsKt.minus((Iterable)files2, (Iterable)filteredFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void proposeToProcessFiles() {
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            if (this.notAskedBefore() && this.notificationNotPresent()) {
                void $receiver$iv;
                Object $receiver = object2 = CollectionsKt.mutableListOf((Object[])new NotificationAction[]{this.showAction(), this.addForCurrentProjectAction()});
                boolean bl2 = false;
                if (this.getForAllProjectsActionText() != null) {
                    $receiver.add(this.forAllProjectsAction());
                }
                $receiver.add(this.muteAction());
                Object notificationActions = object2;
                object2 = (Collection)notificationActions;
                String string = this.notificationMessage();
                String string2 = this.notificationTitle();
                boolean bl3 = true;
                VcsNotifier vcsNotifier = this.vcsNotifier;
                FilesProcessorWithNotificationImpl filesProcessorWithNotificationImpl = this;
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v0;
                NotificationAction[] notificationActionArray = thisCollection$iv.toArray(new NotificationAction[0]);
                if (notificationActionArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                NotificationAction[] notificationActionArray2 = notificationActionArray;
                filesProcessorWithNotificationImpl.notification = vcsNotifier.notifyMinorInfo(bl3, string2, string, Arrays.copyOf(notificationActionArray2, notificationActionArray2.length));
            }
            object2 = Unit.INSTANCE;
        }
    }

    private final synchronized void removeFiles(Collection<? extends VirtualFile> filesToRemove) {
        this.files.removeAll(filesToRemove);
    }

    private final synchronized boolean isFilesEmpty() {
        return this.files.isEmpty();
    }

    private final synchronized void addNewFiles(Collection<? extends VirtualFile> filesToAdd) {
        this.files.addAll(filesToAdd);
    }

    private final synchronized List<VirtualFile> acquireValidFiles() {
        CollectionsKt.removeAll((Iterable)this.files, (Function1)acquireValidFiles.1.INSTANCE);
        return CollectionsKt.toList((Iterable)this.files);
    }

    private final synchronized void clearFiles() {
        this.files.clear();
    }

    public void dispose() {
        this.clearFiles();
    }

    private final NotificationAction showAction() {
        return NotificationAction.createSimple((String)this.getShowActionText(), (Runnable)new Runnable(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void run() {
                List allFiles = FilesProcessorWithNotificationImpl.access$acquireValidFiles(this.this$0);
                Object object = allFiles;
                if (!object.isEmpty()) {
                    Object $receiver = object = SelectFilesDialog.init(this.this$0.getProject(), allFiles, null, null, true, true, CommonBundle.getAddButtonText(), CommonBundle.getCancelButtonText());
                    boolean bl = false;
                    ((SelectFilesDialog)((Object)$receiver)).setSelectedFiles(allFiles);
                    if ($receiver.showAndGet()) {
                        Collection<VirtualFile> userSelectedFiles = ((SelectFilesDialog)((Object)$receiver)).getSelectedFiles();
                        this.this$0.doActionOnChosenFiles(userSelectedFiles);
                        FilesProcessorWithNotificationImpl.access$removeFiles(this.this$0, userSelectedFiles);
                        if (FilesProcessorWithNotificationImpl.access$isFilesEmpty(this.this$0)) {
                            FilesProcessorWithNotificationImpl.access$expireNotification(this.this$0);
                        }
                    }
                }
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction addForCurrentProjectAction() {
        return NotificationAction.create((String)this.getForCurrentProjectActionText(), (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification $noName_1) {
                this.this$0.doActionOnChosenFiles(FilesProcessorWithNotificationImpl.access$acquireValidFiles(this.this$0));
                this.this$0.getProjectProperties().setValue(this.this$0.getDoForCurrentProjectProperty(), true);
                this.this$0.getProjectProperties().setValue(this.this$0.getAskedBeforeProperty(), true);
                FilesProcessorWithNotificationImpl.access$expireNotification(this.this$0);
                FilesProcessorWithNotificationImpl.access$clearFiles(this.this$0);
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction forAllProjectsAction() {
        String string = this.getForAllProjectsActionText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return NotificationAction.create((String)string, (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification $noName_1) {
                this.this$0.doActionOnChosenFiles(FilesProcessorWithNotificationImpl.access$acquireValidFiles(this.this$0));
                this.this$0.getProjectProperties().setValue(this.this$0.getDoForCurrentProjectProperty(), true);
                this.this$0.getProjectProperties().setValue(this.this$0.getAskedBeforeProperty(), true);
                this.this$0.rememberForAllProjects();
                FilesProcessorWithNotificationImpl.access$expireNotification(this.this$0);
                FilesProcessorWithNotificationImpl.access$clearFiles(this.this$0);
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    private final NotificationAction muteAction() {
        return NotificationAction.create((String)this.getMuteActionText(), (BiConsumer)new BiConsumer<AnActionEvent, Notification>(this){
            final /* synthetic */ FilesProcessorWithNotificationImpl this$0;

            public final void accept(AnActionEvent $noName_0, Notification notification) {
                this.this$0.getProjectProperties().setValue(this.this$0.getDoForCurrentProjectProperty(), false);
                this.this$0.getProjectProperties().setValue(this.this$0.getAskedBeforeProperty(), true);
                notification.expire();
            }
            {
                this.this$0 = filesProcessorWithNotificationImpl;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notificationNotPresent() {
        boolean bl;
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            boolean bl2 = false;
            Notification notification = this.notification;
            bl = notification != null ? notification.isExpired() : true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit expireNotification() {
        Unit unit;
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            Unit unit2;
            boolean bl = false;
            Notification notification = this.notification;
            if (notification != null) {
                notification.expire();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    private final boolean notAskedBefore() {
        return !this.projectProperties.getBoolean(this.getAskedBeforeProperty(), false);
    }

    private final boolean needDoForCurrentProject() {
        return this.projectProperties.getBoolean(this.getDoForCurrentProjectProperty(), false);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public FilesProcessorWithNotificationImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Set set2;
        this.project = project;
        this.vcsNotifier = VcsNotifier.getInstance(this.project);
        this.projectProperties = PropertiesComponent.getInstance((Project)this.project);
        FilesProcessorWithNotificationImpl filesProcessorWithNotificationImpl = this;
        filesProcessorWithNotificationImpl.files = set2 = (Set)new LinkedHashSet();
        this.NOTIFICATION_LOCK = new Object();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
    }

    public static final /* synthetic */ List access$acquireValidFiles(FilesProcessorWithNotificationImpl $this) {
        return $this.acquireValidFiles();
    }

    public static final /* synthetic */ void access$removeFiles(FilesProcessorWithNotificationImpl $this, Collection filesToRemove) {
        $this.removeFiles(filesToRemove);
    }

    public static final /* synthetic */ boolean access$isFilesEmpty(FilesProcessorWithNotificationImpl $this) {
        return $this.isFilesEmpty();
    }

    public static final /* synthetic */ Unit access$expireNotification(FilesProcessorWithNotificationImpl $this) {
        return $this.expireNotification();
    }

    public static final /* synthetic */ void access$clearFiles(FilesProcessorWithNotificationImpl $this) {
        $this.clearFiles();
    }
}

