/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OpenProjectSetProcessor
extends ProjectSetProcessor {
    public String getId() {
        return "project";
    }

    public void processEntries(@NotNull List<? extends Pair<String, String>> entries2, @NotNull ProjectSetProcessor.Context context, @NotNull Runnable runNext) {
        Project project;
        String root = context.directory == null || context.directoryName == null ? null : context.directory.getPath() + "/" + context.directoryName;
        for (Pair<String, String> pair : entries2) {
            if (!"project".equals(pair.getFirst())) continue;
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                String path = root == null ? (String)entry.getSecond() : root + "/" + (String)entry.getSecond();
                context.project = ProjectUtil.openProject(path, null, true);
            });
            if (context.project != null) {
                runNext.run();
            }
            return;
        }
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
        if (dir != null && (project = PlatformProjectOpenProcessor.getInstance().doOpenProject(dir, null, false)) != null) {
            runNext.run();
        }
    }
}

