/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroup.toolWindowGroup((String)"Vcs Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = new NotificationGroup("Vcs Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    public static final NotificationGroup STANDARD_NOTIFICATION = new NotificationGroup("Vcs Notifications", NotificationDisplayType.BALLOON, true);
    public static final NotificationGroup SILENT_NOTIFICATION = new NotificationGroup("Vcs Silent Notifications", NotificationDisplayType.NONE, true);
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project) {
        return (VcsNotifier)ServiceManager.getService((Project)project, VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = title;
            title = "";
        }
        return notificationGroup.createNotification(title, message, type, listener2);
    }

    @NotNull
    public Notification notify(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        Notification notification = VcsNotifier.createNotification(notificationGroup, title, message, type, listener2);
        return this.notify(notification);
    }

    @NotNull
    public Notification notify(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        Notification notification = VcsNotifier.createNotification(notificationGroup, title, message, type, null);
        for (NotificationAction action : actions) {
            notification.addAction((AnAction)action);
        }
        return this.notify(notification);
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        notification.notify(this.myProject);
        return notification;
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message) {
        return this.notifyError(title, message, (NotificationListener)null);
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message, NotificationAction ... actions) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.ERROR, actions);
    }

    @NotNull
    public Notification notifyWeakError(@NotNull String message) {
        return this.notify(NOTIFICATION_GROUP_ID, "", message, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String message) {
        return this.notifySuccess("", message);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message) {
        return this.notifySuccess(title, message, null);
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String message) {
        return this.notifyInfo("", message);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message) {
        return this.notifyInfo(title, message, null);
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message) {
        return this.notifyMinorWarning(title, message, null);
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message) {
        return this.notifyWarning(title, message, null);
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message) {
        return this.notifyMinorInfo(title, message, (NotificationListener)null);
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        return this.notify(STANDARD_NOTIFICATION, title, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message, NotificationAction ... actions) {
        return this.notify(STANDARD_NOTIFICATION, title, message, NotificationType.INFORMATION, actions);
    }

    @NotNull
    public Notification notifyMinorInfo(boolean sticky, @NotNull String title, @NotNull String message, NotificationAction ... actions) {
        return this.notify(sticky ? IMPORTANT_ERROR_NOTIFICATION : STANDARD_NOTIFICATION, title, message, NotificationType.INFORMATION, actions);
    }

    public Notification logInfo(@NotNull String title, @NotNull String message) {
        return this.notify(SILENT_NOTIFICATION, title, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    public void showNotificationAndHideExisting(@NotNull Notification notificationToShow, @NotNull Class<? extends Notification> klass) {
        this.hideAllNotificationsByType(klass);
        notificationToShow.notify(this.myProject);
    }

    public void hideAllNotificationsByType(@NotNull Class<? extends Notification> klass) {
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        for (Notification notification : notificationsManager.getNotificationsOfType(klass, this.myProject)) {
            notification.expire();
        }
    }
}

