/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImpl;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    protected final ChangeListManager myChangeListManager;
    private final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final List<VirtualFile> myAddedFiles = new ArrayList<VirtualFile>();
    private final Map<VirtualFile, VirtualFile> myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
    protected final List<VcsException> myExceptions = new SmartList();
    protected final List<FilePath> myDeletedFiles = new ArrayList<FilePath>();
    protected final List<FilePath> myDeletedWithoutConfirmFiles = new ArrayList<FilePath>();
    protected final List<MovedFileInfo> myMovedFiles = new ArrayList<MovedFileInfo>();
    private final FilesProcessor myProjectConfigurationFilesProcessor;
    protected final FilesProcessor myExternalFilesProcessor;

    protected VcsVFSListener(@NotNull Project project, @NotNull AbstractVcs vcs) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)new MyCommandAdapter());
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
        this.myProjectConfigurationFilesProcessor = this.createProjectConfigurationFilesProcessor();
        this.myExternalFilesProcessor = this.createExternalFilesProcessor();
    }

    public void dispose() {
    }

    protected boolean isEventIgnored(@NotNull VirtualFileEvent event) {
        if (event.isFromRefresh()) {
            return true;
        }
        return !this.isUnderMyVcs(event.getFile());
    }

    private boolean isUnderMyVcs(@NotNull VirtualFile file2) {
        return this.myVcsManager.getVcsFor(file2) == this.myVcs && this.myVcsManager.isFileInContent(file2) && !this.myChangeListManager.isIgnoredFile(file2);
    }

    protected void executeAdd() {
        List<VirtualFile> addedFiles = this.acquireAddedFiles();
        LOG.debug("executeAdd. addedFiles: ", new Object[]{addedFiles});
        addedFiles.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isAdditionIgnored(arg_0));
        Map<VirtualFile, VirtualFile> copyFromMap = this.acquireCopiedFiles();
        if (!addedFiles.isEmpty()) {
            this.executeAdd(addedFiles, copyFromMap);
        }
    }

    @NotNull
    private Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
        HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
        this.myCopyFromMap.clear();
        return copyFromMap;
    }

    @NotNull
    private List<VirtualFile> acquireAddedFiles() {
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>(this.myAddedFiles);
        this.myAddedFiles.clear();
        return addedFiles;
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        LOG.debug("executeAdd. add-option: ", new Object[]{this.myAddOption.getValue(), ", files to add: ", addedFiles});
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        addedFiles = this.myProjectConfigurationFilesProcessor.processFiles(addedFiles);
        if (this.myAddOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            this.performAdding(addedFiles, copyFromMap);
        } else {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            Collection filesToProcess = helper.selectFilesToProcess(addedFiles, this.getAddTitle(), null, this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), this.myAddOption);
            if (filesToProcess != null) {
                this.performAdding(new ArrayList<VirtualFile>(filesToProcess), copyFromMap);
            }
        }
    }

    protected void executeAddWithoutIgnores(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap, @NotNull ExecuteAddCallback executeAddCallback) {
        executeAddCallback.executeAdd(addedFiles, copyFromMap);
    }

    protected void saveUnsavedVcsIgnoreFiles() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Set ignoreFileNames = VcsUtil.getVcsIgnoreFileNames((Project)this.myProject);
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file2 = fileDocumentManager.getFile(document);
            if (file2 == null || !ignoreFileNames.contains(file2.getName())) continue;
            fileDocumentManager.saveDocument(document);
        }
    }

    private void addFileToDelete(@NotNull VirtualFile file2) {
        if (file2.isDirectory() && file2 instanceof NewVirtualFile && !this.isDirectoryVersioningSupported()) {
            for (VirtualFile child2 : ((NewVirtualFile)file2).getCachedChildren()) {
                this.addFileToDelete(child2);
            }
        } else {
            VcsDeleteType type = this.needConfirmDeletion(file2);
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(file2.getPath()), file2.isDirectory());
            if (type == VcsDeleteType.CONFIRM) {
                this.myDeletedFiles.add(filePath);
            } else if (type == VcsDeleteType.SILENT) {
                this.myDeletedWithoutConfirmFiles.add(filePath);
            }
        }
    }

    protected void executeDelete() {
        ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        filesToDelete.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isDeletionIgnored(arg_0));
        deletedFiles.removeIf(arg_0 -> ((VcsFileListenerContextHelper)this.myVcsFileListenerContextHelper).isDeletionIgnored(arg_0));
        if (deletedFiles.isEmpty() && filesToDelete.isEmpty()) {
            return;
        }
        if (this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            if (this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || deletedFiles.isEmpty()) {
                filesToDelete.addAll(deletedFiles);
            } else {
                Collection<FilePath> filePaths = this.selectFilePathsToDelete(deletedFiles);
                if (filePaths != null) {
                    filesToDelete.addAll(filePaths);
                }
            }
        }
        this.performDeletion(filesToDelete);
    }

    @Nullable
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
        return helper.selectFilePathsToProcess(deletedFiles, this.getDeleteTitle(), null, this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), this.myRemoveOption);
    }

    protected void beforeContentsChange(@NotNull VirtualFileEvent event, @NotNull VirtualFile file2) {
    }

    protected void fileAdded(@NotNull VirtualFileEvent event, @NotNull VirtualFile file2) {
        if (!(this.isEventIgnored(event) || !this.isDirectoryVersioningSupported() && file2.isDirectory())) {
            LOG.debug("Adding [", new Object[]{file2, "] to added files"});
            this.myAddedFiles.add(file2);
        }
    }

    private void addFileToMove(@NotNull VirtualFile file2, @NotNull String newParentPath, @NotNull String newName) {
        if (file2.isDirectory() && !file2.is(VFileProperty.SYMLINK) && !this.isDirectoryVersioningSupported()) {
            VirtualFile[] children2 = file2.getChildren();
            if (children2 != null) {
                for (VirtualFile child2 : children2) {
                    this.addFileToMove(child2, newParentPath + "/" + newName, child2.getName());
                }
            }
        } else {
            this.processMovedFile(file2, newParentPath, newName);
        }
    }

    protected boolean filterOutUnknownFiles() {
        return true;
    }

    protected void processMovedFile(@NotNull VirtualFile file2, @NotNull String newParentPath, @NotNull String newName) {
        FileStatus status = ChangeListManager.getInstance((Project)this.myProject).getStatus(file2);
        LOG.debug("Checking moved file ", new Object[]{file2, "; status=", status});
        String newPath = newParentPath + "/" + newName;
        if (!(this.filterOutUnknownFiles() && status == FileStatus.UNKNOWN || status == FileStatus.IGNORED)) {
            MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> Comparing.equal((Object)((MovedFileInfo)info).myFile, (Object)file2));
            if (existingMovedFile != null) {
                LOG.debug("Reusing existing moved file [" + file2 + "] with new path [" + newPath + "]");
                existingMovedFile.myNewPath = newPath;
            } else {
                LOG.debug("Registered moved file ", new Object[]{file2});
                this.myMovedFiles.add(new MovedFileInfo(file2, newPath));
            }
        } else {
            this.myDeletedFiles.remove(VcsUtil.getFilePath((String)newPath));
        }
    }

    private void executeMoveRename() {
        ArrayList<MovedFileInfo> movedFiles = new ArrayList<MovedFileInfo>(this.myMovedFiles);
        LOG.debug("executeMoveRename " + movedFiles);
        this.myMovedFiles.clear();
        this.performMoveRename(movedFiles);
    }

    @NotNull
    protected VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file2) {
        return VcsDeleteType.CONFIRM;
    }

    @NotNull
    protected abstract String getAddTitle();

    @NotNull
    protected abstract String getSingleFileAddTitle();

    @NotNull
    protected abstract String getSingleFileAddPromptTemplate();

    protected abstract void performAdding(@NotNull Collection<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);

    @NotNull
    protected abstract String getDeleteTitle();

    protected abstract String getSingleFileDeleteTitle();

    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performDeletion(@NotNull List<FilePath> var1);

    protected abstract void performMoveRename(@NotNull List<MovedFileInfo> var1);

    protected abstract boolean isDirectoryVersioningSupported();

    private FilesProcessor createExternalFilesProcessor() {
        return new ExternallyAddedFilesProcessorImpl(this.myProject, this, this.myVcs, (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files2 -> {
            this.performAdding((Collection<VirtualFile>)files2, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private FilesProcessor createProjectConfigurationFilesProcessor() {
        return new ProjectConfigurationFilesProcessorImpl(this.myProject, this, this.myVcs.getDisplayName(), (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files2 -> {
            this.performAdding((Collection<VirtualFile>)files2, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private class MyCommandAdapter
    implements CommandListener {
        private int myCommandLevel;

        private MyCommandAdapter() {
        }

        public void commandStarted(@NotNull CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            ++this.myCommandLevel;
        }

        private void checkMovedAddedSourceBack() {
            if (VcsVFSListener.this.myAddedFiles.isEmpty() || VcsVFSListener.this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(VcsVFSListener.this.myAddedFiles.size());
            for (VirtualFile file2 : VcsVFSListener.this.myAddedFiles) {
                addedPaths.put(file2.getPath(), file2);
            }
            Iterator<MovedFileInfo> iterator = VcsVFSListener.this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                if (!addedPaths.containsKey(movedFile.myOldPath)) continue;
                iterator.remove();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                VcsVFSListener.this.myAddedFiles.remove(oldAdded);
                VcsVFSListener.this.myAddedFiles.add(movedFile.myFile);
                VcsVFSListener.this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        private void doNotDeleteAddedCopiedOrMovedFiles() {
            ArrayList<String> copiedAddedMoved = new ArrayList<String>();
            for (VirtualFile file2 : VcsVFSListener.this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file2.getPath());
            }
            for (VirtualFile file2 : VcsVFSListener.this.myAddedFiles) {
                copiedAddedMoved.add(file2.getPath());
            }
            for (MovedFileInfo movedFileInfo : VcsVFSListener.this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            VcsVFSListener.this.myDeletedFiles.removeIf(path -> copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)path.getPath())));
            VcsVFSListener.this.myDeletedWithoutConfirmFiles.removeIf(path -> copiedAddedMoved.contains(FileUtil.toSystemIndependentName((String)path.getPath())));
        }

        public void commandFinished(@NotNull CommandEvent event) {
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            --this.myCommandLevel;
            if (!(this.myCommandLevel != 0 || VcsVFSListener.this.myAddedFiles.isEmpty() && VcsVFSListener.this.myDeletedFiles.isEmpty() && VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty() && VcsVFSListener.this.myMovedFiles.isEmpty())) {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
                if (!VcsVFSListener.this.myAddedFiles.isEmpty()) {
                    VcsVFSListener.this.executeAdd();
                    VcsVFSListener.this.myAddedFiles.clear();
                }
                if (!VcsVFSListener.this.myDeletedFiles.isEmpty() || !VcsVFSListener.this.myDeletedWithoutConfirmFiles.isEmpty()) {
                    VcsVFSListener.this.executeDelete();
                    VcsVFSListener.this.myDeletedFiles.clear();
                    VcsVFSListener.this.myDeletedWithoutConfirmFiles.clear();
                }
                if (!VcsVFSListener.this.myMovedFiles.isEmpty()) {
                    VcsVFSListener.this.executeMoveRename();
                    VcsVFSListener.this.myMovedFiles.clear();
                }
                if (!VcsVFSListener.this.myExceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)VcsVFSListener.this.myProject).showErrors(VcsVFSListener.this.myExceptions, VcsVFSListener.this.myVcs.getDisplayName() + " operations errors");
                }
            }
        }
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile file2 = event.getFile();
            LOG.debug("fileCreated: ", new Object[]{file2});
            VcsVFSListener.this.fileAdded(event, file2);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (VcsVFSListener.this.isEventIgnored((VirtualFileEvent)event) || VcsVFSListener.this.myChangeListManager.isIgnoredFile(event.getFile())) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance((Project)VcsVFSListener.this.myProject).getVcsFor(event.getOriginalFile());
            if (oldVcs == VcsVFSListener.this.myVcs) {
                VirtualFile parent = event.getFile().getParent();
                if (parent != null) {
                    VcsVFSListener.this.myAddedFiles.add(event.getFile());
                    VcsVFSListener.this.myCopyFromMap.put(event.getFile(), event.getOriginalFile());
                }
            } else {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            VirtualFile file2 = event.getFile();
            if (VcsVFSListener.this.isEventIgnored(event)) {
                return;
            }
            if (!VcsVFSListener.this.myChangeListManager.isIgnoredFile(file2)) {
                VcsVFSListener.this.addFileToDelete(file2);
                return;
            }
            if (event.getFile().isDirectory()) {
                LinkedList list2 = new LinkedList();
                VcsUtil.collectFiles((VirtualFile)file2, list2, (boolean)true, (boolean)VcsVFSListener.this.isDirectoryVersioningSupported());
                for (VirtualFile child2 : list2) {
                    if (VcsVFSListener.this.myChangeListManager.isIgnoredFile(child2)) continue;
                    VcsVFSListener.this.addFileToDelete(child2);
                }
            }
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (VcsVFSListener.this.isEventIgnored((VirtualFileEvent)event)) {
                return;
            }
            VirtualFile file2 = event.getFile();
            AbstractVcs newVcs = ProjectLevelVcsManager.getInstance((Project)VcsVFSListener.this.myProject).getVcsFor(event.getNewParent());
            LOG.debug("beforeFileMovement ", new Object[]{event, " into ", newVcs});
            if (newVcs == VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.addFileToMove(file2, event.getNewParent().getPath(), file2.getName());
            } else {
                VcsVFSListener.this.addFileToDelete(event.getFile());
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (VcsVFSListener.this.isEventIgnored((VirtualFileEvent)event)) {
                return;
            }
            AbstractVcs oldVcs = ProjectLevelVcsManager.getInstance((Project)VcsVFSListener.this.myProject).getVcsFor(event.getOldParent());
            if (oldVcs != VcsVFSListener.this.myVcs) {
                VcsVFSListener.this.myAddedFiles.add(event.getFile());
            }
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (!VcsVFSListener.this.isEventIgnored((VirtualFileEvent)event) && event.getPropertyName().equalsIgnoreCase("name")) {
                VirtualFile file2;
                VirtualFile parent;
                LOG.debug("before file rename ", new Object[]{event});
                String oldName = (String)event.getOldValue();
                String newName = (String)event.getNewValue();
                if (!Comparing.equal((String)oldName, (String)newName) && (parent = (file2 = event.getFile()).getParent()) != null) {
                    VcsVFSListener.this.addFileToMove(file2, parent.getPath(), newName);
                }
            }
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            VirtualFile file2 = event.getFile();
            assert (!file2.isDirectory());
            if (VcsVFSListener.this.isUnderMyVcs(file2)) {
                VcsVFSListener.this.beforeContentsChange(event, file2);
            }
        }
    }

    @FunctionalInterface
    protected static interface ExecuteAddCallback {
        public void executeAdd(@NotNull List<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);
    }

    protected static enum VcsDeleteType {
        SILENT,
        CONFIRM,
        IGNORE;

    }

    protected static class MovedFileInfo {
        @NotNull
        public final String myOldPath;
        @NotNull
        public String myNewPath;
        @NotNull
        private final VirtualFile myFile;

        MovedFileInfo(@NotNull VirtualFile file2, @NotNull String newPath) {
            this.myOldPath = file2.getPath();
            this.myNewPath = newPath;
            this.myFile = file2;
        }

        public String toString() {
            return String.format("MovedFileInfo{[%s] -> [%s]}", this.myOldPath, this.myNewPath);
        }
    }
}

