/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShowDiffAction
extends AbstractVcsAction {
    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext);
    }

    protected static void updateDiffAction(@NotNull Presentation presentation, @NotNull VcsContext vcsContext) {
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, true));
        presentation.setVisible(AbstractShowDiffAction.isVisible(vcsContext));
    }

    protected static boolean isVisible(@NotNull VcsContext vcsContext) {
        Project project = vcsContext.getProject();
        return project != null && AbstractShowDiffAction.hasDiffProviders(project);
    }

    private static boolean hasDiffProviders(@NotNull Project project) {
        return Stream.of(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()).map(AbstractVcs::getDiffProvider).anyMatch(Objects::nonNull);
    }

    protected static boolean isEnabled(@NotNull VcsContext vcsContext, boolean disableIfRunning) {
        Project project = vcsContext.getProject();
        if (project == null) {
            return false;
        }
        if (!AbstractShowDiffAction.isVisible(vcsContext)) {
            return false;
        }
        VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle((Stream)vcsContext.getSelectedFilesStream());
        if (file2 == null || file2.isDirectory()) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        if (disableIfRunning && BackgroundableActionLock.isLocked(project, new Object[]{VcsBackgroundableActions.COMPARE_WITH, filePath})) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project);
        if (vcs == null || vcs.getDiffProvider() == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath);
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        Project project = (Project)ObjectUtils.assertNotNull((Object)vcsContext.getProject());
        if (!ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not " + vcsContext.getActionName() + " now")) {
            VirtualFile file2 = vcsContext.getSelectedFiles()[0];
            AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)project));
            DiffProvider provider = (DiffProvider)ObjectUtils.assertNotNull((Object)vcs.getDiffProvider());
            Editor editor = vcsContext.getEditor();
            this.getExecutor(provider, file2, project, editor).showDiff();
        }
    }

    @NotNull
    protected abstract DiffActionExecutor getExecutor(@NotNull DiffProvider var1, @NotNull VirtualFile var2, @NotNull Project var3, @Nullable Editor var4);
}

