/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyRevisionNumberFromAnnotateAction
extends DumbAwareAction
implements UpToDateLineNumberListener {
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public CopyRevisionNumberFromAnnotateAction(FileAnnotation annotation) {
        super("Copy revision number");
        this.myAnnotation = annotation;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myLineNumber < 0) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(this.myLineNumber);
        if (revisionNumber != null) {
            String revision = revisionNumber.asString();
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(revision));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.myLineNumber >= 0 && this.myAnnotation.getLineRevisionNumber(this.myLineNumber) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }
}

