/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SwitchAnnotationSourceAction
extends AnAction
implements DumbAware {
    private static final String ourShowMerged = VcsBundle.message((String)"annotation.switch.to.merged.text", (Object[])new Object[0]);
    private static final String ourHideMerged = VcsBundle.message((String)"annotation.switch.to.original.text", (Object[])new Object[0]);
    private final AnnotationSourceSwitcher mySwitcher;
    private final List<Consumer<AnnotationSource>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShowMerged;

    SwitchAnnotationSourceAction(AnnotationSourceSwitcher switcher) {
        this.mySwitcher = switcher;
        this.myShowMerged = this.mySwitcher.getDefaultSource().showMerged();
    }

    public void addSourceSwitchListener(Consumer<AnnotationSource> listener2) {
        this.myListeners.add(listener2);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setText(this.myShowMerged ? ourHideMerged : ourShowMerged);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myShowMerged = !this.myShowMerged;
        AnnotationSource newSource = AnnotationSource.getInstance((boolean)this.myShowMerged);
        this.mySwitcher.switchTo(newSource);
        for (Consumer<AnnotationSource> listener2 : this.myListeners) {
            listener2.consume((Object)newSource);
        }
        AnnotateActionGroup.revalidateMarkupInAllEditors();
    }
}

