/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction
implements UpdateInBackground {
    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        Project project = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        boolean result2 = false;
        Project project = context.getProject();
        if (project != null) {
            Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
            if (pair.first != null && pair.second != null) {
                result2 = TabbedShowHistoryAction.isEnabled(project, (FilePath)pair.first, (VirtualFile)pair.second);
            }
        }
        return result2;
    }

    private static boolean isEnabled(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        boolean fileInVcs = AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)fileOrParent);
        if (!fileInVcs) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project);
        if (vcs == null) {
            return false;
        }
        return TabbedShowHistoryAction.canShowNewFileHistory(project, path) || TabbedShowHistoryAction.canShowOldFileHistory(vcs, path, fileOrParent);
    }

    private static boolean canShowOldFileHistory(@NotNull AbstractVcs vcs, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull FilePath path) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        return historyProvider != null && historyProvider.canShowFileHistory(project, path);
    }

    @NotNull
    private static Pair<FilePath, VirtualFile> getPathAndParentFile(@NotNull VcsContext context) {
        List selectedFiles = context.getSelectedFilesStream().limit(2L).collect(Collectors.toList());
        if (selectedFiles.size() > 0) {
            if (selectedFiles.size() != 1) {
                return Pair.empty();
            }
            VirtualFile file2 = (VirtualFile)selectedFiles.get(0);
            return Pair.create((Object)VcsUtil.getFilePath((VirtualFile)file2), (Object)file2);
        }
        File[] ioFiles = context.getSelectedIOFiles();
        if (ioFiles != null && ioFiles.length > 0) {
            for (File ioFile : ioFiles) {
                VirtualFile parent = TabbedShowHistoryAction.getParentVirtualFile(ioFile);
                if (parent == null) continue;
                return Pair.create((Object)VcsUtil.getFilePath((VirtualFile)parent, (String)ioFile.getName()), (Object)parent);
            }
        }
        return Pair.empty();
    }

    @Nullable
    private static VirtualFile getParentVirtualFile(@NotNull File ioFile) {
        File parentIoFile = ioFile.getParentFile();
        return parentIoFile != null ? LocalFileSystem.getInstance().findFileByIoFile(parentIoFile) : null;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        Project project = (Project)ObjectUtils.assertNotNull((Object)context.getProject());
        Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
        FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)pair.first);
        VirtualFile fileOrParent = (VirtualFile)ObjectUtils.assertNotNull((Object)pair.second);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project));
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, path)) {
            TabbedShowHistoryAction.showNewFileHistory(project, path);
        } else {
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull FilePath path) {
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, path, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path) {
        VcsHistoryProvider provider = (VcsHistoryProvider)ObjectUtils.assertNotNull((Object)vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path, vcs);
    }
}

