/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    @NotNull
    protected final DataContext myContext;
    protected final int myModifiers;
    @NotNull
    private final String myPlace;
    @Nullable
    private final String myActionName;

    public VcsContextWrapper(@NotNull DataContext context, int modifiers, @NotNull String place, @Nullable String actionName) {
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    @NotNull
    public String getPlace() {
        return this.myPlace;
    }

    @Nullable
    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        return new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    @Nullable
    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return this.getSelectedFilesStream().findFirst().orElse(null);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            return (VirtualFile[])Stream.of(fileArray).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (file2 != null && file2.isInLocalFileSystem()) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = file2;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        return virtualFileArray;
    }

    @NotNull
    public Stream<VirtualFile> getSelectedFilesStream() {
        Stream result2 = (Stream)VcsDataKeys.VIRTUAL_FILE_STREAM.getData(this.myContext);
        return result2 != null ? result2.filter(VirtualFile::isInLocalFileSystem) : super.getSelectedFilesStream();
    }

    @NotNull
    public List<VirtualFile> getSelectedUnversionedFiles() {
        Stream result2 = (Stream)ChangesListView.UNVERSIONED_FILES_DATA_KEY.getData(this.myContext);
        return result2 != null ? result2.collect(Collectors.toList()) : Collections.emptyList();
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    @Nullable
    public File getSelectedIOFile() {
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        return file2 != null ? file2 : (File)ArrayUtil.getFirstElement((Object[])((Object[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext)));
    }

    @Nullable
    public File[] getSelectedIOFiles() {
        File[] fileArray;
        Object[] files2 = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (!ArrayUtil.isEmpty((Object[])files2)) {
            return files2;
        }
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file2 != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file2;
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        return (FilePath[])this.getSelectedFilePathsStream().toArray(FilePath[]::new);
    }

    @NotNull
    public Stream<FilePath> getSelectedFilePathsStream() {
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        return UtilKt.concat((Stream[])new Stream[]{StreamEx.ofNullable((Object)path), UtilKt.stream((Object[])((Object[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext))), this.getSelectedFilesStream().map(VcsUtil::getFilePath), UtilKt.stream((Object[])this.getSelectedIOFiles()).map(VcsUtil::getFilePath)});
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        return (FilePath)ArrayUtil.getFirstElement((Object[])this.getSelectedFilePaths());
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }
}

