/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsQuickListContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsQuickListPopupAction
extends QuickSwitchSchemeAction
implements DumbAware {
    public VcsQuickListPopupAction() {
        this.myActionPlace = "ActionPlace.VcsQuickListPopupAction";
    }

    protected String getPopupTitle(@NotNull AnActionEvent e) {
        return VcsBundle.message((String)"vcs.quicklist.popup.title", (Object[])new Object[0]);
    }

    protected void fillActions(@Nullable Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (project == null) {
            return;
        }
        CustomActionsSchema schema = CustomActionsSchema.getInstance();
        group.add(schema.getCorrectedAction("Vcs.Operations.Popup"));
    }

    @NotNull
    private static Pair<SupportedVCS, AbstractVcs> getActiveVCS(@NotNull Project project, @NotNull DataContext dataContext) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs[] activeVcss = vcsManager.getAllActiveVcss();
        if (activeVcss.length == 0) {
            return new Pair((Object)SupportedVCS.NOT_IN_VCS, null);
        }
        if (activeVcss.length == 1) {
            return Pair.create((Object)((Object)SupportedVCS.VCS), (Object)activeVcss[0]);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        AbstractVcs vscForFile = file2 != null ? ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2) : null;
        return vscForFile != null ? Pair.create((Object)((Object)SupportedVCS.VCS), (Object)vscForFile) : Pair.create((Object)((Object)SupportedVCS.VCS), null);
    }

    public static class NonVcsAware
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            Pair pair = project == null ? Pair.empty() : VcsQuickListPopupAction.getActiveVCS(project, e.getDataContext());
            e.getPresentation().setVisible(pair.first == SupportedVCS.NOT_IN_VCS);
        }
    }

    public static class VcsAware
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Pair pair;
            Project project = e.getProject();
            DataContext dataContext = e.getDataContext();
            Pair pair2 = pair = project == null ? Pair.empty() : VcsQuickListPopupAction.getActiveVCS(project, dataContext);
            if (pair.first == SupportedVCS.VCS && pair.second != null) {
                AbstractVcs vcs = (AbstractVcs)pair.second;
                JBIterable providers = JBIterable.of((Object[])VcsQuickListContentProvider.EP_NAME.getExtensions());
                List replacingActions = (List)providers.filterMap(p -> p.replaceVcsActionsFor(vcs, dataContext) ? p.getVcsActions(project, vcs, dataContext) : null).first();
                e.getPresentation().setVisible(replacingActions == null);
            } else {
                e.getPresentation().setVisible(false);
            }
        }
    }

    public static final class VcsNameSeparator
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Pair pair;
            if (e == null) {
                return EMPTY_ARRAY;
            }
            Project project = e.getProject();
            Pair pair2 = pair = project == null ? Pair.empty() : VcsQuickListPopupAction.getActiveVCS(project, e.getDataContext());
            if (pair.first != SupportedVCS.VCS || pair.second == null) {
                return EMPTY_ARRAY;
            }
            return new AnAction[]{Separator.create((String)((AbstractVcs)pair.second).getDisplayName())};
        }
    }

    public static class Providers
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AbstractVcs vcs;
            List replacingActions;
            if (e == null) {
                return EMPTY_ARRAY;
            }
            Project project = e.getProject();
            DataContext dataContext = e.getDataContext();
            Pair pair = project == null ? Pair.empty() : VcsQuickListPopupAction.getActiveVCS(project, dataContext);
            JBIterable providers = JBIterable.of((Object[])VcsQuickListContentProvider.EP_NAME.getExtensions());
            JBIterable actions = pair.first == SupportedVCS.NOT_IN_VCS ? providers.flatMap(p -> p.getNotInVcsActions(project, dataContext)) : (pair.second != null ? ((replacingActions = (List)providers.filterMap(arg_0 -> Providers.lambda$getChildren$1(vcs = (AbstractVcs)pair.second, dataContext, project, arg_0)).first()) != null ? JBIterable.from((Iterable)replacingActions) : providers.flatMap(p -> p.getVcsActions(project, vcs, dataContext))) : JBIterable.empty());
            return actions.toList().toArray(EMPTY_ARRAY);
        }

        private static /* synthetic */ List lambda$getChildren$1(AbstractVcs vcs, DataContext dataContext, Project project, VcsQuickListContentProvider p) {
            return p.replaceVcsActionsFor(vcs, dataContext) ? p.getVcsActions(project, vcs, dataContext) : null;
        }
    }

    public static enum SupportedVCS {
        VCS,
        NOT_IN_VCS;

    }
}

