/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance(CallbackData.class);
    @NotNull
    private final Runnable myCallback;
    @NotNull
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback2, @NotNull Runnable wrapperStarter) {
        this.myCallback = callback2;
        this.myWrapperStarter = wrapperStarter;
    }

    @NotNull
    public Runnable getCallback() {
        return this.myCallback;
    }

    @NotNull
    public Runnable getWrapperStarter() {
        return this.myWrapperStarter;
    }

    @NotNull
    public static CallbackData create(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, @Nullable String title, @Nullable ModalityState state) {
        return mode.isSilent() ? CallbackData.createSilent(project, mode, afterUpdate) : CallbackData.createInteractive(project, mode, afterUpdate, title, state);
    }

    @NotNull
    private static CallbackData createSilent(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate) {
        Consumer<Runnable> callbackCaller = mode.isCallbackOnAwt() ? arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0) : arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
        Runnable callback2 = () -> {
            CallbackData.logUpdateFinished(project, mode);
            if (!project.isDisposed()) {
                afterUpdate.run();
            }
        };
        return new CallbackData(() -> callbackCaller.accept(callback2), EmptyRunnable.INSTANCE);
    }

    @NotNull
    private static CallbackData createInteractive(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode, @NotNull Runnable afterUpdate, String title, @Nullable ModalityState state) {
        Object task2 = mode.isSynchronous() ? new Waiter(project, afterUpdate, title, mode.isCancellable()) : new FictiveBackgroundable(project, afterUpdate, title, mode.isCancellable(), state);
        Runnable callback2 = () -> CallbackData.lambda$createInteractive$2(project, mode, (Task)task2);
        return new CallbackData(callback2, () -> CallbackData.lambda$createInteractive$3((Task)task2));
    }

    private static void setDone(@NotNull Task task2) {
        if (task2 instanceof Waiter) {
            ((Waiter)task2).done();
        } else if (task2 instanceof FictiveBackgroundable) {
            ((FictiveBackgroundable)task2).done();
        } else {
            throw new IllegalArgumentException("Unknown task type " + task2.getClass());
        }
    }

    private static void logUpdateFinished(@NotNull Project project, @NotNull InvokeAfterUpdateMode mode) {
        LOG.debug(mode + " changes update finished for project " + project.getName());
    }

    private static /* synthetic */ void lambda$createInteractive$3(Task task2) {
        ProgressManager.getInstance().run(task2);
    }

    private static /* synthetic */ void lambda$createInteractive$2(Project project, InvokeAfterUpdateMode mode, Task task2) {
        CallbackData.logUpdateFinished(project, mode);
        CallbackData.setDone(task2);
    }
}

