/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ChangeListCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Key<ComboBox<ChangeList>> COMBO_BOX_KEY = Key.create((String)"CHANGELIST_COMBO_BOX");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file2 = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        if (document == null) {
            return;
        }
        ComboBox comboBox2 = (ComboBox)document.getUserData(COMBO_BOX_KEY);
        if (comboBox2 == null) {
            return;
        }
        CompletionResultSet resultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(document.getText()));
        for (int i = 0; i < comboBox2.getItemCount(); ++i) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)comboBox2.getItemAt(i)));
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        PsiFile file2 = position.getContainingFile();
        Document cachedDocument = PsiDocumentManager.getInstance((Project)file2.getProject()).getCachedDocument(file2);
        return cachedDocument != null && cachedDocument.getUserData(COMBO_BOX_KEY) != null;
    }
}

