/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitResultHandler;
import com.intellij.openapi.vcs.changes.ui.SingleChangeListCommitter;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private final Scheduler myScheduler = new Scheduler();
    private final EventDispatcher<ChangeListListener> myListeners = EventDispatcher.create(ChangeListListener.class);
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock = new Object();
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private final MyChangesDeltaForwarder myDeltaForwarder;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private volatile boolean myShowLocalChangesInvalidated;
    @NotNull
    private ProgressIndicator myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
    private volatile String myFreezeName;
    @NotNull
    private final Set<String> myListsToBeDeletedSilently = new HashSet<String>();
    @NotNull
    private final Set<String> myListsToBeDeleted = new HashSet<String>();
    private boolean myEmptyListDeletionScheduled;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
    private boolean myExcludedConvertedToIgnored;

    public static ChangeListManagerImpl getInstanceImpl(Project project) {
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(@NotNull Project project, VcsConfiguration config2) {
        this.myProject = project;
        this.myConfig = config2;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project));
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myComposite = new FileHolderComposite(project);
        this.myDeltaForwarder = new MyChangesDeltaForwarder(this.myProject, this.myScheduler);
        this.myDelayedNotificator = new DelayedNotificator(this, this.myListeners, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, () -> this.updateImmediately());
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (automatic || oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                }
            });
        }
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList list2) {
        this.scheduleAutomaticEmptyChangeListDeletion(list2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList, boolean silently) {
        Object object = this.myDataLock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Schedule empty changelist deletion: %s, silently = %s", oldList.getName(), silently));
            }
            if (silently) {
                this.myListsToBeDeletedSilently.add(oldList.getId());
            } else {
                this.myListsToBeDeleted.add(oldList.getId());
            }
            if (!this.myEmptyListDeletionScheduled) {
                this.myEmptyListDeletionScheduled = true;
                this.invokeAfterUpdate(() -> this.deleteEmptyChangeLists(), InvokeAfterUpdateMode.SILENT, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyChangeLists() {
        List listsToBeDeleted;
        List listsToBeDeletedSilently;
        Function toDeleteMapping = id -> {
            LocalChangeList list2 = this.getChangeList((String)id);
            if (list2 == null || list2.isDefault() || list2.isReadOnly() || !list2.getChanges().isEmpty()) {
                return null;
            }
            return list2;
        };
        Object object = this.myDataLock;
        synchronized (object) {
            boolean askLater;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, scheduled:\nsilently: %s\nasking: %s", this.myListsToBeDeletedSilently, this.myListsToBeDeleted));
            }
            this.myListsToBeDeleted.removeAll(this.myListsToBeDeletedSilently);
            listsToBeDeletedSilently = ContainerUtil.mapNotNull(this.myListsToBeDeletedSilently, (Function)toDeleteMapping);
            this.myListsToBeDeletedSilently.clear();
            boolean bl = askLater = this.myModalNotificationsBlocked && this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            if (!askLater) {
                listsToBeDeleted = ContainerUtil.mapNotNull(this.myListsToBeDeleted, (Function)toDeleteMapping);
                this.myListsToBeDeleted.clear();
            } else {
                listsToBeDeleted = Collections.emptyList();
            }
            this.myEmptyListDeletionScheduled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, to be deleted:\nsilently: %s\nasking: %s", listsToBeDeletedSilently, listsToBeDeleted));
            }
        }
        if (this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && ApplicationManager.getApplication().isUnitTestMode()) {
            listsToBeDeleted.clear();
        }
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeletedSilently, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> true));
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeleted, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(this.myProject, this.myConfig, toAsk)));
    }

    public static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project, final @NotNull VcsConfiguration config2, @NotNull Collection<? extends ChangeList> lists) {
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list2 -> StringUtil.first((String)list2.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog2 = new VcsConfirmationDialog(project, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config2.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config2.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog2.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
            }
        };
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)((DumbAwareRunnable)() -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            }));
            this.myConflictTracker.startTracking();
        }
    }

    private void broadcastStateAfterLoad() {
        List listCopy = this.getChangeListsCopy();
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForNewProject() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (!Registry.is((String)"ide.hide.excluded.files") && !this.myExcludedConvertedToIgnored) {
                this.convertExcludedToIgnored();
                this.myExcludedConvertedToIgnored = true;
            }
        }
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (String url : policy.getExcludeUrlsForProject()) {
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                VirtualFile file2 = virtualFileManager.findFileByUrl(url);
                if (file2 != null && !fileIndex.isExcluded(file2)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        return "ChangeListManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        this.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable Consumer<? super VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (dirtyScopeManagerFiller != null && !this.myProject.isDisposed()) {
            dirtyScopeManagerFiller.consume((Object)VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    @Override
    public void waitForUpdate(@Nullable String operationName) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        CountDownLatch waiter = new CountDownLatch(1);
        this.invokeAfterUpdate(() -> waiter.countDown(), InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, operationName, ModalityState.NON_MODAL);
        boolean success2 = false;
        while (!success2) {
            ProgressManager.checkCanceled();
            try {
                success2 = waiter.await(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn((Throwable)e);
                throw new ProcessCanceledException((Throwable)e);
            }
        }
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet refreshFiles = new HashSet();
        try {
            ReadAction.run(() -> {
                Object object = this.myDataLock;
                synchronized (object) {
                    IgnoredFilesCompositeHolder fileHolder = this.myComposite.getIgnoredFileHolder();
                    Iterator iterator = scopes.iterator();
                    while (iterator.hasNext()) {
                        VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator.next();
                        VcsDirtyScopeModifier modifier = scope.getModifier();
                        if (modifier == null) continue;
                        fileHolder.notifyVcsStarted(scope.getVcs());
                        this.filterOutIgnoredFiles(modifier.getDirtyFilesIterator(), fileHolder, refreshFiles);
                        this.filterOutIgnoredFiles(modifier.getDirtyDirectoriesIterator(), fileHolder, refreshFiles);
                        modifier.recheckDirtyKeys();
                        if (!scope.isEmpty()) continue;
                        iterator.remove();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    private void filterOutIgnoredFiles(Iterator<? extends FilePath> iterator, IgnoredFilesCompositeHolder fileHolder, Set<? super VirtualFile> refreshFiles) {
        while (iterator.hasNext()) {
            AbstractVcs vcs;
            VirtualFile file2 = iterator.next().getVirtualFile();
            if (file2 == null || !this.isPotentiallyIgnoredFile(file2) || (vcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)file2)) == null) continue;
            iterator.remove();
            fileHolder.addFile(vcs, file2);
            refreshFiles.add((VirtualFile)file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator = indicator;
        }
        ProgressManager.getInstance().runProcess(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
            if (this.checkScopeIsEmpty(invalidated)) {
                LOG.debug("[update] - dirty scope is empty");
                this.myDirtyScopeManager.changesProcessed();
                return;
            }
            boolean wasEverythingDirty = invalidated.isEverythingDirty();
            List scopes = invalidated.getScopes();
            try {
                boolean takeChanges;
                DataHolder dataHolder;
                if (this.myUpdater.isStopped()) {
                    return;
                }
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                    this.myModifier.enterUpdate();
                    if (wasEverythingDirty) {
                        this.myUpdateException = null;
                        this.myAdditionalInfo = null;
                    }
                    if (LOG.isDebugEnabled()) {
                        String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                        LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\nignored: " + this.myComposite.getIgnoredFileHolder().values().size() + "\nunversioned: " + this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\ncurrent changes: " + this.myWorker);
                    }
                }
                dataHolder.notifyStart();
                this.myChangesViewManager.scheduleRefresh();
                this.iterateScopes(dataHolder, scopes, indicator);
                Iterator iterator = this.myDataLock;
                synchronized (iterator) {
                    takeChanges = this.myUpdateException == null;
                }
                if (takeChanges) {
                    this.updateIgnoredFiles(dataHolder.getComposite());
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    this.clearCurrentRevisionsCache(invalidated);
                    Object object = this.myDataLock;
                    synchronized (object) {
                        dataHolder.notifyEnd();
                        if (takeChanges) {
                            ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                            this.myModifier.finishUpdate(updatedWorker);
                            this.myWorker.applyChangesFromUpdate(updatedWorker, this.myDeltaForwarder);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\nchanges: " + this.myWorker);
                            }
                            boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                            this.myComposite = dataHolder.getComposite();
                            if (statusChanged) {
                                this.myDelayedNotificator.unchangedFileStatusChanged();
                            }
                            LOG.debug("[update] - success");
                        } else {
                            this.myModifier.finishUpdate(null);
                            LOG.debug("[update] - aborted");
                        }
                        this.myShowLocalChangesInvalidated = false;
                    }
                });
                for (VcsDirtyScope scope2 : scopes) {
                    AbstractVcs vcs = scope2.getVcs();
                    if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                    scope2.iterateExistingInsideScope(file2 -> {
                        LastUnchangedContentTracker.markUntouched(file2);
                        return true;
                    });
                }
            }
            catch (ProcessCanceledException dataHolder) {
            }
            catch (AssertionError | Exception ex) {
                LOG.error((Throwable)ex);
            }
            finally {
                this.myDirtyScopeManager.changesProcessed();
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }, indicator);
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        if (invalidated.isEmpty()) {
            return true;
        }
        this.filterOutIgnoredFiles(invalidated.getScopes());
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<? extends VcsDirtyScope> scopes, @NotNull ProgressIndicator indicator) {
        ChangeListWorker.ChangeListUpdater updater = dataHolder.getChangeListUpdater();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder2 = new UpdatingChangeListBuilder(updater, dataHolder.getComposite(), (Getter<Boolean>)disposedGetter);
        for (VcsDirtyScope vcsDirtyScope : scopes) {
            indicator.checkCanceled();
            AbstractVcs vcs = vcsDirtyScope.getVcs();
            if (vcs == null) continue;
            this.myChangesViewManager.setBusy(true);
            this.actualUpdate(builder2, vcsDirtyScope, vcs, dataHolder, updater, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder2.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        return new EmptyProgressIndicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder2, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder2.setCurrent(scope);
                changeProvider.getChanges(scope, (ChangelistBuilder)builder2, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeLists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAllChanges();
        }
    }

    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
            }
        });
    }

    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
            }
        });
    }

    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
            }
        });
    }

    boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
            }
        });
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file2);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        return this.addChangeList(name, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        return (LocalChangeList)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
    }

    public void removeChangeList(@NotNull String name) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(@NotNull LocalChangeList list2) {
        this.removeChangeList(list2.getName());
    }

    public void setDefaultChangeList(@NotNull String name, boolean automatic) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name, automatic);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    public void setDefaultChangeList(@NotNull String name) {
        this.setDefaultChangeList(name, false);
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list2) {
        this.setDefaultChangeList(list2, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list2, boolean automatic) {
        this.setDefaultChangeList(list2.getName(), automatic);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String name, String newComment) {
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(name, StringUtil.notNullize((String)newComment));
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public boolean editChangeListData(@NotNull String name, @Nullable ChangeListData newData) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editData(name, newData);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list2, Change ... changes2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list2.getName(), changes2);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultList().getName();
        }
    }

    public void notifyChangelistsChanged(@NotNull FilePath path, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        this.myWorker.notifyChangelistsChanged(path, beforeChangeListsIds, afterChangeListsIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes2) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes2));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    @Override
    public boolean isInUpdate() {
        return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedLists(changes2);
        }
    }

    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull Change change) {
        return this.getAffectedLists(Collections.singletonList(change));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath((VirtualFile)file2));
            if (change == null) {
                return Collections.emptyList();
            }
            return this.getChangeLists(change);
        }
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(change));
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    public boolean isUnversioned(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
            }
        });
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        return (FileStatus)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
                    return FileStatus.UNKNOWN;
                }
                if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(file2), (Object)FileStatus.NOT_CHANGED);
                if (FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file2))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        return this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (!vf.isValid() || !vf.isDirectory()) {
            return ThreeState.NO;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.haveChangesUnder(vf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangesUnder(dirPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getVcsFor(change);
        }
    }

    @Override
    public void addUnversionedFiles(@NotNull LocalChangeList list2, @NotNull List<? extends VirtualFile> files2) {
        ScheduleForAdditionAction.addUnversionedFilesToVcs(this.myProject, list2, files2);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes2) {
        this.doCommit(changeList, changes2, false);
    }

    private void doCommit(LocalChangeList changeList, List<? extends Change> changes2, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        String commitMessage2 = StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment();
        SingleChangeListCommitter committer = new SingleChangeListCommitter(this.myProject, changeList, changes2, commitMessage2, ContainerUtil.emptyList(), (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null, changeList.getName(), false);
        committer.addResultHandler(new DefaultCommitResultHandler(committer));
        committer.runCommit(changeList.getName(), synchronously);
    }

    public void commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> changes2) {
        this.doCommit(changeList, changes2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myIgnoredIdeaLevel, this.myWorker);
        }
        this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        IgnoredFilesComponent ignoredFilesComponent;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ignoredFilesComponent = this.myIgnoredIdeaLevel.copy();
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, ignoredFilesComponent, worker);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)Boolean.toString(this.myExcludedConvertedToIgnored), (String)Boolean.toString(false));
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<? extends FilePath> paths) {
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        return Collections.unmodifiableList(this.myRegisteredCommitExecutors);
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path) {
        this.myIgnoredIdeaLevel.removeImplicitlyIgnoredDirectory(path, this.myProject);
    }

    @Deprecated
    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    private void scheduleUnversionedUpdate() {
        Couple couple = (Couple)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                List<VirtualFile> unversioned = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
                Collection<VirtualFile> ignored = this.myComposite.getIgnoredFileHolder().values();
                return Couple.of(unversioned, ignored);
            }
        });
        Collection unversioned = (Collection)couple.first;
        Collection ignored = (Collection)couple.second;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (VirtualFile vf : ContainerUtil.concat((Iterable[])new Iterable[]{unversioned, ignored})) {
                if (vf.isDirectory()) {
                    dirs.add(vf);
                    continue;
                }
                files2.add(vf);
            }
            vcsDirtyScopeManager.filesDirty(files2, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<? extends VirtualFile> unversionedFiles) {
        for (VirtualFile virtualFile : unversionedFiles) {
            AbstractVcs vcs;
            if (!this.isPotentiallyIgnoredFile(virtualFile) || (vcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)virtualFile)) == null) continue;
            vfHolder.removeFile(virtualFile);
            composite.getIgnoredFileHolder().addFile(vcs, virtualFile);
        }
    }

    @NotNull
    public IgnoredFileBean[] getFilesToIgnore() {
        return this.myIgnoredIdeaLevel.getFilesToIgnore();
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getPotentiallyIgnoredFiles() {
        return ContainerUtil.unmodifiableOrEmptySet(IgnoredFileProvider.IGNORE_FILE.extensions().flatMap(provider -> provider.getIgnoredFiles(this.myProject).stream()).collect(Collectors.toSet()));
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        return this.isPotentiallyIgnoredFile(file2);
    }

    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file2) {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        return ContainerUtil.exists((Object[])IgnoredFileProvider.IGNORE_FILE.getExtensions(), it -> it.isIgnoredFile(this.myProject, filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVcsIgnoredFile(@NotNull VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getIgnoredFileHolder().containsFile(file2);
        }
    }

    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file2) {
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file2);
            }
        });
    }

    public void waitUntilRefreshed() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        VcsDirtyScopeVfsListener.getInstance(this.myProject).waitForAsyncTaskCompletion();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> semaphore.up());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            while (!semaphore.waitFor(100L)) {
                UIUtil.dispatchAllInvocationEvents();
            }
        } else {
            semaphore.waitFor();
        }
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.cancelAll();
    }

    public void waitEverythingDoneInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAll();
    }

    public void forceStopInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.stop();
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        VcsDirtyScopeVfsListener.getInstance(this.myProject).waitForAsyncTaskCompletion();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    public void showLocalChangesInvalidated() {
        this.myShowLocalChangesInvalidated = true;
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    public void replaceCommitMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        this.myConfig.replaceMessage(oldMessage, newMessage);
        for (LocalChangeList changeList : this.getChangeLists()) {
            if (!oldMessage.equals(changeList.getComment())) continue;
            this.editComment(changeList.getName(), newMessage);
        }
    }

    static class Scheduler {
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl Pool", (int)1);
        private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        private final ArrayDeque<Future> myFutures = new ArrayDeque();

        Scheduler() {
        }

        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
            ScheduledFuture<?> future2 = this.myExecutor.schedule(command, delay, unit);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        public void submit(@NotNull Runnable command) {
            Future<?> future2 = this.myExecutor.submit(command);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFuture(Future<?> future2) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                this.myFutures.add(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelAll() {
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                for (Future future2 : this.myFutures) {
                    future2.cancel(true);
                }
                this.myFutures.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitAll() {
            ArrayList<Exception> throwables = new ArrayList<Exception>();
            long start2 = System.currentTimeMillis();
            while (true) {
                Future future2;
                if (System.currentTimeMillis() - start2 > TimeUnit.MINUTES.toMillis(10L)) {
                    this.cancelAll();
                    throwables.add(new IllegalStateException("Too long waiting for VCS update"));
                    break;
                }
                ArrayDeque<Future> arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    future2 = this.myFutures.peek();
                }
                if (future2 == null) break;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    continue;
                }
                catch (CancellationException ignore) {
                }
                catch (InterruptedException | ExecutionException e) {
                    throwables.add(e);
                }
                arrayDeque = this.myFutures;
                synchronized (arrayDeque) {
                    this.myFutures.remove(future2);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(throwables);
        }
    }

    private static class MyChangesDeltaForwarder
    implements ChangeListDeltaListener {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        MyChangesDeltaForwarder(Project project, @NotNull Scheduler scheduler) {
            this.myProject = project;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void modified(@NotNull BaseRevision was, @NotNull BaseRevision become) {
            this.doModify(was, become);
        }

        @Override
        public void added(@NotNull BaseRevision baseRevision) {
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void removed(@NotNull BaseRevision baseRevision) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.changeRemoved(baseRevision.getPath(), vcs);
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.changeUpdated(was.getPath(), vcs);
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            AbstractVcs vcs = baseRevision.getVcs();
            if (vcs != null) {
                return vcs;
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            IProjectStore store = ProjectKt.getStateStore(project);
            return !ProjectKt.isDirectoryBased(project) && FileUtilRt.extensionEquals((String)filePath.getPath(), (String)"iws") || StringsKt.equals((String)filePath.getPath(), (String)store.getWorkspaceFilePath(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) || DefaultIgnoredFileProvider.isShelfDirOrInsideIt(filePath, project);
        }

        private static boolean isShelfDirOrInsideIt(@NotNull FilePath filePath, @NotNull Project project) {
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            return FileUtil.isAncestor((String)shelfPath, (String)filePath.getPath(), (boolean)false);
        }

        @NotNull
        public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
            LinkedHashSet ignored = ContainerUtil.newLinkedHashSet();
            String shelfPath = ShelveChangesManager.getShelfPath(project);
            ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)shelfPath, (Project)project));
            String workspaceFilePath = ProjectKt.getStateStore(project).getWorkspaceFilePath();
            if (workspaceFilePath != null) {
                ignored.add(IgnoredBeanFactory.ignoreFile((String)workspaceFilePath, (Project)project));
            }
            return ContainerUtil.unmodifiableOrEmptySet((Set)ignored);
        }

        @NotNull
        public String getIgnoredGroupDescription() {
            return "Default ignored files";
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            return this.myChangeListUpdater;
        }
    }
}

