/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeListManagerSerialization {
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_NAME = "name";
    @NonNls
    private static final String ATT_COMMENT = "comment";
    @NonNls
    private static final String ATT_DEFAULT = "default";
    @NonNls
    private static final String ATT_VALUE_TRUE = "true";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH = "beforePath";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH = "afterPath";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_ESCAPED = "beforePathEscaped";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_ESCAPED = "afterPathEscaped";
    @NonNls
    private static final String ATT_CHANGE_BEFORE_PATH_IS_DIR = "beforeDir";
    @NonNls
    private static final String ATT_CHANGE_AFTER_PATH_IS_DIR = "afterDir";
    @NonNls
    private static final String ATT_PATH = "path";
    @NonNls
    private static final String ATT_MASK = "mask";
    @NonNls
    private static final String NODE_LIST = "list";
    @NonNls
    private static final String NODE_IGNORED = "ignored";
    @NonNls
    private static final String NODE_CHANGE = "change";
    @NonNls
    private static final String MANUALLY_REMOVED_FROM_IGNORED = "manually-removed-from-ignored";
    @NonNls
    private static final String DIRECTORY_TAG = "directory";

    ChangeListManagerSerialization() {
    }

    public static void writeExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredFilesComponent, @NotNull ChangeListWorker worker) {
        for (LocalChangeList list2 : worker.getChangeLists()) {
            element.addContent(ChangeListManagerSerialization.writeChangeList(list2));
        }
        for (IgnoredFileBean bean : ignoredFilesComponent.getFilesToIgnore()) {
            element.addContent(ChangeListManagerSerialization.writeFileToIgnore(bean));
        }
        Set<String> manuallyRemovedFromIgnored = ignoredFilesComponent.getDirectoriesManuallyRemovedFromIgnored();
        if (!manuallyRemovedFromIgnored.isEmpty()) {
            Element list3 = new Element(MANUALLY_REMOVED_FROM_IGNORED);
            for (String path : manuallyRemovedFromIgnored) {
                list3.addContent(new Element(DIRECTORY_TAG).setAttribute(ATT_PATH, path));
            }
            element.addContent(list3);
        }
    }

    public static void readExternal(@NotNull Element element, @NotNull IgnoredFilesComponent ignoredIdeaLevel, @NotNull ChangeListWorker worker) {
        ArrayList<LocalChangeListImpl> lists = new ArrayList<LocalChangeListImpl>();
        for (Element listNode : element.getChildren(NODE_LIST)) {
            lists.add(ChangeListManagerSerialization.readChangeList(listNode, worker.getProject()));
        }
        worker.setChangeLists(ChangeListManagerSerialization.removeDuplicatedLists(lists));
        ignoredIdeaLevel.clear();
        for (Element ignoredNode : element.getChildren(NODE_IGNORED)) {
            ChangeListManagerSerialization.readFileToIgnore(ignoredNode, worker.getProject(), ignoredIdeaLevel);
        }
        Element manuallyRemovedFromIgnoredTag = element.getChild(MANUALLY_REMOVED_FROM_IGNORED);
        HashSet<String> manuallyRemovedFromIgnoredPaths = new HashSet<String>();
        if (manuallyRemovedFromIgnoredTag != null) {
            for (Element tag : manuallyRemovedFromIgnoredTag.getChildren(DIRECTORY_TAG)) {
                manuallyRemovedFromIgnoredPaths.add(tag.getAttributeValue(ATT_PATH));
            }
        }
        ignoredIdeaLevel.setDirectoriesManuallyRemovedFromIgnored(manuallyRemovedFromIgnoredPaths);
    }

    @NotNull
    private static Collection<LocalChangeListImpl> removeDuplicatedLists(@NotNull List<LocalChangeListImpl> lists) {
        boolean hasDefault = false;
        HashMap<String, LocalChangeListImpl> map2 = new HashMap<String, LocalChangeListImpl>();
        for (LocalChangeListImpl list2 : lists) {
            if (list2.isDefault() && hasDefault) {
                list2 = new LocalChangeListImpl.Builder(list2).setDefault(false).build();
            }
            hasDefault |= list2.isDefault();
            LocalChangeListImpl otherList = (LocalChangeListImpl)((Object)map2.get(list2.getName()));
            if (otherList != null) {
                list2 = new LocalChangeListImpl.Builder(otherList).setChanges(ContainerUtil.union((Set)list2.getChanges(), (Set)otherList.getChanges())).setDefault(list2.isDefault() || otherList.isDefault()).build();
            }
            map2.put(list2.getName(), list2);
        }
        return map2.values();
    }

    @NotNull
    private static Element writeChangeList(@NotNull LocalChangeList list2) {
        Object listData;
        Element listNode = new Element(NODE_LIST);
        if (list2.isDefault()) {
            listNode.setAttribute(ATT_DEFAULT, ATT_VALUE_TRUE);
        }
        listNode.setAttribute(ATT_ID, list2.getId());
        listNode.setAttribute(ATT_NAME, list2.getName());
        String comment = list2.getComment();
        if (comment != null) {
            listNode.setAttribute(ATT_COMMENT, comment);
        }
        if ((listData = list2.getData()) instanceof ChangeListData) {
            listNode.addContent(ChangeListData.writeExternal((ChangeListData)listData));
        }
        List changes2 = ContainerUtil.sorted((Collection)list2.getChanges(), (Comparator)new ChangeComparator());
        for (Change change : changes2) {
            listNode.addContent(ChangeListManagerSerialization.writeChange(change));
        }
        return listNode;
    }

    @NotNull
    private static LocalChangeListImpl readChangeList(@NotNull Element listNode, @NotNull Project project) {
        String id = listNode.getAttributeValue(ATT_ID);
        String name = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_NAME), (String)LocalChangeList.DEFAULT_NAME);
        String comment = StringUtil.notNullize((String)listNode.getAttributeValue(ATT_COMMENT));
        ChangeListData data = ChangeListData.readExternal(listNode);
        boolean isDefault = ATT_VALUE_TRUE.equals(listNode.getAttributeValue(ATT_DEFAULT));
        ArrayList<Change> changes2 = new ArrayList<Change>();
        for (Element changeNode : listNode.getChildren(NODE_CHANGE)) {
            changes2.add(ChangeListManagerSerialization.readChange(changeNode));
        }
        return new LocalChangeListImpl.Builder(project, name).setId(id).setComment(comment).setChanges(changes2).setData(data).setDefault(isDefault).build();
    }

    @NotNull
    private static Element writeFileToIgnore(@NotNull IgnoredFileBean bean) {
        String mask;
        Element fileNode = new Element(NODE_IGNORED);
        String path = bean.getPath();
        if (path != null) {
            fileNode.setAttribute(ATT_PATH, path);
        }
        if ((mask = bean.getMask()) != null) {
            fileNode.setAttribute(ATT_MASK, mask);
        }
        return fileNode;
    }

    private static void readFileToIgnore(@NotNull Element ignoredNode, @NotNull Project project, @NotNull IgnoredFilesComponent ignoredFilesComponent) {
        String mask;
        String path = ignoredNode.getAttributeValue(ATT_PATH);
        if (path != null) {
            ignoredFilesComponent.add(path.endsWith("/") || path.endsWith(File.separator) ? IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project) : IgnoredBeanFactory.ignoreFile((String)path, (Project)project));
        }
        if ((mask = ignoredNode.getAttributeValue(ATT_MASK)) != null) {
            ignoredFilesComponent.add(IgnoredBeanFactory.withMask((String)mask));
        }
    }

    @NotNull
    private static Element writeChange(@NotNull Change change) {
        Element changeNode = new Element(NODE_CHANGE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getBeforeRevision(), RevisionSide.BEFORE);
        ChangeListManagerSerialization.writeContentRevision(changeNode, change.getAfterRevision(), RevisionSide.AFTER);
        return changeNode;
    }

    @NotNull
    private static Change readChange(@NotNull Element changeNode) {
        FakeRevision bRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.BEFORE);
        FakeRevision aRev = ChangeListManagerSerialization.readContentRevision(changeNode, RevisionSide.AFTER);
        return new Change((ContentRevision)bRev, (ContentRevision)aRev);
    }

    private static void writeContentRevision(@NotNull Element changeNode, @Nullable ContentRevision rev, @NotNull RevisionSide side) {
        if (rev == null) {
            return;
        }
        FilePath filePath = rev.getFile();
        String path = filePath.getPath();
        if (ChangeListManagerSerialization.hasIllegalXmlChars(path)) {
            changeNode.setAttribute(side.getPathKey(), JDOMUtil.removeControlChars((String)path));
            changeNode.setAttribute(side.getEscapedPathKey(), XmlStringUtil.escapeIllegalXmlChars((String)path));
        } else {
            changeNode.setAttribute(side.getPathKey(), path);
        }
        changeNode.setAttribute(side.getIsDirKey(), String.valueOf(filePath.isDirectory()));
    }

    @Nullable
    private static FakeRevision readContentRevision(@NotNull Element changeNode, @NotNull RevisionSide side) {
        String path;
        String plainPath = changeNode.getAttributeValue(side.getPathKey());
        String escapedPath = changeNode.getAttributeValue(side.getEscapedPathKey());
        String string = path = escapedPath != null ? XmlStringUtil.unescapeIllegalXmlChars((String)escapedPath) : plainPath;
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        String value = changeNode.getAttributeValue(side.getIsDirKey());
        if (value != null) {
            boolean isDirectory = Boolean.parseBoolean(value);
            return new FakeRevision(VcsUtil.getFilePath((String)path, (boolean)isDirectory));
        }
        return new FakeRevision(VcsUtil.getFilePath((String)path));
    }

    private static boolean hasIllegalXmlChars(@NotNull String text) {
        return text.chars().anyMatch(c -> !Verifier.isXMLCharacter((int)c));
    }

    private static enum RevisionSide {
        BEFORE("beforePath", "beforePathEscaped", "beforeDir"),
        AFTER("afterPath", "afterPathEscaped", "afterDir");

        @NotNull
        private final String myPathKey;
        @NotNull
        private final String myEscapedPathKey;
        @NotNull
        private final String myIsDirKey;

        private RevisionSide(@NotNull String pathKey, String escapedPathKey, String isDirKey) {
            this.myPathKey = pathKey;
            this.myEscapedPathKey = escapedPathKey;
            this.myIsDirKey = isDirKey;
        }

        @NotNull
        public String getPathKey() {
            return this.myPathKey;
        }

        @NotNull
        String getEscapedPathKey() {
            return this.myEscapedPathKey;
        }

        @NotNull
        public String getIsDirKey() {
            return this.myIsDirKey;
        }
    }

    private static class ChangeComparator
    implements Comparator<Change> {
        private ChangeComparator() {
        }

        @Override
        public int compare(Change o1, Change o2) {
            ContentRevision bRev2;
            ContentRevision bRev1 = o1.getBeforeRevision();
            int delta = ChangeComparator.compareRevisions(bRev1, bRev2 = o2.getBeforeRevision());
            if (delta != 0) {
                return delta;
            }
            ContentRevision aRev1 = o1.getAfterRevision();
            ContentRevision aRev2 = o2.getAfterRevision();
            return ChangeComparator.compareRevisions(aRev1, aRev2);
        }

        private static int compareRevisions(@Nullable ContentRevision bRev1, @Nullable ContentRevision bRev2) {
            if (bRev1 == null && bRev2 == null) {
                return 0;
            }
            if (bRev1 == null) {
                return -1;
            }
            if (bRev2 == null) {
                return 1;
            }
            String path1 = bRev1.getFile().getPath();
            String path2 = bRev2.getFile().getPath();
            return path1.compareTo(path2);
        }
    }
}

