/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.util.text.UniqueNameGenerator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0003*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"CHANGELIST_NAME_PATTERN", "", "STASH_MESSAGE_PATTERN", "kotlin.jvm.PlatformType", "SYSTEM_CHANGELIST_REGEX", "Lkotlin/text/Regex;", "createNameForChangeList", "project", "Lcom/intellij/openapi/project/Project;", "commitMessage", "createSystemShelvedChangeListName", "systemPrefix", "changelistName", "getChangeListNameForUnshelve", "shelvedList", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "getOriginalName", "shelvedName", "getPredefinedChangeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "intellij.platform.vcs.impl"})
@JvmName(name="ChangeListUtil")
public final class ChangeListUtil {
    private static final String CHANGELIST_NAME_PATTERN = "\\s\\[(.*)\\]";
    private static final String STASH_MESSAGE_PATTERN = VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{".*"});
    private static final Regex SYSTEM_CHANGELIST_REGEX;

    @NotNull
    public static final String createSystemShelvedChangeListName(@NotNull String systemPrefix, @NotNull String changelistName) {
        return systemPrefix + " [" + changelistName + ']';
    }

    private static final String getOriginalName(String shelvedName) {
        Object object = SYSTEM_CHANGELIST_REGEX.matchEntire((CharSequence)shelvedName);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            object = shelvedName;
        }
        return object;
    }

    @Nullable
    public static final LocalChangeList getPredefinedChangeList(@NotNull ShelvedChangeList shelvedList, @NotNull ChangeListManager changeListManager) {
        String defaultName = shelvedList.DESCRIPTION;
        Object object = changeListManager.findChangeList(defaultName);
        if (object == null) {
            object = shelvedList.isMarkedToDelete() ? changeListManager.findChangeList(ChangeListUtil.getOriginalName(defaultName)) : null;
        }
        return object;
    }

    @NotNull
    public static final String getChangeListNameForUnshelve(@NotNull ShelvedChangeList shelvedList) {
        String defaultName = shelvedList.DESCRIPTION;
        return shelvedList.isMarkedToDelete() ? ChangeListUtil.getOriginalName(defaultName) : defaultName;
    }

    @NotNull
    public static final String createNameForChangeList(@NotNull Project project, @NotNull String commitMessage2) {
        CharSequence charSequence;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        String string = charSequence = commitMessage2;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string2 = charSequence = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)'\n', null, (int)2, null);
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String string3 = "[ ]{2,}";
        string3 = new Regex(string3);
        String string4 = " ";
        String proposedName = string3.replace(charSequence, string4);
        return UniqueNameGenerator.generateUniqueName((String)proposedName, (String)"", (String)"", (String)"-", (String)"", (Condition)((Condition)new Condition<String>(changeListManager){
            final /* synthetic */ ChangeListManager $changeListManager;

            public final boolean value(String it) {
                return this.$changeListManager.findChangeList(it) == null;
            }
            {
                this.$changeListManager = changeListManager;
            }
        }));
    }

    static {
        String string = STASH_MESSAGE_PATTERN + CHANGELIST_NAME_PATTERN;
        SYSTEM_CHANGELIST_REGEX = new Regex(string);
    }
}

