/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeViewDiffRequestProcessor
extends CacheDiffRequestProcessor<DiffRequestProducer>
implements DiffPreviewUpdateProcessor {
    @Nullable
    private Wrapper myCurrentChange;

    public ChangeViewDiffRequestProcessor(@NotNull Project project, @NotNull String place) {
        super(project, place);
    }

    @NotNull
    protected abstract List<Wrapper> getSelectedChanges();

    @NotNull
    protected abstract List<Wrapper> getAllChanges();

    protected abstract void selectChange(@NotNull Wrapper var1);

    @Override
    @NotNull
    protected String getRequestName(@NotNull DiffRequestProducer producer) {
        return producer.getName();
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        return this.myCurrentChange != null ? this.myCurrentChange.createProducer(this.getProject()) : null;
    }

    @Override
    @NotNull
    protected DiffRequest loadRequest(@NotNull DiffRequestProducer producer, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
        return producer.process((UserDataHolder)this.getContext(), indicator);
    }

    @Override
    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider) {
        DiffRequest request = super.loadRequestFast(provider);
        return ChangeViewDiffRequestProcessor.isRequestValid(request) ? request : null;
    }

    private static boolean isRequestValid(@Nullable DiffRequest request) {
        if (request instanceof ErrorDiffRequest) {
            return false;
        }
        if (request instanceof ContentDiffRequest) {
            for (DiffContent content : ((ContentDiffRequest)request).getContents()) {
                if (!(content instanceof FileContent) || ((FileContent)content).getFile().isValid()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    @Override
    public boolean isWindowFocused() {
        return DiffUtil.isFocusedComponent(this.getProject(), this.getComponent());
    }

    @Override
    public void clear() {
        this.myCurrentChange = null;
        this.updateRequest();
        this.dropCaches();
    }

    @Override
    public void refresh(boolean fromModelRefresh) {
        Wrapper selectedChange;
        List<Wrapper> selectedChanges = this.getSelectedChanges();
        Wrapper wrapper2 = selectedChange = this.myCurrentChange != null ? (Wrapper)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (fromModelRefresh && selectedChange == null && this.myCurrentChange != null && this.getContext().isWindowFocused() && this.getContext().isFocusedInWindow()) {
            if (selectedChanges.size() == 1 && this.getAllChanges().contains(this.myCurrentChange)) {
                this.selectChange(this.myCurrentChange);
            }
            return;
        }
        if (selectedChanges.isEmpty()) {
            this.setCurrentChange(null);
            return;
        }
        if (selectedChange == null) {
            this.setCurrentChange(selectedChanges.get(0));
            return;
        }
        this.setCurrentChange(selectedChange);
    }

    public void setCurrentChange(@Nullable Wrapper change) {
        this.myCurrentChange = change;
        this.updateRequest();
    }

    @Override
    protected boolean hasNextChange() {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy();
        return strategy != null && strategy.canGoNext();
    }

    @Override
    protected boolean hasPrevChange() {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy();
        return strategy != null && strategy.canGoPrev();
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        ((PrevNextDifferenceIterable)ObjectUtils.notNull((Object)this.getSelectionStrategy())).goNext();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        ((PrevNextDifferenceIterable)ObjectUtils.notNull((Object)this.getSelectionStrategy())).goPrev();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return true;
    }

    @Nullable
    private PrevNextDifferenceIterable getSelectionStrategy() {
        if (this.myCurrentChange == null) {
            return null;
        }
        List<Wrapper> selectedChanges = this.getSelectedChanges();
        if (selectedChanges.isEmpty()) {
            return null;
        }
        if (selectedChanges.size() == 1) {
            return new ChangesNavigatable(this.getAllChanges(), selectedChanges.get(0), true);
        }
        return new ChangesNavigatable(selectedChanges, selectedChanges.get(0), false);
    }

    private static class ErrorChangeRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final Change myChange;
        @NotNull
        private final DiffRequest myRequest;

        ErrorChangeRequestProducer(@NotNull Change change, @NotNull DiffRequest request) {
            this.myChange = change;
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            return ChangeDiffRequestProducer.getRequestTitle(this.myChange);
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            return this.myRequest;
        }
    }

    protected static class UnversionedFileWrapper
    extends Wrapper {
        @NotNull
        private final VirtualFile file;

        public UnversionedFileWrapper(@NotNull VirtualFile file2) {
            this.file = file2;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.file;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return UnversionedDiffRequestProducer.create(project, this.file);
        }
    }

    protected static class ChangeWrapper
    extends Wrapper {
        @NotNull
        private final Change change;

        public ChangeWrapper(@NotNull Change change) {
            this.change = change;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            return this.change;
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            if (this.change.getBeforeRevision() instanceof FakeRevision || this.change.getAfterRevision() instanceof FakeRevision) {
                LoadingDiffRequest request = new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.change));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            ChangeDiffRequestProducer producer = ChangeDiffRequestProducer.create(project, this.change);
            if (producer == null) {
                ErrorDiffRequest request = new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            return producer;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ChangeWrapper wrapper2 = (ChangeWrapper)o;
            return ChangeListChange.HASHING_STRATEGY.equals((Object)wrapper2.change, (Object)this.change);
        }

        @Override
        public int hashCode() {
            return this.change.hashCode();
        }
    }

    protected static abstract class Wrapper {
        protected Wrapper() {
        }

        @NotNull
        public abstract Object getUserObject();

        @Nullable
        public abstract DiffRequestProducer createProducer(@Nullable Project var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Wrapper wrapper2 = (Wrapper)o;
            return Comparing.equal((Object)this.getUserObject(), (Object)wrapper2.getUserObject());
        }

        public int hashCode() {
            return this.getUserObject().hashCode();
        }
    }

    private class ChangesNavigatable
    implements PrevNextDifferenceIterable {
        @NotNull
        private final List<? extends Wrapper> myChanges;
        @NotNull
        private final Wrapper myFallback;
        private final boolean myUpdateSelection;

        ChangesNavigatable(@NotNull List<? extends Wrapper> allChanges, Wrapper fallback, boolean updateSelection) {
            this.myChanges = allChanges;
            this.myFallback = fallback;
            this.myUpdateSelection = updateSelection;
        }

        @Override
        public boolean canGoNext() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index < this.myChanges.size() - 1;
        }

        @Override
        public boolean canGoPrev() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index == -1 || index > 0;
        }

        @Override
        public void goNext() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index + 1));
            } else {
                this.select(this.myFallback);
            }
        }

        @Override
        public void goPrev() {
            int index = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index != -1) {
                this.select(this.myChanges.get(index - 1));
            } else {
                this.select(this.myFallback);
            }
        }

        private void select(@NotNull Wrapper change) {
            ChangeViewDiffRequestProcessor.this.myCurrentChange = change;
            if (this.myUpdateSelection) {
                ChangeViewDiffRequestProcessor.this.selectChange(change);
            }
        }
    }
}

