/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.DnDActivateOnHoldTargetContent;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewCommitPanel;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcsUtil.VcsImplUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewI,
ProjectComponent,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesViewManager");
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final ChangesListView myView;
    private final VcsConfiguration myVcsConfiguration;
    private JPanel myProgressLabel;
    private final Alarm myTreeUpdateAlarm;
    private final Object myTreeUpdateIndicatorLock = new Object();
    @NotNull
    private ProgressIndicator myTreeUpdateIndicator = new EmptyProgressIndicator();
    private boolean myDisposed = false;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangesViewContentManager myContentManager;
    @NotNull
    private State myState = new State();
    private PreviewDiffSplitterComponent mySplitterComponent;
    @NotNull
    private final TreeSelectionListener myTsl;
    @NotNull
    private final PropertyChangeListener myGroupingChangeListener;
    private MyChangeViewContent myContent;
    private boolean myModelUpdateInProgress;
    private final MyTreeExpander myTreeExpander;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project) {
        return (ChangesViewI)project.getComponent(ChangesViewI.class);
    }

    public ChangesViewManager(@NotNull Project project, @NotNull ChangesViewContentManager contentManager) {
        this.myProject = project;
        this.myContentManager = contentManager;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myView = new ChangesListView(project, VcsImplUtil.isNonModalCommit());
        this.myTreeExpander = new MyTreeExpander();
        this.myView.setTreeExpander((TreeExpander)this.myTreeExpander);
        this.myTreeUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.myTsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LOG.isDebugEnabled()) {
                    Object[] paths = ChangesViewManager.this.myView.getSelectionPaths();
                    String joinedPaths = paths != null ? StringUtil.join((Object[])paths, (Function)FunctionUtil.string(), (String)", ") : null;
                    String message = "selection changed. selected:  " + joinedPaths;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(message + " from: " + DebugUtil.currentStackTrace());
                    } else {
                        LOG.debug(message);
                    }
                }
                boolean fromModelRefresh = ChangesViewManager.this.myModelUpdateInProgress;
                ApplicationManager.getApplication().invokeLater(() -> ChangesViewManager.this.updatePreview(fromModelRefresh));
            }
        };
        this.myGroupingChangeListener = e -> {
            this.myState.groupingKeys = this.myView.getGroupingSupport().getGroupingKeys();
            this.scheduleRefresh();
        };
    }

    public void projectOpened() {
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this.myProject);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        JComponent panel2 = this.createChangeViewComponent();
        this.myContent = new MyChangeViewContent(panel2, "Local Changes", false);
        this.myContent.setHelpId("ideaInterface.changes");
        this.myContent.setCloseable(false);
        this.myContentManager.addContent(this.myContent);
        this.scheduleRefresh();
        this.myProject.getMessageBus().connect().subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> this.scheduleRefresh());
        this.updatePreview(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        this.myView.removeTreeSelectionListener(this.myTsl);
        this.myView.removeGroupingChangeListener(this.myGroupingChangeListener);
        this.myDisposed = true;
        this.myTreeUpdateAlarm.cancelAllRequests();
        Object object = this.myTreeUpdateIndicatorLock;
        synchronized (object) {
            this.myTreeUpdateIndicator.cancel();
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        final ActionToolbar changesToolbar = this.createChangesToolbar();
        UIUtil.addBorder((JComponent)changesToolbar.getComponent(), (Border)IdeBorderFactory.createBorder((Color)JBColor.border(), (int)4));
        BorderLayoutPanel changesPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView))).addToLeft((Component)changesToolbar.getComponent());
        BorderLayoutPanel contentPanel = new BorderLayoutPanel(){

            public Dimension getMinimumSize() {
                return this.isMinimumSizeSet() ? super.getMinimumSize() : changesToolbar.getComponent().getPreferredSize();
            }
        };
        contentPanel.addToCenter((Component)changesPanel);
        if (VcsImplUtil.isNonModalCommit()) {
            contentPanel.addToBottom((Component)((Object)new ChangesViewCommitPanel(this.myProject)));
        }
        MyChangeProcessor changeProcessor = new MyChangeProcessor(this.myProject);
        this.mySplitterComponent = new PreviewDiffSplitterComponent((JComponent)contentPanel, changeProcessor, CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION, this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
        this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
        this.myView.getGroupingSupport().setGroupingKeysOrSkip(this.myState.groupingKeys);
        ChangesDnDSupport.install(this.myProject, this.myView);
        this.myView.addTreeSelectionListener(this.myTsl);
        this.myView.addGroupingChangeListener(this.myGroupingChangeListener);
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true){

            @NotNull
            public List<AnAction> getActions(boolean originalProvider) {
                return changesToolbar.getActions();
            }
        };
        this.myProgressLabel = JBUI.Panels.simplePanel();
        panel2.setContent((JComponent)JBUI.Panels.simplePanel((Component)((Object)this.mySplitterComponent)).addToBottom((Component)this.myProgressLabel));
        ChangesViewManager.registerShortcuts((JComponent)panel2);
        return panel2;
    }

    private static void registerShortcuts(@NotNull JComponent component) {
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.SetDefault", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 0x200 | ChangesViewManager.ctrlMask())), (JComponent)component);
        EmptyAction.registerWithShortcutSet((String)"Diff.ShowDiff", (ShortcutSet)CommonShortcuts.getDiff(), (JComponent)component);
    }

    @NotNull
    private ActionToolbar createChangesToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        DefaultActionGroup ignoreGroup = new DefaultActionGroup("Ignored Files", true);
        ignoreGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        ignoreGroup.add((AnAction)new ToggleShowIgnoredAction());
        ignoreGroup.add((AnAction)new IgnoredSettingsAction());
        group.add((AnAction)ignoreGroup);
        group.add(CommonActionsManager.getInstance().createExpandAllHeaderAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this.myView)));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)this.myTreeExpander, (JComponent)((Object)this.myView)));
        group.addSeparator();
        group.add((AnAction)new ToggleDetailsAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myView));
        return toolbar;
    }

    @JdkConstants.InputEventMask
    private static int ctrlMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    private void updateProgressComponent(@NotNull Factory<? extends JComponent> progress) {
        SwingUtilities.invokeLater(() -> {
            if (this.myProgressLabel != null) {
                this.myProgressLabel.removeAll();
                this.myProgressLabel.add((Component)progress.create());
                this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
            }
        });
    }

    @Override
    public void updateProgressText(String text, boolean isError) {
        this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text, isError));
    }

    @Override
    public void setBusy(boolean b) {
        UIUtil.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(String text, boolean isError) {
        return () -> {
            JLabel label2 = new JLabel(text);
            label2.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label2;
        };
    }

    @Override
    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        int was = this.myTreeUpdateAlarm.cancelAllRequests();
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule refresh, was " + was);
        }
        if (!this.myTreeUpdateAlarm.isDisposed()) {
            this.myTreeUpdateAlarm.addRequest(() -> this.refreshView(), 100);
        }
    }

    public void refreshImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTreeUpdateAlarm.cancelAllRequests();
        ProgressManager.getInstance().executeNonCancelableSection(() -> this.refreshView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        Object object = this.myTreeUpdateIndicatorLock;
        synchronized (object) {
            this.myTreeUpdateIndicator.cancel();
            this.myTreeUpdateIndicator = indicator;
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> this.lambda$refreshView$8((ProgressIndicator)indicator), (ProgressIndicator)indicator);
    }

    private void updatePreview(boolean fromModelRefresh) {
        if (this.mySplitterComponent != null) {
            this.mySplitterComponent.updatePreview(fromModelRefresh);
        }
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys = ContainerUtil.set((Object[])ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        this.myView.getGroupingSupport().setGroupingKeysOrSkip(ContainerUtil.set((Object[])new String[]{groupingKey}));
    }

    @Override
    public void selectFile(@Nullable VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes2) {
        ArrayList paths = new ArrayList();
        for (Change change : changes2) {
            ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
        }
        TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
    }

    @Override
    public void refreshChangesViewNodeAsync(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> this.refreshChangesViewNode(file2), this.myProject.getDisposed());
    }

    private void refreshChangesViewNode(@NotNull VirtualFile file2) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode node;
        VirtualFile userObject;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Object object = userObject = changeListManager.isUnversioned(file2) ? file2 : changeListManager.getChange(file2);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    @Nullable
    public static ChangesBrowserNode getDropRootNode(@NotNull Tree tree, @NotNull DnDEvent event) {
        RelativePoint dropPoint = event.getRelativePoint();
        Point onTree = dropPoint.getPoint((Component)tree);
        TreePath dropPath = tree.getPathForLocation(onTree.x, onTree.y);
        if (dropPath == null) {
            return null;
        }
        TreeNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
        while (!((DefaultMutableTreeNode)dropNode.getParent()).isRoot()) {
            dropNode = dropNode.getParent();
        }
        return dropNode;
    }

    private /* synthetic */ void lambda$refreshView$8(ProgressIndicator indicator) {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.getGrouping()).setChangeLists(changeListManager.getChangeListsCopy(), Registry.is((String)"vcs.skip.single.default.changelist")).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(changeListManager.getUnversionedFiles());
        if (this.myState.myShowIgnored) {
            treeModelBuilder.setIgnored(changeListManager.getIgnoredFiles(), changeListManager.isIgnoredInUpdateMode());
        }
        DefaultTreeModel newModel = treeModelBuilder.build();
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            indicator.checkCanceled();
            this.myModelUpdateInProgress = true;
            try {
                this.myView.updateModel(newModel);
            }
            finally {
                this.myModelUpdateInProgress = false;
            }
            this.updatePreview(true);
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    private class MyChangeViewContent
    extends DnDActivateOnHoldTargetContent {
        private MyChangeViewContent(@NotNull JComponent component, String displayName, boolean isLockable) {
            super(ChangesViewManager.this.myProject, component, displayName, isLockable);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(ChangesViewManager.this.myProject, (ShelvedChangeListDragBean)attachedObject, ChangesViewManager.getDropRootNode(ChangesViewManager.this.myView, event), !ChangesDnDSupport.isCopyAction(event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project) {
            super(project, "ChangesView");
            Disposer.register((Disposable)project, (Disposable)this);
            this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            boolean hasSelection;
            boolean bl = hasSelection = ChangesViewManager.this.myView.getSelectionCount() != 0;
            if (hasSelection) {
                return this.wrap(ChangesViewManager.this.myView.getSelectedChanges(), ChangesViewManager.this.myView.getSelectedUnversionedFiles());
            }
            return this.getAllChanges();
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            return this.wrap(ChangesViewManager.this.myView.getChanges(), ChangesViewManager.this.myView.getUnversionedFiles());
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            TreePath path = ChangesViewManager.this.myView.findNodePathInTree(change.getUserObject());
            if (path != null) {
                TreeUtil.selectPath((JTree)((Object)ChangesViewManager.this.myView), (TreePath)path, (boolean)false);
            }
        }

        @NotNull
        private List<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Stream<? extends Change> changes2, @NotNull Stream<? extends VirtualFile> unversioned) {
            return Stream.concat(changes2.map(ChangeViewDiffRequestProcessor.ChangeWrapper::new), unversioned.map(ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new)).collect(Collectors.toList());
        }
    }

    private class ToggleDetailsAction
    extends ShowDiffPreviewAction {
        private ToggleDetailsAction() {
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ChangesViewManager.this.mySplitterComponent.setDetailsOn(state);
            ((ChangesViewManager)ChangesViewManager.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = state;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ((ChangesViewManager)ChangesViewManager.this).myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }
    }

    private class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored = state;
            ChangesViewManager.this.refreshView();
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesViewManager.this.myView));
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            ChangesViewManager.this.setBusy(false);
            if (updateException == null) {
                Factory<JComponent> additionalUpdateInfo = changeListManager.getAdditionalUpdateInfo();
                if (additionalUpdateInfo != null) {
                    ChangesViewManager.this.updateProgressComponent((Factory<? extends JComponent>)additionalUpdateInfo);
                } else {
                    ChangesViewManager.this.updateProgressText("", false);
                }
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public Set<String> groupingKeys = ContainerUtil.newHashSet();
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }
}

