/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileGeneratorImpl
implements IgnoredFileGenerator {
    private static final Logger LOG = Logger.getInstance(IgnoredFileGeneratorImpl.class);
    private final Project myProject;
    private final Object myWriteLock = new Object();

    protected IgnoredFileGeneratorImpl(@NotNull Project project) {
        this.myProject = project;
    }

    public boolean generateFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs) throws IOException {
        return this.doGenerateOrAppend(ignoreFileRoot, vcs, false);
    }

    public boolean appendFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs) throws IOException {
        return this.doGenerateOrAppend(ignoreFileRoot, vcs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doGenerateOrAppend(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean append) throws IOException {
        IgnoredFileContentProvider ignoredFileContentProvider = this.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            LOG.debug("Cannot find content provider for vcs " + vcs.getName());
            return false;
        }
        String ignoreFileName = ignoredFileContentProvider.getFileName();
        if (!IgnoredFileGeneratorImpl.needGenerateIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS ignore file generation");
            return false;
        }
        Object object = this.myWriteLock;
        synchronized (object) {
            String ignoreFileContent = ignoredFileContentProvider.buildIgnoreFileContent(ignoreFileRoot, (IgnoredFileProvider[])IgnoredFileProvider.IGNORE_FILE.getExtensions());
            if (StringUtil.isEmptyOrSpaces((String)ignoreFileContent)) {
                return false;
            }
            File ignoreFile = IgnoredFileGeneratorImpl.getIgnoreFile(ignoreFileRoot, ignoreFileName);
            if (ignoreFile.exists() && !append) {
                return false;
            }
            String projectCharsetName = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName();
            FileUtil.writeToFile((File)ignoreFile, (byte[])ignoreFileContent.getBytes(projectCharsetName), (boolean)append);
            IgnoredFileRootStore.getInstance(this.myProject).addRoot(ignoreFile.getParent());
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(ignoreFile));
            return true;
        }
    }

    @Nullable
    private IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull AbstractVcs vcs) {
        IgnoredFileContentProvider[] contentProviders = (IgnoredFileContentProvider[])IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.getExtensions((AreaInstance)this.myProject);
        return Arrays.stream(contentProviders).filter(provider -> provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())).findFirst().orElse(null);
    }

    @NotNull
    private static File getIgnoreFile(@NotNull VirtualFile ignoreFileRoot, @NotNull String ignoreFileName) {
        File vcsRootFile = VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot);
        return new File(vcsRootFile.getPath(), ignoreFileName);
    }

    private static boolean needGenerateIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        boolean wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath());
        if (wasGeneratedPreviously) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
        }
        boolean needGenerateRegistryFlag = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        return !wasGeneratedPreviously && needGenerateRegistryFlag;
    }

    @com.intellij.openapi.components.State(name="IgnoredFileRootStore", storages={@Storage(value="$WORKSPACE_FILE$")})
    static class IgnoredFileRootStore
    implements PersistentStateComponent<State> {
        State myState = new State();

        IgnoredFileRootStore() {
        }

        static IgnoredFileRootStore getInstance(Project project) {
            return (IgnoredFileRootStore)ServiceManager.getService((Project)project, IgnoredFileRootStore.class);
        }

        boolean containsRoot(@NotNull String root) {
            return this.myState.generatedRoots.contains(root);
        }

        void addRoot(@NotNull String root) {
            this.myState.generatedRoots.add(root);
        }

        @Nullable
        public State getState() {
            return this.myState;
        }

        public void loadState(@NotNull State state) {
            this.myState = state;
        }

        static class State {
            public Set<String> generatedRoots = ContainerUtil.newHashSet();

            State() {
            }
        }
    }
}

