/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesCompositeHolder
implements FileHolder {
    private final Map<AbstractVcs, IgnoredFilesHolder> myVcsIgnoredHolderMap;
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;

    public IgnoredFilesCompositeHolder(Project project) {
        this.myProject = project;
        this.myVcsIgnoredHolderMap = new HashMap<AbstractVcs, IgnoredFilesHolder>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myVcsIgnoredHolderMap.values().forEach(FileHolder::cleanAll);
        this.myVcsIgnoredHolderMap.clear();
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        AbstractVcs vcs = scope.getVcs();
        if (this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            this.myVcsIgnoredHolderMap.get(vcs).cleanAndAdjustScope(scope);
        }
    }

    @Override
    public FileHolder copy() {
        IgnoredFilesCompositeHolder result2 = new IgnoredFilesCompositeHolder(this.myProject);
        for (Map.Entry<AbstractVcs, IgnoredFilesHolder> entry : this.myVcsIgnoredHolderMap.entrySet()) {
            result2.myVcsIgnoredHolderMap.put(entry.getKey(), (IgnoredFilesHolder)entry.getValue().copy());
        }
        return result2;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    public void addFile(@NotNull AbstractVcs vcs, @NotNull VirtualFile file2) {
        this.myVcsIgnoredHolderMap.get(vcs).addFile(file2);
    }

    public boolean isInUpdatingMode() {
        return this.myVcsIgnoredHolderMap.values().stream().anyMatch(holder -> holder instanceof VcsIgnoredFilesHolder && ((VcsIgnoredFilesHolder)holder).isInUpdatingMode());
    }

    public boolean containsFile(@NotNull VirtualFile file2) {
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        IgnoredFilesHolder ignoredFilesHolder = this.myVcsIgnoredHolderMap.get(vcs);
        return ignoredFilesHolder != null && ignoredFilesHolder.containsFile(file2);
    }

    @NotNull
    public Collection<VirtualFile> values() {
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(StreamEx.of(this.myVcsIgnoredHolderMap.values()).flatCollection(IgnoredFilesHolder::values).toSet());
        return result2;
    }

    public void notifyVcsStarted(AbstractVcs vcs) {
        if (!this.myVcsIgnoredHolderMap.containsKey(vcs)) {
            this.myVcsIgnoredHolderMap.put(vcs, IgnoredFilesCompositeHolder.getHolderForVcs(this.myProject, vcs));
        }
        for (FileHolder fileHolder : this.myVcsIgnoredHolderMap.values()) {
            fileHolder.notifyVcsStarted(vcs);
        }
    }

    @NotNull
    private static IgnoredFilesHolder getHolderForVcs(@NotNull Project project, AbstractVcs vcs) {
        for (VcsIgnoredFilesHolder.Provider provider : VcsIgnoredFilesHolder.VCS_IGNORED_FILES_HOLDER_EP.getExtensionList((AreaInstance)project)) {
            if (!provider.getVcs().equals((Object)vcs)) continue;
            return provider.createHolder();
        }
        return new RecursiveFileHolder(project, FileHolder.HolderType.IGNORED);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IgnoredFilesCompositeHolder)) {
            return false;
        }
        IgnoredFilesCompositeHolder other = (IgnoredFilesCompositeHolder)obj;
        return this.myVcsIgnoredHolderMap.equals(other.myVcsIgnoredHolderMap);
    }

    public int hashCode() {
        return Objects.hash(this.myVcsIgnoredHolderMap);
    }
}

