/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PreviewDiffSplitterComponent
extends JBSplitter {
    @NotNull
    private final JComponent myFirstComponent;
    @NotNull
    private final DiffPreviewUpdateProcessor myProcessor;
    private boolean myDetailsOn;

    public PreviewDiffSplitterComponent(@NotNull JComponent firstComponent, @NotNull DiffPreviewUpdateProcessor processor2, @NotNull String splitterDimensionKey, boolean detailsOn) {
        super(splitterDimensionKey, 0.5f);
        this.myFirstComponent = firstComponent;
        this.myProcessor = processor2;
        this.setFirstComponent(firstComponent);
        this.setDetailsOn(detailsOn);
    }

    public void updatePreview(boolean fromModelRefresh) {
        if (this.isDetailsOn()) {
            this.myProcessor.refresh(fromModelRefresh);
        } else {
            this.myProcessor.clear();
        }
    }

    private void updateVisibility() {
        this.setSecondComponent(this.myDetailsOn ? this.myProcessor.getComponent() : null);
        this.myFirstComponent.setBorder(this.myDetailsOn ? IdeBorderFactory.createBorder((int)5) : IdeBorderFactory.createBorder((int)1));
        JComponent secondComponent = this.getSecondComponent();
        if (secondComponent != null) {
            secondComponent.setMinimumSize((Dimension)JBUI.emptySize());
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isDetailsOn() {
        return this.myDetailsOn;
    }

    public void setDetailsOn(boolean detailsOn) {
        this.myDetailsOn = detailsOn;
        this.updatePreview(false);
        if (this.myDetailsOn == (this.getSecondComponent() == null)) {
            this.updateVisibility();
        }
    }
}

