/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RecursiveFileHolder
implements IgnoredFilesHolder {
    private final Project myProject;
    private final FileHolder.HolderType myHolderType;
    private final Set<VirtualFile> myMap;

    public RecursiveFileHolder(Project project, FileHolder.HolderType holderType) {
        this.myProject = project;
        this.myMap = new HashSet<VirtualFile>();
        this.myHolderType = holderType;
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    public void notifyVcsStarted(AbstractVcs scope) {
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myHolderType;
    }

    @Override
    public void addFile(@NotNull VirtualFile file2) {
        if (!this.containsFile(file2)) {
            this.myMap.add(file2);
        }
    }

    @Override
    public RecursiveFileHolder copy() {
        RecursiveFileHolder copyHolder = new RecursiveFileHolder(this.myProject, this.myHolderType);
        copyHolder.myMap.addAll(this.myMap);
        return copyHolder;
    }

    @Override
    public boolean containsFile(@NotNull VirtualFile file2) {
        if (this.myMap.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file2; parent != null; parent = parent.getParent()) {
            if (!this.myMap.contains(parent)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> values() {
        return this.myMap;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.myMap.iterator();
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next();
            if (!RecursiveFileHolder.isFileDirty((VcsDirtyScope)scope, file2)) continue;
            iterator.remove();
        }
    }

    private static boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (!file2.isValid()) {
            return true;
        }
        AbstractVcs[] vcsArr = new AbstractVcs[1];
        if (scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2), vcs -> {
            vcsArr[0] = vcs;
        })) {
            return true;
        }
        return vcsArr[0] == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveFileHolder that = (RecursiveFileHolder)o;
        return this.myMap.equals(that.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

