/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.collect.Iterables;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
implements FileHolder {
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final FileHolder.HolderType myHolderType;
    private final TreeMap<VirtualFile, Pair<Boolean, String>> myMap;

    public SwitchedFileHolder(Project project, FileHolder.HolderType holderType) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myMap = new TreeMap(FilePathComparator.getInstance());
        this.myHolderType = holderType;
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    public void notifyVcsStarted(AbstractVcs scope) {
    }

    @Override
    public FileHolder.HolderType getType() {
        return this.myHolderType;
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject, this.myHolderType);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.myMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next();
            if (!this.isFileDirty((VcsDirtyScope)scope, file2)) continue;
            iterator.remove();
        }
    }

    private boolean isFileDirty(VcsDirtyScope scope, VirtualFile file2) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file2)) {
            return true;
        }
        return scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2));
    }

    private boolean fileDropped(VirtualFile file2) {
        return !file2.isValid() || this.myVcsManager.getVcsFor(file2) == null;
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result2 = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.put(vf, (String)this.myMap.get(vf).getSecond());
        }
        return result2;
    }

    @NotNull
    public Collection<VirtualFile> values() {
        return this.myMap.keySet();
    }

    public void addFile(VirtualFile file2, String branch, boolean recursive) {
        this.myMap.put(file2, (Pair<Boolean, String>)new Pair((Object)recursive, (Object)branch));
    }

    public void removeFile(@NotNull VirtualFile file2) {
        this.myMap.remove(file2);
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result2 = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.putValue(this.myMap.get(vf).getSecond(), (Object)vf);
        }
        return result2;
    }

    public synchronized boolean containsFile(@NotNull VirtualFile file2) {
        VirtualFile floor = this.myMap.floorKey(file2);
        if (floor == null) {
            return false;
        }
        NavigableMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file2) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file2) {
        VirtualFile floor = this.myMap.floorKey(file2);
        if (floor == null) {
            return null;
        }
        SortedMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file2, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchedFileHolder that = (SwitchedFileHolder)o;
        return Iterables.elementsEqual(this.myMap.entrySet(), that.myMap.entrySet());
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

