/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class VcsConfirmationDialog
extends OptionsDialog {
    @NotNull
    private final String myOkText;
    @NotNull
    private final String myCancelText;
    private final VcsShowConfirmationOption myOption;
    private final String myMessage;
    private final String myDoNotShowMessage;

    VcsConfirmationDialog(@NotNull Project project, @NotNull String title, @NotNull String okText, @NotNull String cancelText, @NotNull VcsShowConfirmationOption option2, @NotNull String message, @NotNull String doNotShowMessage) {
        super(project);
        this.myOkText = okText;
        this.myCancelText = cancelText;
        this.myOption = option2;
        this.myMessage = message;
        this.myDoNotShowMessage = doNotShowMessage;
        this.setTitle(title);
        this.init();
    }

    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        this.myOption.setValue(value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY));
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(15, 0));
        panel2.add(new JLabel(this.myMessage));
        panel2.add((Component)new JLabel(Messages.getQuestionIcon()), "West");
        return panel2;
    }

    @NotNull
    protected String getDoNotShowMessage() {
        return this.myDoNotShowMessage;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        AbstractAction okAction = new AbstractAction(this.myOkText){
            {
                this.putValue("DefaultAction", Boolean.TRUE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doOKAction();
            }
        };
        AbstractAction cancelAction = new AbstractAction(this.myCancelText){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsConfirmationDialog.this.doCancelAction();
            }
        };
        if (SystemInfo.isMac) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = cancelAction;
            actionArray = actionArray2;
            actionArray2[1] = okAction;
        } else {
            Action[] actionArray3 = new Action[2];
            actionArray3[0] = okAction;
            actionArray = actionArray3;
            actionArray3[1] = cancelAction;
        }
        return actionArray;
    }
}

