/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ByteBackedContentRevision {
    @NotNull
    private final DiffProvider myDiffProvider;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(@NotNull VirtualFile file2, @NotNull Project project) {
        DiffProvider diffProvider;
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        if (vcs != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file2, project, vcs.getKeyInstanceMethod());
        }
        return null;
    }

    private VcsCurrentRevisionProxy(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file2, @NotNull Project project, @NotNull VcsKey vcsKey) {
        this.myDiffProvider = diffProvider;
        this.myFile = file2;
        this.myProject = project;
        this.myVcsKey = vcsKey;
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.getFile(), (Charset)this.myFile.getCharset());
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        return (byte[])this.getVcsRevision().second;
    }

    @NotNull
    public FilePath getFile() {
        return VcsUtil.getFilePath((VirtualFile)this.myFile);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        try {
            return (VcsRevisionNumber)this.getVcsRevision().first;
        }
        catch (VcsException ex) {
            return VcsRevisionNumber.NULL;
        }
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> getVcsRevision() throws VcsException {
        try {
            return ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myProject, (FilePath)this.getFile(), (VcsKey)this.myVcsKey, (CurrentRevisionProvider)new CurrentRevisionProvider(){

                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException("Failed to fetch current revision");
        }
        return currentRevision;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        byte[] bytes;
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException("Failed to create content for current revision");
        }
        if (contentRevision instanceof ByteBackedContentRevision) {
            bytes = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
        } else {
            String content = contentRevision.getContent();
            if (content == null) {
                throw new VcsException("Can't get revision content");
            }
            bytes = content.getBytes(this.myFile.getCharset());
        }
        return Pair.create((Object)currentRevision, (Object)bytes);
    }
}

