/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@Nullable FilePath path) {
            if (path == null) {
                return 0;
            }
            return Objects.hash(path.getPath(), path.isDirectory(), path.isNonLocal());
        }

        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == null || path2 == null) {
                return path1 == path2;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.isNonLocal() == path2.isNonLocal() && path1.getPath().equals(path2.getPath());
        }
    };
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcs myVcs;
    private final VcsDirtyScopeModifier myVcsDirtyScopeModifier;
    private final boolean myWasEverythingDirty;

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project) {
        this(vcs, project, false);
    }

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project, boolean wasEverythingDirty) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myWasEverythingDirty = wasEverythingDirty;
        this.myVcsDirtyScopeModifier = new VcsDirtyScopeModifier(){

            @NotNull
            public Iterator<FilePath> getDirtyFilesIterator() {
                return this.iterateMap(VcsDirtyScopeImpl.this.myDirtyFiles);
            }

            @NotNull
            public Iterator<FilePath> getDirtyDirectoriesIterator() {
                return this.iterateMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
            }

            public void recheckDirtyKeys() {
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyFiles);
            }

            @NotNull
            private Iterator<FilePath> iterateMap(@NotNull Map<VirtualFile, THashSet<FilePath>> map2) {
                return ContainerUtil.concatIterators((Collection)ContainerUtil.map(map2.values(), THashSet::iterator));
            }

            private void recheckMap(@NotNull Map<VirtualFile, THashSet<FilePath>> map2) {
                Iterator<THashSet<FilePath>> iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    THashSet<FilePath> next = iterator.next();
                    if (!next.isEmpty()) continue;
                    iterator.remove();
                }
            }
        };
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    result2.add((Object)VcsUtil.getFilePath((VirtualFile)child2));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet<FilePath> paths = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot);
        }
        return result2;
    }

    public boolean isRecursivelyDirty(VirtualFile vf) {
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            for (FilePath dir : dirsByRoot) {
                VirtualFile dirVf = dir.getVirtualFile();
                if (dirVf == null || !VfsUtilCore.isAncestor((VirtualFile)dirVf, (VirtualFile)vf, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDirtyData(@NotNull Collection<? extends FilePath> dirs, @NotNull Collection<? extends FilePath> files2) {
        HashMap<VirtualFile, THashSet<FilePath>> perRootDirs = new HashMap<VirtualFile, THashSet<FilePath>>();
        HashMap<VirtualFile, THashSet<FilePath>> perRootFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyDirectoriesRecursively.entrySet()) {
            perRootDirs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            perRootFiles.put(entry.getKey(), entry.getValue());
        }
        this.addFilePathsToMap(dirs, perRootDirs);
        this.addFilePathsToMap(files2, perRootFiles);
        this.myAffectedContentRoots.addAll(perRootDirs.keySet());
        this.myAffectedContentRoots.addAll(perRootFiles.keySet());
        for (VirtualFile root : this.myAffectedContentRoots) {
            Set rootDirs = ContainerUtil.notNullize((Set)((Set)perRootDirs.get(root)));
            Set rootFiles = ContainerUtil.notNullize((Set)((Set)perRootFiles.get(root)));
            THashSet<FilePath> filteredDirs = VcsDirtyScopeImpl.removeAncestorsRecursive(rootDirs);
            THashSet<FilePath> filteredFiles = VcsDirtyScopeImpl.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            this.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            this.myDirtyFiles.put(root, filteredFiles);
        }
    }

    private void addFilePathsToMap(@NotNull Collection<? extends FilePath> paths, @NotNull Map<VirtualFile, THashSet<FilePath>> pathsMap) {
        for (FilePath filePath : paths) {
            VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(filePath);
            if (vcsRoot == null) continue;
            THashSet<FilePath> set2 = pathsMap.get(vcsRoot);
            if (set2 == null) {
                set2 = VcsDirtyScopeImpl.newFilePathsSet();
                pathsMap.put(vcsRoot, set2);
            }
            set2.add((Object)filePath);
        }
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsRecursive(@NotNull Collection<? extends FilePath> dirs) {
        List paths = ContainerUtil.sorted(dirs, Comparator.comparingInt(it -> it.getPath().length()));
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath path : paths) {
            if (VcsDirtyScopeImpl.hasAncestor(result2, path)) continue;
            result2.add((Object)path);
        }
        return result2;
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsNonRecursive(@NotNull Set<? extends FilePath> dirs, @NotNull Set<? extends FilePath> files2) {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath filePath : files2) {
            if (VcsDirtyScopeImpl.hasAncestor(dirs, filePath) || !filePath.isDirectory() && files2.contains(filePath.getParentPath())) continue;
            result2.add((Object)filePath);
        }
        return result2;
    }

    private static boolean hasAncestor(@NotNull Set<? extends FilePath> dirs, @NotNull FilePath filePath) {
        for (FilePath filePath2 : dirs) {
            if (!VcsDirtyScopeImpl.isAncestor(filePath, filePath2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull FilePath filePath, @NotNull FilePath parent) {
        return FileUtil.startsWith((String)filePath.getPath(), (String)parent.getPath());
    }

    @NotNull
    private static THashSet<FilePath> newFilePathsSet() {
        return new THashSet(CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            THashSet<FilePath> files2;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files2 = entry.getValue()) == null) continue;
            Iterator it = files2.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (!VcsDirtyScopeImpl.isAncestor(oldBoy, newcomer)) continue;
                it.remove();
            }
        }
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = VcsDirtyScopeImpl.newFilePathsSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            Iterator it = dirsByRoot.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (VcsDirtyScopeImpl.isAncestor(newcomer, oldBoy)) {
                    return;
                }
                if (!VcsDirtyScopeImpl.isAncestor(oldBoy, newcomer)) continue;
                it.remove();
            }
        }
        dirsByRoot.add((Object)newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && VcsDirtyScopeImpl.hasAncestor(dirsByRoot, newcomer)) {
            return;
        }
        THashSet<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = VcsDirtyScopeImpl.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = (FilePath)iterator.next();
                if (oldBoy.isDirectory() || !CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)oldBoy.getParentPath(), (Object)newcomer)) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains((Object)parent)) {
            return;
        }
        dirtyFiles.add((Object)newcomer);
    }

    public void iterate(Processor<? super FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file2 : files2) {
                iterator.process((Object)file2);
                vFile = file2.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    iterator.process((Object)VcsUtil.getFilePath((VirtualFile)child2));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<? super VirtualFile> processor2) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor2);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file2 : files2) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file2);
                if (vFile == null || !vFile.isValid()) continue;
                processor2.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child2 : vFile.getChildren()) {
                    processor2.process((Object)child2);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file2) {
        VirtualFile vFile = file2.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file2.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path, Consumer<? super AbstractVcs> vcsConsumer) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        if (vcsConsumer != null && rootObject != null) {
            vcsConsumer.consume((Object)rootObject.getVcs());
        }
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        if (vcsRoot != null) {
            boolean pathIsRoot = vcsRoot.equals(path.getVirtualFile());
            for (VirtualFile contentRoot : this.myAffectedContentRoots) {
                THashSet<FilePath> dirsByRoot;
                boolean strict;
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || (dirsByRoot = this.myDirtyDirectoriesRecursively.get(contentRoot)) == null || !VcsDirtyScopeImpl.hasAncestor(dirsByRoot, path)) continue;
                return true;
            }
        }
        if (!this.myDirtyFiles.isEmpty()) {
            FilePath parent = path.getParentPath();
            return this.isInDirtyFiles(path) || this.isInDirtyFiles(parent);
        }
        return false;
    }

    private boolean isInDirtyFiles(FilePath path) {
        THashSet<FilePath> files2;
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        return rootObject != null && this.myVcs.equals((Object)rootObject.getVcs()) && (files2 = this.myDirtyFiles.get(rootObject.getPath())) != null && files2.contains((Object)path);
    }

    public boolean belongsTo(FilePath path) {
        return this.belongsTo(path, null);
    }

    @NonNls
    public String toString() {
        StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file2 : paths) {
                    result2.append(file2).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file2 : dirsByRoot) {
                    result2.append(file2).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public VcsDirtyScopeModifier getModifier() {
        return this.myVcsDirtyScopeModifier;
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }
}

