/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(VcsDirtyScopeManagerImpl.class);
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private final VcsGuess myGuess;
    private final DirtBuilder myDirtBuilder;
    @Nullable
    private DirtBuilder myDirtInProgress;
    private boolean myReady;
    private final Object LOCK = new Object();

    public VcsDirtyScopeManagerImpl(Project project, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)vcsManager;
        this.myGuess = new VcsGuess(this.myProject);
        this.myDirtBuilder = new DirtBuilder();
        ((ChangeListManagerImpl)this.myChangeListManager).setDirtyScopeManager(this);
    }

    public void projectOpened() {
        this.myVcsManager.addInitializationRequest(VcsInitObject.DIRTY_SCOPE_MANAGER, () -> {
            boolean ready = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                    ready = true;
                    this.myReady = true;
                }
            }
            if (ready) {
                VcsDirtyScopeVfsListener.install(this.myProject);
                this.markEverythingDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || this.myVcsManager.getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myReady) {
                this.myDirtBuilder.everythingDirty();
            }
        }
        this.myChangeListManager.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder.reset();
            this.myDirtInProgress = null;
        }
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> groupByVcs(@Nullable Collection<? extends FilePath> from) {
        if (from == null) {
            return MultiMap.empty();
        }
        MultiMap map2 = MultiMap.createSet();
        for (FilePath filePath : from) {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(filePath);
            if (vcs == null) continue;
            map2.putValue((Object)vcs, (Object)filePath);
        }
        return map2;
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> groupFilesByVcs(@Nullable Collection<? extends VirtualFile> from) {
        if (from == null) {
            return MultiMap.empty();
        }
        MultiMap map2 = MultiMap.createSet();
        for (VirtualFile virtualFile : from) {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(virtualFile);
            if (vcs == null) continue;
            map2.putValue((Object)vcs, (Object)VcsUtil.getFilePath((VirtualFile)virtualFile));
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileVcsPathsDirty(@NotNull MultiMap<AbstractVcs, FilePath> filesConverted, @NotNull MultiMap<AbstractVcs, FilePath> dirsConverted) {
        boolean hasSomethingDirty;
        if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("dirty files: %s; dirty dirs: %s; %s", VcsDirtyScopeManagerImpl.toString(filesConverted), VcsDirtyScopeManagerImpl.toString(dirsConverted), VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass()));
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return;
            }
            VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, filesConverted, false);
            VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, dirsConverted, true);
            hasSomethingDirty = !this.myDirtBuilder.isEmpty();
        }
        if (hasSomethingDirty) {
            this.myChangeListManager.scheduleUpdate();
        }
    }

    private static void markDirty(@NotNull DirtBuilder dirtBuilder, @NotNull MultiMap<AbstractVcs, FilePath> filesOrDirs, boolean recursively) {
        for (AbstractVcs vcs : filesOrDirs.keySet()) {
            for (FilePath path : filesOrDirs.get((Object)vcs)) {
                if (recursively) {
                    dirtBuilder.addDirtyDirRecursively(vcs, path);
                    continue;
                }
                dirtBuilder.addDirtyFile(vcs, path);
            }
        }
    }

    public void filePathsDirty(@Nullable Collection<? extends FilePath> filesDirty, @Nullable Collection<? extends FilePath> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupByVcs(filesDirty), this.groupByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void filesDirty(@Nullable Collection<? extends VirtualFile> filesDirty, @Nullable Collection<? extends VirtualFile> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupFilesByVcs(filesDirty), this.groupFilesByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    @NotNull
    private static Collection<FilePath> toFilePaths(@Nullable Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.map(files2, virtualFile -> VcsUtil.getFilePath((VirtualFile)virtualFile));
    }

    public void fileDirty(@NotNull VirtualFile file2) {
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file2));
    }

    public void fileDirty(@NotNull FilePath file2) {
        this.filePathsDirty(Collections.singleton(file2), null);
    }

    public void dirDirtyRecursively(@NotNull VirtualFile dir) {
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(@NotNull FilePath path) {
        this.filePathsDirty(null, Collections.singleton(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            this.myDirtInProgress = dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            this.myDirtBuilder.reset();
        }
        return this.calculateInvalidated(dirtBuilder);
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt) {
        MultiMap<AbstractVcs, FilePath> files2 = dirt.getFilesForVcs();
        MultiMap<AbstractVcs, FilePath> dirs = dirt.getDirsForVcs();
        boolean isEverythingDirty = dirt.isEverythingDirty();
        if (isEverythingDirty) {
            dirs.putAllValues(this.getEverythingDirtyRoots());
        }
        Set keys = ContainerUtil.union((Set)files2.keySet(), (Set)dirs.keySet());
        HashMap scopes = ContainerUtil.newHashMap();
        for (AbstractVcs key : keys) {
            VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl(key, this.myProject, isEverythingDirty);
            scopes.put(key, scope);
            scope.addDirtyData(dirs.get((Object)key), files2.get((Object)key));
        }
        return new VcsInvalidated(new ArrayList(scopes.values()), isEverythingDirty);
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> getEverythingDirtyRoots() {
        MultiMap dirtyRoots = MultiMap.createSet();
        dirtyRoots.putAllValues(this.groupFilesByVcs(DefaultVcsRootPolicy.getInstance(this.myProject).getDirtyRoots()));
        List<VcsDirectoryMapping> mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsDirectoryMapping mapping : mappings) {
            AbstractVcs vcs;
            if (mapping.isDefaultMapping() || mapping.getVcs() == null || (vcs = this.myVcsManager.findVcsByName(mapping.getVcs())) == null) continue;
            dirtyRoots.putValue((Object)vcs, (Object)VcsUtil.getFilePath((String)mapping.getDirectory(), (boolean)true));
        }
        return dirtyRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<? extends FilePath> files2) {
        DirtBuilder dirtBuilderInProgress;
        DirtBuilder dirtBuilder;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return Collections.emptyList();
            }
            dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            dirtBuilderInProgress = this.myDirtInProgress != null ? new DirtBuilder(this.myDirtInProgress) : new DirtBuilder();
        }
        VcsInvalidated invalidated = this.calculateInvalidated(dirtBuilder);
        VcsInvalidated inProgress = this.calculateInvalidated(dirtBuilderInProgress);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (FilePath filePath : files2) {
            if (!invalidated.isFileDirty(filePath) && !inProgress.isFileDirty(filePath)) continue;
            result2.add(filePath);
        }
        return result2;
    }

    @NotNull
    private static String toString(@NotNull MultiMap<AbstractVcs, FilePath> filesByVcs) {
        return StringUtil.join((Collection)filesByVcs.keySet(), vcs -> vcs.getName() + ": " + StringUtil.join((Collection)filesByVcs.get(vcs), path -> path.getPath(), (String)"\n"), (String)"\n");
    }

    @Nullable
    private static Class findFirstInterestingCallerClass() {
        for (int i = 1; i <= 5; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }
}

