/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.ProblemListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class VcsEventWatcher
implements ProjectComponent {
    private final Project myProject;

    public VcsEventWatcher(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManager.getInstance((Project)VcsEventWatcher.this.myProject).markEverythingDirty(), ModalityState.NON_MODAL, VcsEventWatcher.this.myProject.getDisposed());
            }
        });
        connection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file2);
            }
        });
    }
}

