/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsGuess {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public VcsGuess(@NotNull Project project) {
        this.myProject = project;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull VirtualFile file2) {
        if (file2.isInLocalFileSystem() && this.isFileInIndex(null, file2)) {
            return this.myVcsManager.getVcsFor(file2);
        }
        return null;
    }

    @Nullable
    public AbstractVcs getVcsForDirty(@NotNull FilePath filePath) {
        if (filePath.isNonLocal()) {
            return null;
        }
        VirtualFile validParent = ChangesUtil.findValidParentAccurately((FilePath)filePath);
        if (validParent != null && this.isFileInIndex(filePath, validParent)) {
            return this.myVcsManager.getVcsFor(validParent);
        }
        return null;
    }

    private boolean isFileInIndex(@Nullable FilePath filePath, @NotNull VirtualFile validParent) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            boolean inContent = this.myVcsManager.isFileInContent(validParent);
            if (inContent) {
                return true;
            }
            if (filePath != null) {
                return VcsGuess.isFileInBaseDir(filePath, this.myProject.getBaseDir()) && !this.myVcsManager.isIgnored(validParent);
            }
            return false;
        });
    }

    private static boolean isFileInBaseDir(@NotNull FilePath filePath, @Nullable VirtualFile baseDir) {
        VirtualFile parent = filePath.getVirtualFileParent();
        return !filePath.isDirectory() && parent != null && parent.equals(baseDir);
    }
}

